/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.lang.javascript.modules.JsModulesSuggester;
import com.intellij.lang.javascript.modules.ModuleFixCreator;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.modules.NodeJSModulesSearcher;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class NodeJsModulesSuggesterBase
implements JsModulesSuggester {
    @NotNull
    protected final LocalInspectionToolSession mySession;
    @NotNull
    protected final Set<VirtualFile> myPredefinedFiles;
    @NotNull
    protected final ModuleReferenceInfo myModuleReferenceInfo;
    @NotNull
    protected final PsiElement myNode;

    public NodeJsModulesSuggesterBase(@NotNull LocalInspectionToolSession session, @NotNull Set<VirtualFile> predefinedFiles, @NotNull ModuleReferenceInfo moduleReferenceInfo, @NotNull PsiElement node) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/lang/javascript/modules/NodeJsModulesSuggesterBase", "<init>"));
        }
        if (predefinedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predefinedFiles", "com/intellij/lang/javascript/modules/NodeJsModulesSuggesterBase", "<init>"));
        }
        if (moduleReferenceInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleReferenceInfo", "com/intellij/lang/javascript/modules/NodeJsModulesSuggesterBase", "<init>"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/modules/NodeJsModulesSuggesterBase", "<init>"));
        }
        this.mySession = session;
        this.myPredefinedFiles = predefinedFiles;
        this.myModuleReferenceInfo = moduleReferenceInfo;
        this.myNode = node;
    }

    @Override
    public boolean isResolvedGlobally(@NotNull ResolveResult result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/modules/NodeJsModulesSuggesterBase", "isResolvedGlobally"));
        }
        return NodeModuleUtil.isResolvedGloballyCommonJS(result, this.myPredefinedFiles, this.mySession);
    }

    @NotNull
    protected List<ModuleFixCreator.FixDescriptor> find(@NotNull ResolveResult[] resolveResults, boolean onlyCommonJS) {
        if (resolveResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResults", "com/intellij/lang/javascript/modules/NodeJsModulesSuggesterBase", "find"));
        }
        VirtualFile root = NodeModuleUtil.getMainModuleRoot(this.mySession);
        if (root == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/NodeJsModulesSuggesterBase", "find"));
            }
            return list;
        }
        List<ModuleFixCreator.FixDescriptor> list = new NodeJSModulesSearcher(root, this.myModuleReferenceInfo, this.myNode, resolveResults, this.myPredefinedFiles, onlyCommonJS).find();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/NodeJsModulesSuggesterBase", "find"));
        }
        return list;
    }
}

