/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyReference;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSNamedObjectStubBase;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSDestructuringPropertyBase<T extends JSDestructuringProperty, StubT extends JSNamedObjectStubBase<T>>
extends JSStubElementImpl<StubT>
implements JSDestructuringProperty,
StubBasedPsiElement<StubT> {
    protected JSDestructuringPropertyBase(ASTNode node) {
        super(node);
    }

    protected JSDestructuringPropertyBase(StubT t, IStubElementType type) {
        super(t, type);
    }

    public PsiReference getReference() {
        return (PsiReference)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)((Object)this.calcReference()), (Object[])new Object[]{this}));
    }

    @Nullable
    private JSDestructuringPropertyReference calcReference() {
        return JSDestructuringUtil.isDestructuring(this.getParent()) ? new JSDestructuringPropertyReference(this) : null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSDestructuringPropertyBase", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSDestructuringProperty((JSDestructuringProperty)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Nullable
    public JSInitializerOwner getDestructuringElement() {
        return (JSInitializerOwner)JSStubBasedPsiTreeUtil.getStubOrPsiChild(this, JSExtendedLanguagesTokenSetProvider.INITIALIZER_OWNERS);
    }

    public static ASTNode getDestructuringElement(@NotNull ASTNode destructuringProperty) {
        if (destructuringProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destructuringProperty", "com/intellij/lang/javascript/psi/impl/JSDestructuringPropertyBase", "getDestructuringElement"));
        }
        return destructuringProperty.findChildByType(JSExtendedLanguagesTokenSetProvider.INITIALIZER_OWNERS);
    }

    public String getName() {
        JSNamedObjectStubBase stub = (JSNamedObjectStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        String name = this.getNameTextImpl();
        if (name != null) {
            return StringUtil.unquoteString((String)name);
        }
        return null;
    }

    @Nullable
    protected PsiElement getNameIdentifierForPropertyOrNestedElement() {
        PsiElement identifierName = this.findChildByType(JSKeywordSets.IDENTIFIER_NAMES);
        if (identifierName != null) {
            return identifierName;
        }
        JSInitializerOwner destructuringElement = this.getDestructuringElement();
        if (destructuringElement instanceof PsiNameIdentifierOwner) {
            return ((PsiNameIdentifierOwner)destructuringElement).getNameIdentifier();
        }
        return null;
    }

    @Nullable
    protected abstract String getNameTextImpl();
}

