/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSElementImpl
extends CompositePsiElement
implements JSElement {
    @NonNls
    private static final String IMPL = "Impl";
    private Language myLanguage;

    public JSElementImpl(IElementType elementType) {
        super(elementType);
    }

    @NotNull
    public Language getLanguage() {
        if (this.myLanguage == null) {
            Language language = DialectDetector.languageOfElement((PsiElement)this);
            this.myLanguage = language instanceof JSLanguageDialect ? language : JavascriptLanguage.INSTANCE;
        }
        Language language = this.myLanguage;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSElementImpl", "getLanguage"));
        }
        return language;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSElementImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSElement((JSElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        String classname = ((Object)((Object)this)).getClass().getName();
        classname = StringUtil.trimEnd((String)classname, (String)IMPL);
        classname = classname.substring(classname.lastIndexOf(".") + 1);
        if (!ApplicationManager.getApplication().isUnitTestMode() && this instanceof JSNamedElement) {
            classname = classname + ":";
            String name = this.getName();
            classname = classname + (name != null ? name : "<anonymous>");
        }
        return classname;
    }

    public ItemPresentation getPresentation() {
        if (this instanceof JSPsiElementBase) {
            return new JSItemPresentation((JSPsiElementBase)this);
        }
        return null;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = JSResolveUtil.getResolveScope((PsiElement)this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSElementImpl", "getResolveScope"));
        }
        return globalSearchScope;
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSElementImpl", "addBefore"));
        }
        if (JSChangeUtil.isStatementOrComment(element)) {
            if (JSChangeUtil.isStatementContainer((PsiElement)this)) {
                return JSChangeUtil.doAddBefore((PsiElement)this, element, anchor);
            }
            if (JSChangeUtil.isBlockStatementContainer(this) && anchor != null) {
                return JSChangeUtil.blockDoAddBefore(element, anchor);
            }
        }
        return super.addBefore(element, anchor);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSElementImpl", "addAfter"));
        }
        if (JSChangeUtil.isStatementOrComment(element)) {
            if (JSChangeUtil.isStatementContainer((PsiElement)this)) {
                return JSChangeUtil.doAddAfter((PsiElement)this, element, anchor);
            }
            if (JSChangeUtil.isBlockStatementContainer(this) && anchor != null) {
                return JSChangeUtil.blockDoAddAfter(element, anchor);
            }
        }
        return super.addAfter(element, anchor);
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSElementImpl", "add"));
        }
        return this.addAfter(element, null);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/psi/impl/JSElementImpl", "replace"));
        }
        ASTNode myNode = this.getNode();
        ASTNode result = newElement.getNode().copyElement();
        myNode.getTreeParent().replaceChild(myNode, result);
        return result.getPsi();
    }
}

