/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.lang.javascript.psi.impl.JSReferenceSetElement;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReferenceSet {
    protected String myReferenceText;
    protected int myOffset;
    protected PsiReference[] myReferences;
    @NotNull
    final PsiElement element;
    private final boolean isSoft;
    final boolean onlyFqns;
    protected boolean myOnlyDefaultPackage;
    @Nullable
    Collection<String> myBaseClassFqns;
    @Nullable
    LocalQuickFixProvider myLocalQuickFixProvider;

    public JSReferenceSet(@NotNull PsiElement element, String text, int offset, boolean soft) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSReferenceSet", "<init>"));
        }
        this(element, text, offset, soft, false);
    }

    public JSReferenceSet(@NotNull PsiElement element, String text, int offset, boolean soft, boolean _onlyFqns) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSReferenceSet", "<init>"));
        }
        this.element = element;
        this.isSoft = soft;
        this.myReferenceText = text;
        this.myOffset = offset;
        this.myReferences = this.reparse(text, offset);
        this.onlyFqns = _onlyFqns;
    }

    public JSReferenceSet(@NotNull PsiElement element, boolean soft) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSReferenceSet", "<init>"));
        }
        this.element = element;
        this.isSoft = soft;
        this.onlyFqns = false;
    }

    public JSReferenceSet(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSReferenceSet", "<init>"));
        }
        this(element, true);
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSReferenceSet", "getElement"));
        }
        return psiElement;
    }

    public void setBaseClassFqns(@NotNull Collection<String> baseClassFqns) {
        if (baseClassFqns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClassFqns", "com/intellij/lang/javascript/psi/impl/JSReferenceSet", "setBaseClassFqns"));
        }
        this.myBaseClassFqns = new ArrayList<String>(baseClassFqns);
    }

    public String[] getBaseClassFqns() {
        return this.myBaseClassFqns == null ? ArrayUtil.EMPTY_STRING_ARRAY : ArrayUtil.toStringArray(this.myBaseClassFqns);
    }

    public PsiReference[] getReferences() {
        return this.myReferences;
    }

    public void update(String text, int offset) {
        if (this.myReferences != null && this.myReferenceText != null && this.myReferenceText.equals(text) && this.myOffset == offset) {
            return;
        }
        this.myReferenceText = text;
        this.myOffset = offset;
        this.myReferences = StringUtil.startsWithChar((CharSequence)text, (char)'\"') || StringUtil.startsWithChar((CharSequence)text, (char)'\'') ? this.reparse(StringUtil.unquoteString((String)text), offset + 1) : PsiReference.EMPTY_ARRAY;
    }

    protected PsiReference[] reparse(String value, int offset) {
        ArrayList<JSReferenceSetElement> refs = new ArrayList<JSReferenceSetElement>(1);
        int lastPos = 0;
        int dotPos = this.findSeparatorPosition(value, lastPos);
        while (dotPos != -1) {
            String s = value.substring(lastPos, dotPos).trim();
            if (s.length() > 0) {
                refs.add(this.createTextReference(s, offset + lastPos, false));
            }
            lastPos = dotPos + 1;
            dotPos = this.findSeparatorPosition(value, lastPos);
        }
        int end = value.length();
        String substring = value.substring(lastPos, end);
        String s = substring.trim();
        if (s.length() > 0) {
            int index;
            for (index = 0; index < substring.length() && Character.isWhitespace(substring.charAt(index)); ++index) {
            }
            refs.add(this.createTextReference(s, offset + lastPos + index, lastPos > 0 && value.charAt(lastPos - 1) == '#'));
        }
        return refs.size() > 0 ? refs.toArray(new PsiReference[refs.size()]) : PsiReference.EMPTY_ARRAY;
    }

    protected JSReferenceSetElement createTextReference(String s, int offset, boolean methodRef) {
        return new JSTextReference(this, s, offset, methodRef);
    }

    protected int findSeparatorPosition(String s, int fromIndex) {
        if (StringUtil.isQuotedString((String)s)) {
            return -1;
        }
        return s.indexOf(46, fromIndex);
    }

    public boolean isSoft() {
        return this.isSoft;
    }

    public void setLocalQuickFixProvider(@Nullable LocalQuickFixProvider localQuickFixProvider) {
        this.myLocalQuickFixProvider = localQuickFixProvider;
    }
}

