/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.impl.JSStatementImpl;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSWithStatementImpl
extends JSStatementImpl
implements JSWithStatement {
    public JSWithStatementImpl(IElementType elementType) {
        super(elementType);
    }

    public JSExpression getExpression() {
        ASTNode node = this.getNode().findChildByType(JSElementTypes.EXPRESSIONS);
        return node != null ? (JSExpression)node.getPsi() : null;
    }

    public JSStatement getStatement() {
        ASTNode node = this.getNode().findChildByType(JSExtendedLanguagesTokenSetProvider.STATEMENTS);
        return node != null ? (JSStatement)node.getPsi() : null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSWithStatementImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSWithStatement((JSWithStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSWithStatementImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSWithStatementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/impl/JSWithStatementImpl", "processDeclarations"));
        }
        JSExpression expression = this.getExpression();
        if (expression != null && processor instanceof ResolveProcessor) {
            final ResolveProcessor resolveProcessor = (ResolveProcessor)processor;
            if (resolveProcessor.isLocalResolve()) {
                return true;
            }
            PsiFile containingFile = expression.getContainingFile();
            QualifiedItemProcessor<1> qualifiedItemProcessor = new QualifiedItemProcessor<1>(new ResultSink(place){

                @Override
                public String getName() {
                    return resolveProcessor.getName();
                }
            }, containingFile);
            JSTypeEvaluator.evaluateTypes(expression, containingFile, qualifiedItemProcessor);
            List<PsiElement> elementList = qualifiedItemProcessor.getResults();
            if (elementList != null) {
                for (PsiElement e : elementList) {
                    if (processor.execute(e, state)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

