/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSClassBase;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JSCollectMembersToImplementProcessor
extends ResolveProcessor {
    private final boolean myProcessAll;
    private final NotNullLazyValue<SinkResolveProcessor<?>> myInterfacesProcessor = new NotNullLazyValue<SinkResolveProcessor<?>>(){

        @NotNull
        protected SinkResolveProcessor<?> compute() {
            SinkResolveProcessor sinkResolveProcessor = JSCollectMembersToImplementProcessor.this.createProcessor(JSCollectMembersToImplementProcessor.this.createResultSink());
            if (sinkResolveProcessor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSCollectMembersToImplementProcessor$1", "compute"));
            }
            return sinkResolveProcessor;
        }
    };

    public JSCollectMembersToImplementProcessor(PsiElement context, boolean processAll) {
        super(null, context);
        this.myProcessAll = processAll;
        this.setToSkipClassDeclarationsOnce(true);
        this.setToProcessHierarchy(true);
        this.setToProcessMembers(false);
        this.setTypeContext(true);
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSCollectMembersToImplementProcessor", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/JSCollectMembersToImplementProcessor", "execute"));
        }
        if (!(element instanceof JSClass)) {
            return true;
        }
        JSClass jsClass = (JSClass)element;
        if (!this.shouldProcessClass(jsClass)) {
            return false;
        }
        SinkResolveProcessor processor = (SinkResolveProcessor)this.myInterfacesProcessor.getValue();
        List implicitlyImplemented = element instanceof JSClassBase ? ((JSClassBase)element).getImplicitlyDeclaredInterfaces() : Collections.emptyList();
        for (JSClass implementedInterface : jsClass.getImplementedInterfaces()) {
            boolean toProcessNext;
            if (JSClassUtils.isAllowImplementation(implementedInterface, this.place) && !implicitlyImplemented.contains(implementedInterface) && !(toProcessNext = implementedInterface.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), (PsiElement)implementedInterface, (PsiElement)implementedInterface)) && !this.myProcessAll) break;
        }
        List<PsiElement> results = processor.getResults();
        if (results != null) {
            this.processMembers(results);
            return false;
        }
        return DialectDetector.isTypeScript((PsiElement)jsClass);
    }

    protected boolean shouldProcessClass(@NotNull JSClass jsClass) {
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/psi/resolve/JSCollectMembersToImplementProcessor", "shouldProcessClass"));
        }
        return true;
    }

    @NotNull
    private SinkResolveProcessor<ResultSink> createProcessor(@NotNull ResultSink sink) {
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/lang/javascript/psi/resolve/JSCollectMembersToImplementProcessor", "createProcessor"));
        }
        SinkResolveProcessor<ResultSink> sinkResolveProcessor = new SinkResolveProcessor<ResultSink>(sink){
            {
                this.setToProcessHierarchy(true);
                this.setSkipImplicitDeclarations(true);
            }

            @Override
            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSCollectMembersToImplementProcessor$2", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/JSCollectMembersToImplementProcessor$2", "execute"));
                }
                if (element instanceof JSFunction) {
                    JSClass containingClass = JSUtils.getMemberContainingClass(element);
                    if (containingClass != null && "Object".equals(containingClass.getQualifiedName()) || ((JSFunction)element).isConstructor()) {
                        return true;
                    }
                } else if (element instanceof TypeScriptPropertySignature) {
                    if (this.place instanceof JSFunction) {
                        JSTypeDeclaration type = ((TypeScriptPropertySignature)element).getTypeDeclaration();
                        if (!JSPsiImplUtils.isGetterOrSetter((JSFunction)this.place)) {
                            return !(type instanceof JSFunction) || super.execute((PsiElement)type, state);
                        }
                    }
                } else {
                    return true;
                }
                return super.execute(element, state);
            }
        };
        if (sinkResolveProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSCollectMembersToImplementProcessor", "createProcessor"));
        }
        return sinkResolveProcessor;
    }

    protected abstract void processMembers(@NotNull List<PsiElement> var1);

    @NotNull
    protected abstract ResultSink createResultSink();
}

