/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTupleTypeImpl
extends JSCompositeTypeBaseImpl {
    private final boolean myStrict;

    public JSTupleTypeImpl(JSTypeSource source, Collection<JSType> _types, boolean strict) {
        super(source, _types);
        this.myStrict = strict;
    }

    @Override
    @NotNull
    protected String getTypeSeparator() {
        if ("," == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTupleTypeImpl", "getTypeSeparator"));
        }
        return ",";
    }

    @Override
    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        String superTypeText = "[" + super.getTypeText(format) + "]";
        String string = format == JSType.TypeTextFormat.SERIALIZED ? "#tuple" + (this.myStrict ? "!" : "") + superTypeText : superTypeText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTupleTypeImpl", "getTypeText"));
        }
        return string;
    }

    @Override
    protected String getNestedTypePresentation(JSType.TypeTextFormat format, JSType t) {
        if (format == JSType.TypeTextFormat.PRESENTABLE && t instanceof JSNullType) {
            return "*";
        }
        return super.getNestedTypePresentation(format, t);
    }

    @Override
    @NotNull
    protected JSCompositeTypeBaseImpl createType(@NotNull List<JSType> transformedTypes, @NotNull JSTypeSource newSource) {
        if (transformedTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformedTypes", "com/intellij/lang/javascript/psi/types/JSTupleTypeImpl", "createType"));
        }
        if (newSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSource", "com/intellij/lang/javascript/psi/types/JSTupleTypeImpl", "createType"));
        }
        JSTupleTypeImpl jSTupleTypeImpl = new JSTupleTypeImpl(newSource, transformedTypes, this.myStrict);
        if (jSTupleTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTupleTypeImpl", "createType"));
        }
        return jSTupleTypeImpl;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/JSTupleTypeImpl", "isDirectlyAssignableTypeImpl"));
        }
        if (this.myStrict && elementType instanceof JSTupleTypeImpl) {
            List<JSType> elementTypes = ((JSTupleTypeImpl)elementType).getTypes();
            List<JSType> currentTypes = this.getTypes();
            if (elementTypes.size() < currentTypes.size()) {
                return false;
            }
            for (int i = 0; i < currentTypes.size(); ++i) {
                JSType nestedElement;
                JSType nestedCurrent = currentTypes.get(i);
                if (nestedCurrent.isDirectlyAssignableType(nestedElement = elementTypes.get(i), processingContext)) continue;
                return false;
            }
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Nullable
    public JSType getTypeByIndex(int index) {
        if (index < 0) {
            return null;
        }
        List<JSType> types = this.getTypes();
        if (index >= types.size()) {
            return null;
        }
        return types.get(index);
    }

    @Nullable
    public JSType excludePrefix(int length) {
        if (length <= 0) {
            return this;
        }
        if (length > this.getTypes().size()) {
            return null;
        }
        List<JSType> newTypes = this.getTypes().subList(length, this.getTypes().size());
        return new JSTupleTypeImpl(this.getSource(), newTypes, this.myStrict);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/JSTupleTypeImpl", "isDirectlyAssignableTypeCommon"));
        }
        JSTypeCastUtil.AssignableResult assignableResult = super.isDirectlyAssignableTypeCommon(elementType, processingContext);
        if (assignableResult.isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult2 = assignableResult;
            if (assignableResult2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTupleTypeImpl", "isDirectlyAssignableTypeCommon"));
            }
            return assignableResult2;
        }
        JSTypeCastUtil.AssignableResult assignableResult3 = JSTypeCastUtil.toStrictAssignable(this.toArrayType(true).isDirectlyAssignableType(elementType, processingContext));
        if (assignableResult3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTupleTypeImpl", "isDirectlyAssignableTypeCommon"));
        }
        return assignableResult3;
    }

    public JSType toArrayType(boolean allowResolve) {
        JSTypeSource source = this.getSource();
        List<JSType> types = this.getTypes();
        Collection providers = types.stream().map(el -> () -> el).collect(Collectors.toList());
        JSType commonType = JSTypeUtils.getCommonType(providers, source.getSourceElement(), allowResolve);
        if (commonType instanceof JSNullType) {
            commonType = JSAnyType.get(source.getSourceElement(), false);
        }
        return new JSArrayTypeImpl(commonType, source);
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType jSType = this.toArrayType(true);
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTupleTypeImpl", "substitute"));
        }
        return jSType;
    }
}

