/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.convertToClass;

import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.generation.JSGetterSetterGenerationMode;
import com.intellij.lang.javascript.intentions.CommentsMover;
import com.intellij.lang.javascript.intentions.JSFunctionsHelper;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.refactoring.convertToClass.JSConvertToClassProcessor;
import com.intellij.lang.javascript.refactoring.convertToClass.JSItemToClassDataProcessor;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMethodsFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSItemToClassConvertor {
    public final Comparator<PsiElement> COMPARATOR;
    @NotNull
    private final JSItemToClassDataProcessor myDataConvertor;
    private JSFunction myLastAdded;
    private ES6Class myClazz;
    private JSFunction myConstructor;

    public JSItemToClassConvertor(@NotNull JSItemToClassDataProcessor dataConvertor) {
        if (dataConvertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataConvertor", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "<init>"));
        }
        this.myDataConvertor = dataConvertor;
        this.COMPARATOR = (o1, o2) -> {
            if (this.myDataConvertor.getFilePlace().containsKey(o1)) {
                o1 = this.myDataConvertor.getFilePlace().get(o1);
            }
            if (this.myDataConvertor.getFilePlace().containsKey(o2)) {
                o2 = this.myDataConvertor.getFilePlace().get(o2);
            }
            if (o1 == null || o2 == null) {
                return -1;
            }
            if (o1.getContainingFile().isPhysical() && o2.getContainingFile().isPhysical() && !o1.getContainingFile().equals(o2.getContainingFile())) {
                return o1.getContainingFile().getVirtualFile().getUrl().compareTo(o2.getContainingFile().getVirtualFile().getUrl());
            }
            return new Integer(o1.getTextRange().getStartOffset()).compareTo(o2.getTextRange().getStartOffset());
        };
    }

    @NotNull
    public List<UsageInfo> process(List<PsiElement> selectedUsages) {
        this.myDataConvertor.convertToStaticDeclarationsAndSuperCalls();
        List<UsageInfo> list = this.generate(selectedUsages);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "process"));
        }
        return list;
    }

    @NotNull
    public List<UsageInfo> generate(List<PsiElement> selectedUsages) {
        this.myDataConvertor.extractFunctionDeclarationsFromConstructorBlock();
        this.myDataConvertor.filterDuplicatesAndNotSelected(selectedUsages);
        this.createClassWithConstructor(this.myDataConvertor.getConstructorFunction().getFunction());
        for (JSAssignmentExpression declaration : this.orderDeclarations(this.myDataConvertor.getMemberDeclarations().values())) {
            this.addDefinition(declaration, false);
        }
        Map<String, Pair<JSFunction, JSFunction>> declarations = this.myDataConvertor.getMemberPropertyDeclarations();
        ArrayList<Object> gettersSetters = new ArrayList<Object>();
        for (Pair<JSFunction, JSFunction> pair : declarations.values()) {
            if (pair.getFirst() != null) {
                gettersSetters.add(pair.getFirst());
            }
            if (pair.getSecond() == null) continue;
            gettersSetters.add(pair.getSecond());
        }
        for (Object function : this.orderDeclarations(gettersSetters)) {
            this.addGetterSetter((PsiElement)function, (PsiElement)function);
        }
        Map<String, JSObjectLiteralExpression> memberProps = this.myDataConvertor.getMemberProps();
        for (String string : this.sortPropertiesKeys(memberProps)) {
            this.addProperty(string, memberProps.get(string), false);
        }
        for (JSAssignmentExpression jSAssignmentExpression : this.orderDeclarations(this.myDataConvertor.getStaticDeclarations().values())) {
            if (jSAssignmentExpression.getDefinitionExpression() != null && jSAssignmentExpression.getDefinitionExpression().getInitializer() instanceof JSFunction) {
                this.addDefinition(jSAssignmentExpression, true);
                continue;
            }
            this.myDataConvertor.getConversionResults().notConvertedStatic(new UsageInfo((PsiElement)jSAssignmentExpression));
        }
        Map<String, JSObjectLiteralExpression> staticProps = this.myDataConvertor.getStaticProps();
        for (String key : this.sortPropertiesKeys(staticProps)) {
            this.addProperty(key, staticProps.get(key), true);
        }
        this.removeOld();
        ArrayList<UsageInfo> arrayList = new ArrayList<UsageInfo>(this.myDataConvertor.getConversionResults().getNotConvertedUsages());
        Map<String, JSItemToClassDataProcessor> convertors = this.myDataConvertor.getChildConvertors();
        Map children = ContainerUtil.map2Map(convertors.keySet(), s -> Pair.create((Object)s, (Object)new JSItemToClassConvertor((JSItemToClassDataProcessor)convertors.get(s))));
        for (String key : this.sortChildConvertors(children)) {
            JSItemToClassConvertor convertor = (JSItemToClassConvertor)children.get(key);
            arrayList.addAll(convertor.generate(selectedUsages));
            convertor.myDataConvertor.getParentAssignment().getDefinitionExpression().getInitializer().replace((PsiElement)convertor.getClazz());
        }
        ArrayList<UsageInfo> arrayList2 = arrayList;
        if (arrayList2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "generate"));
        }
        return arrayList2;
    }

    private void removeOld() {
        for (JSExpression expression : this.myDataConvertor.getRemoveOld()) {
            JSConvertToClassProcessor.removeExpression(null, expression);
        }
    }

    private List<String> sortChildConvertors(@NotNull Map<String, JSItemToClassConvertor> convertors) {
        if (convertors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertors", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "sortChildConvertors"));
        }
        ArrayList<String> list = new ArrayList<String>(convertors.keySet());
        Collections.sort(list, (o1, o2) -> {
            if (convertors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertors", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "lambda$sortChildConvertors$2"));
            }
            JSItemToClassConvertor convertor1 = (JSItemToClassConvertor)convertors.get(o1);
            JSItemToClassConvertor convertor2 = (JSItemToClassConvertor)convertors.get(o2);
            assert (convertor1 != null);
            assert (convertor2 != null);
            return this.COMPARATOR.compare((PsiElement)convertor1.myDataConvertor.getConstructorFunction().getFunction(), (PsiElement)convertor2.myDataConvertor.getConstructorFunction().getFunction());
        });
        return list;
    }

    private List<String> sortPropertiesKeys(@NotNull Map<String, JSObjectLiteralExpression> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "sortPropertiesKeys"));
        }
        ArrayList<String> list = new ArrayList<String>(map.keySet());
        Collections.sort(list, (o1, o2) -> {
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "lambda$sortPropertiesKeys$3"));
            }
            JSObjectLiteralExpression el1 = (JSObjectLiteralExpression)map.get(o1);
            JSObjectLiteralExpression el2 = (JSObjectLiteralExpression)map.get(o2);
            assert (el1 != null);
            assert (el2 != null);
            return this.COMPARATOR.compare((PsiElement)el1, (PsiElement)el2);
        });
        return list;
    }

    private void addProperty(String key, @NotNull JSObjectLiteralExpression value, boolean isStatic) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "addProperty"));
        }
        Pair<FunctionInfo, FunctionInfo> pair = JSItemToClassConvertor.getGetSet(value);
        if (pair == null) {
            Boolean writable = JSItemToClassConvertor.getBooleanValue(value.findProperty("writable"));
            JSProperty valueProperty = value.findProperty("value");
            String innerName = JSCodeStyleSettings.getSettings((PsiElement)this.myClazz).FIELD_PREFIX + key;
            String getterBlockText = new JSFunctionsHelper.AccessorsGenerator((PsiElement)this.myClazz, innerName).setQualifier("this").generate();
            JSFunction getter = JSFunctionsHelper.createAccessorInClassFromText(this.myClazz.getProject(), JSGetterSetterGenerationMode.Getter, key, isStatic, getterBlockText, false);
            this.myLastAdded = (JSFunction)this.myClazz.addAfter((PsiElement)getter, (PsiElement)this.myLastAdded);
            if (!Boolean.FALSE.equals(writable)) {
                String setterBlockText = new JSFunctionsHelper.AccessorsGenerator((PsiElement)this.myClazz, innerName).setter().setQualifier("this").generate();
                JSFunction setter = JSFunctionsHelper.createAccessorInClassFromText(this.myClazz.getProject(), JSGetterSetterGenerationMode.Setter, key, isStatic, setterBlockText, true);
                this.myLastAdded = (JSFunction)this.myClazz.addAfter((PsiElement)setter, (PsiElement)this.myLastAdded);
            }
            if (valueProperty != null && valueProperty.getValue() != null) {
                JSItemToClassConvertor.addPropertyAssignment((PsiElement)this.myConstructor, innerName, valueProperty.getValue().getText());
            }
        } else {
            if (pair.getFirst() != null) {
                JSFunction getter = JSFunctionsHelper.createGetter(value.getProject(), ((FunctionInfo)pair.getFirst()).getFunction(), key, isStatic);
                this.addDefinition(getter, ((FunctionInfo)pair.getFirst()).getComment());
            }
            if (pair.getSecond() != null) {
                JSFunction setter = JSFunctionsHelper.createSetter(value.getProject(), ((FunctionInfo)pair.getSecond()).getFunction(), key, isStatic);
                this.addDefinition(setter, ((FunctionInfo)pair.getSecond()).getComment());
            }
        }
        JSCallExpression call = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)value, JSCallExpression.class);
        if (call != null) {
            JSConvertToClassProcessor.removeExpression(key, (JSExpression)call);
        }
    }

    private static PsiElement addLastStatementToConstructor(@NotNull PsiElement constructor, @NotNull PsiElement newElement) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "addLastStatementToConstructor"));
        }
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "addLastStatementToConstructor"));
        }
        JSBlockStatement constructorBlock = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)constructor, JSBlockStatement.class);
        if (constructorBlock != null) {
            JSSourceElement[] elements = (JSSourceElement[])PsiTreeUtil.getChildrenOfType((PsiElement)constructorBlock, JSSourceElement.class);
            Object anchor = elements != null && elements.length > 0 ? elements[elements.length - 1] : constructorBlock.getFirstChild();
            return constructorBlock.addAfter(newElement, anchor);
        }
        return null;
    }

    static PsiElement addPropertyAssignment(@NotNull PsiElement constructor, @NotNull String innerName, @NotNull String valueText) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "addPropertyAssignment"));
        }
        if (innerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerName", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "addPropertyAssignment"));
        }
        if (valueText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueText", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "addPropertyAssignment"));
        }
        PsiElement statement = JSChangeUtil.createStatementFromText(constructor.getProject(), "this." + innerName + "=" + valueText + ";").getPsi();
        JSExpressionStatement createdStatement = (JSExpressionStatement)JSItemToClassConvertor.addLastStatementToConstructor(constructor, statement);
        if (createdStatement == null) {
            return null;
        }
        JSExpression expression = createdStatement.getExpression();
        assert (expression instanceof JSAssignmentExpression && ((JSAssignmentExpression)expression).getDefinitionExpression() != null);
        return ((JSAssignmentExpression)expression).getDefinitionExpression();
    }

    private void addDefinition(JSFunction getter, PsiComment comment) {
        this.myLastAdded = (JSFunction)this.myClazz.addAfter((PsiElement)getter, (PsiElement)this.myLastAdded);
        JSDocumentationUtils.moveJSDoc(comment, (PsiElement)this.myLastAdded);
    }

    private static Boolean getBooleanValue(@Nullable JSProperty property) {
        if (property != null && property.getValue() instanceof JSLiteralExpression && ((JSLiteralExpression)property.getValue()).isBooleanLiteral()) {
            return (Boolean)((JSLiteralExpression)property.getValue()).getValue();
        }
        return null;
    }

    private static JSFunction getFunctionValue(@Nullable JSProperty property) {
        if (property instanceof ES6FunctionProperty) {
            return (JSFunction)property;
        }
        return property != null && property.getValue() instanceof JSFunction ? (JSFunction)property.getValue() : null;
    }

    @Nullable
    private static Pair<FunctionInfo, FunctionInfo> getGetSet(JSObjectLiteralExpression object) {
        JSProperty[] properties = object.getProperties();
        JSFunction get = null;
        JSFunction set = null;
        PsiComment getComment = null;
        PsiComment setComment = null;
        for (JSProperty property : properties) {
            PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)property);
            if ("get".equals(property.getName())) {
                get = JSItemToClassConvertor.getFunctionValue(property);
                getComment = docComment;
                continue;
            }
            if ("set".equals(property.getName())) {
                set = JSItemToClassConvertor.getFunctionValue(property);
                setComment = docComment;
                continue;
            }
            return null;
        }
        if (get == null && set == null) {
            return null;
        }
        return Pair.create((Object)(get == null ? null : new FunctionInfo(get, getComment)), (Object)(set == null ? null : new FunctionInfo(set, setComment)));
    }

    private <T extends JSElement> List<T> orderDeclarations(Collection<T> set) {
        ArrayList<T> result = new ArrayList<T>(set);
        Collections.sort(result, this.COMPARATOR);
        return result;
    }

    private void createClassWithConstructor(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "createClassWithConstructor"));
        }
        Project project = function.getProject();
        String extendsClause = this.myDataConvertor.createExtendsClause();
        if (this.myDataConvertor.getParentAssignment() != null) {
            JSVarStatement statement = (JSVarStatement)JSChangeUtil.createStatementFromText(project, "var a = class" + extendsClause + "{};", JavaScriptSupportLoader.ECMA_SCRIPT_6).getPsi(JSVarStatement.class);
            JSExpression initializer = statement.getVariables()[0].getInitializer();
            assert (initializer instanceof ES6Class);
            this.myClazz = (ES6Class)initializer;
        } else {
            String exported = function.isExported() ? "export " : "";
            PsiFile dummy = JSChangeUtil.createJSFileFromText(project, exported + "class " + this.myDataConvertor.getConstructorFunction().getFunctionName() + extendsClause + "{}", JavaScriptSupportLoader.ECMA_SCRIPT_6);
            assert (dummy.getFirstChild() instanceof ES6Class);
            this.myClazz = (ES6Class)dummy.getFirstChild();
        }
        String constructorTemplateText = JSClassUtils.createConstructorSignatureForClass((JSClass)this.myClazz, true) + "() {}";
        this.myConstructor = (JSFunction)JSChangeUtil.createClassMemberFromText(project, constructorTemplateText, JavaScriptSupportLoader.ECMA_SCRIPT_6).getPsi(JSFunction.class);
        assert (this.myConstructor.getParameterList() != null);
        if (function.getParameterList() != null) {
            JSFunctionsHelper.moveParameters(function, this.myConstructor);
        }
        JSFunctionsHelper.moveFunctionBody(function, this.myConstructor);
        this.myLastAdded = this.myConstructor = (JSFunction)BaseCreateMethodsFix.addMethodToClassWithoutAnchor((JSClass)this.myClazz, JavaScriptSupportLoader.ECMA_SCRIPT_6, (PsiElement)this.myConstructor, null);
        JSItemToClassConvertor.moveJSDoc((PsiElement)function, (JSElement)this.myConstructor, true);
    }

    private void addDefinition(JSAssignmentExpression assignment, boolean isStatic) {
        Project project = assignment.getProject();
        JSExpression expression = assignment.getDefinitionExpression().getExpression();
        if (!(expression instanceof JSReferenceExpression)) {
            return;
        }
        String newName = ((JSReferenceExpression)expression).getReferenceName();
        JSExpression initializer = assignment.getDefinitionExpression().getInitializer();
        if (initializer instanceof JSFunctionExpression) {
            JSFunction method = (JSFunction)JSChangeUtil.createClassMemberFromText(project, (isStatic ? "static " : "") + newName + "() {}", JavaScriptSupportLoader.ECMA_SCRIPT_6).getPsi(JSFunction.class);
            JSParameterList parameters = ((JSFunctionExpression)initializer).getParameterList();
            if (parameters != null) {
                JSFunctionsHelper.moveParameters((JSFunction)((JSFunctionExpression)initializer), method);
            }
            JSFunctionsHelper.moveFunctionBody((JSFunction)initializer, method);
            this.myLastAdded = (JSFunction)this.myClazz.addAfter((PsiElement)method, (PsiElement)this.myLastAdded);
            JSItemToClassConvertor.moveJSDoc(assignment.getParent(), (JSElement)this.myLastAdded, false);
        } else {
            JSExpressionStatement statement = (JSExpressionStatement)JSChangeUtil.createStatementFromText(project, "this." + newName + "=1;").getPsi(JSExpressionStatement.class);
            assert (statement.getExpression() instanceof JSAssignmentExpression);
            JSAssignmentExpression newAssignment = (JSAssignmentExpression)statement.getExpression();
            newAssignment.getDefinitionExpression().getInitializer().replace(initializer.copy());
            statement = (JSExpressionStatement)JSItemToClassConvertor.addLastStatementToConstructor((PsiElement)this.myConstructor, (PsiElement)statement);
            JSItemToClassConvertor.moveJSDoc(assignment.getParent(), (JSElement)statement, false);
        }
        JSItemToClassConvertor.deleteMovedDeclaration((PsiElement)assignment);
    }

    private void addGetterSetter(@NotNull PsiElement oldElement, @NotNull PsiElement method) {
        if (oldElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldElement", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "addGetterSetter"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "addGetterSetter"));
        }
        this.myLastAdded = (JSFunction)this.myClazz.addAfter(method, (PsiElement)this.myLastAdded);
        JSItemToClassConvertor.moveJSDoc(method, (JSElement)this.myLastAdded, false);
    }

    static void moveJSDoc(@NotNull PsiElement oldElement, @NotNull JSElement newElement, boolean onlyJSDoc) {
        if (oldElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldElement", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "moveJSDoc"));
        }
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "moveJSDoc"));
        }
        if (!onlyJSDoc) {
            JSSourceElement sourceElement = JSItemToClassConvertor.getSourceElement(oldElement);
            JSSourceElement newSourceElement = JSItemToClassConvertor.getSourceElement((PsiElement)newElement);
            if (sourceElement != null && newSourceElement != null) {
                CommentsMover mover = new CommentsMover(sourceElement);
                Set set = ContainerUtil.set((Object[])new PsiElement[]{newSourceElement});
                mover.move(set, set);
                return;
            }
        }
        PsiComment docComment = JSDocumentationUtils.findDocComment(oldElement);
        if (!onlyJSDoc || docComment instanceof JSDocComment) {
            JSDocumentationUtils.moveJSDoc(docComment, (PsiElement)newElement);
        }
    }

    private static JSSourceElement getSourceElement(@NotNull PsiElement oldElement) {
        if (oldElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldElement", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "getSourceElement"));
        }
        return oldElement instanceof JSSourceElement ? (JSSourceElement)oldElement : (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)oldElement, JSSourceElement.class);
    }

    static PsiElement deleteMovedDeclaration(PsiElement assignment) {
        PsiElement parent = assignment.getParent();
        if (parent instanceof JSStatement) {
            parent.getParent().deleteChildRange(parent, parent);
            return parent.getParent();
        }
        parent.deleteChildRange(assignment, assignment);
        return parent;
    }

    private static JSSourceElement getMethodBody(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "getMethodBody"));
        }
        JSSourceElement[] body = function.getBody();
        assert (body.length == 1);
        return body[0];
    }

    public ES6Class getClazz() {
        return this.myClazz;
    }

    private static class FunctionInfo {
        private final JSFunction myFunction;
        private final PsiComment myComment;

        public FunctionInfo(JSFunction function, PsiComment comment) {
            this.myFunction = function;
            this.myComment = comment;
        }

        public JSFunction getFunction() {
            return this.myFunction;
        }

        public PsiComment getComment() {
            return this.myComment;
        }
    }
}

