/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduce;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSGenericSignature;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUintType;
import com.intellij.lang.javascript.refactoring.introduce.IntroducedEntityInfoProvider;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicIntroducedEntityInfoProvider
implements IntroducedEntityInfoProvider {
    public final JSExpression[] myOccurrences;
    public final JSExpression myMainOccurrence;
    private PsiElement myScope;

    public BasicIntroducedEntityInfoProvider(@NotNull JSExpression mainOccurrence, JSExpression[] occurrences, PsiElement scope) {
        if (mainOccurrence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainOccurrence", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "<init>"));
        }
        this.myOccurrences = occurrences;
        this.myMainOccurrence = mainOccurrence;
        this.myScope = scope;
    }

    @Override
    public int getOccurrenceCount() {
        return this.myOccurrences.length;
    }

    @Override
    @Nullable
    public String evaluateType() {
        JSType type = JSResolveUtil.getExpressionJSType(this.myMainOccurrence);
        String finalType = type == null || type instanceof JSAnyType && this.myMainOccurrence instanceof JSReferenceExpression ? BaseCreateFix.guessTypeForExpression(this.myMainOccurrence, this.myMainOccurrence.getContainingFile(), false) : type.getTypeText(JSType.TypeTextFormat.CODE);
        String typeString = (String)WriteAction.compute(() -> (String)ImportUtils.importAndShortenReference((String)finalType, (PsiElement)this.myMainOccurrence, (boolean)false, (boolean)false).first);
        return typeString;
    }

    @Override
    public PsiFile getContainingFile() {
        return this.myMainOccurrence.getContainingFile();
    }

    @Override
    public String[] suggestCandidateNames() {
        return ArrayUtil.toStringArray(BasicIntroducedEntityInfoProvider.getNameCandidates(this.myMainOccurrence, this.myScope, Collections.emptyList()));
    }

    @Override
    public boolean checkConflicts(@NotNull String name, boolean replaceAllOccurences) {
        JSExpression tmp;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "checkConflicts"));
        }
        Object object = tmp = replaceAllOccurences ? PsiTreeUtil.findCommonParent((PsiElement[])this.myOccurrences) : this.myMainOccurrence;
        assert (tmp != null);
        PsiElement scope = this.myScope;
        assert (scope != null);
        JSNamedElement existing = BasicIntroducedEntityInfoProvider.findExistingInScopeAndUp(name, scope);
        if (existing != null) {
            return BasicIntroducedEntityInfoProvider.showConflictsDialog(existing, name, this.myMainOccurrence.getProject());
        }
        return true;
    }

    private static JSNamedElement findExistingInScopeAndUp(final @NotNull String name, final PsiElement scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "findExistingInScopeAndUp"));
        }
        final Ref existing = new Ref();
        final Ref existingRef = new Ref();
        scope.accept((PsiElementVisitor)new JSElementVisitor(){

            public void visitJSFile(JSFile file) {
                if (existing.isNull()) {
                    file.acceptChildren((PsiElementVisitor)this);
                }
            }

            public void visitJSEmbeddedContent(JSEmbeddedContent embeddedContent) {
                if (existing.isNull()) {
                    embeddedContent.acceptChildren((PsiElementVisitor)this);
                }
            }

            public void visitJSElement(JSElement node) {
                if (existing.isNull()) {
                    node.acceptChildren((PsiElementVisitor)this);
                }
            }

            public void visitJSClass(JSClass aClass) {
            }

            public void visitJSVariable(JSVariable node) {
                if (name.equals(node.getName())) {
                    existing.set((Object)node);
                }
                super.visitJSVariable(node);
            }

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (name.equals(node.getReferencedName()) && node.getQualifier() == null) {
                    existingRef.set((Object)node);
                }
                super.visitJSReferenceExpression(node);
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
                if (name.equals(node.getName())) {
                    existing.set((Object)node);
                }
                if (node == scope) {
                    super.visitJSFunctionDeclaration(node);
                }
            }
        });
        if (existing.isNull()) {
            SinkResolveProcessor<2> processor = new SinkResolveProcessor<2>(name, new ResolveResultSink(null, name){

                @Override
                public void addCandidateResult(PsiElement element, boolean isCompleteMatch, @Nullable String problemKey) {
                }
            });
            JSResolveUtil.treeWalkUp(processor, scope, null, scope);
            PsiElement resolved = processor.getResult();
            if (resolved instanceof JSNamedElement && !(resolved instanceof JSClass)) {
                existing.set((Object)((JSNamedElement)resolved));
            }
            if (existing.isNull() && !existingRef.isNull()) {
                existing.set((Object)new ImplicitJSVariableImpl(name, (JSType)null, scope));
            }
        }
        return (JSNamedElement)existing.get();
    }

    private static boolean showConflictsDialog(JSNamedElement existing, String name, Project project) {
        String message = existing instanceof JSFunction ? JSBundle.message((String)"javascript.introduce.variable.function.already.exists", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)name)}) : JSBundle.message((String)"javascript.introduce.variable.variable.already.exists", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)name)});
        ConflictsDialog conflictsDialog = new ConflictsDialog(project, new String[]{message});
        return conflictsDialog.showAndGet();
    }

    @Nullable
    public static String suggestCandidateName(JSExpression mainOccurrence, PsiElement scope) {
        Set<String> ourNames = BasicIntroducedEntityInfoProvider.getNameCandidates(mainOccurrence, scope, Collections.emptyList());
        return (String)ContainerUtil.getFirstItem(ourNames);
    }

    @NotNull
    public static Set<String> getNameCandidates(@NotNull JSExpression mainOccurrence, PsiElement scope, @NotNull Collection<String> existing) {
        if (mainOccurrence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainOccurrence", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "getNameCandidates"));
        }
        if (existing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existing", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "getNameCandidates"));
        }
        Set<String> set = BasicIntroducedEntityInfoProvider.getNameCandidates(mainOccurrence, scope, "", existing, EnumSet.noneOf(NameSuggestOption.class));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "getNameCandidates"));
        }
        return set;
    }

    @NotNull
    public static Set<String> getNameCandidates(@NotNull JSExpression mainOccurrence, PsiElement scope, String namePrefix, @NotNull Collection<String> existing, @NotNull EnumSet<NameSuggestOption> options) {
        if (mainOccurrence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainOccurrence", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "getNameCandidates"));
        }
        if (existing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existing", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "getNameCandidates"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "getNameCandidates"));
        }
        LinkedHashSet results = ContainerUtil.newLinkedHashSet();
        Processor processor = s -> {
            if (mainOccurrence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainOccurrence", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "lambda$getNameCandidates$1"));
            }
            if (existing == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existing", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "lambda$getNameCandidates$1"));
            }
            if (StringUtil.isEmpty((String)s)) {
                return true;
            }
            for (String candidate : BasicIntroducedEntityInfoProvider.generateNamesFromQualifiedName(s, mainOccurrence instanceof JSIndexedPropertyAccessExpression)) {
                if (namePrefix.length() > 0) {
                    candidate = namePrefix + candidate;
                }
                results.add(BasicIntroducedEntityInfoProvider.generateUniqueVariableName(candidate, scope, existing, false));
            }
            return true;
        };
        BasicIntroducedEntityInfoProvider.processCandidates(mainOccurrence, (Processor<String>)processor, options);
        LinkedHashSet linkedHashSet = results;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "getNameCandidates"));
        }
        return linkedHashSet;
    }

    @NotNull
    public static Collection<String> getNameCandidatesFromJSType(@NotNull JSType type, @NotNull PsiElement scope, @NotNull Collection<String> existing) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "getNameCandidatesFromJSType"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "getNameCandidatesFromJSType"));
        }
        if (existing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existing", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "getNameCandidatesFromJSType"));
        }
        String fromType = BasicIntroducedEntityInfoProvider.generateNameFromJSTypeOrNull(type, scope);
        if (fromType == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "getNameCandidatesFromJSType"));
            }
            return list;
        }
        List list = ContainerUtil.map(BasicIntroducedEntityInfoProvider.generateNamesFromQualifiedName(fromType, false), nameCandidate -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "lambda$getNameCandidatesFromJSType$2"));
            }
            if (existing == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existing", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "lambda$getNameCandidatesFromJSType$2"));
            }
            return BasicIntroducedEntityInfoProvider.generateUniqueVariableName(nameCandidate, scope, existing, false);
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "getNameCandidatesFromJSType"));
        }
        return list;
    }

    public static String generateUniqueVariableName(String originalString, @Nullable PsiElement scope, @NotNull Collection<String> existing, boolean skipSearchInScope) {
        if (existing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existing", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "generateUniqueVariableName"));
        }
        String currentVariant = originalString;
        if ((skipSearchInScope || scope != null) && StringUtil.isJavaIdentifier((String)originalString)) {
            int cnt = 1;
            String originalStringWithoutTrailingNumbers = null;
            while (existing.contains(currentVariant) || !skipSearchInScope && !currentVariant.equals(scope.getText()) && (BasicIntroducedEntityInfoProvider.findExistingInScopeAndUp(currentVariant, scope) != null || !BasicIntroducedEntityInfoProvider.isValidIdentifier(currentVariant, scope))) {
                ++cnt;
                if (originalStringWithoutTrailingNumbers == null) {
                    int i;
                    originalStringWithoutTrailingNumbers = originalString;
                    int startedPos = i = originalStringWithoutTrailingNumbers.length() - 1;
                    while (i >= 0 && Character.isDigit(originalStringWithoutTrailingNumbers.charAt(i))) {
                        --i;
                    }
                    if (i >= 0 && startedPos != i) {
                        currentVariant = originalStringWithoutTrailingNumbers = originalStringWithoutTrailingNumbers.substring(0, i + 1);
                        --cnt;
                        continue;
                    }
                }
                currentVariant = originalStringWithoutTrailingNumbers + cnt;
            }
        }
        return currentVariant;
    }

    private static void processCandidates(@NotNull JSExpression mainOccurrence, @NotNull Processor<String> processor, @NotNull EnumSet<NameSuggestOption> options) {
        String typeString;
        String name;
        PsiElement parent;
        if (mainOccurrence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainOccurrence", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "processCandidates"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "processCandidates"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "processCandidates"));
        }
        if (mainOccurrence instanceof JSIndexedPropertyAccessExpression) {
            mainOccurrence = ((JSIndexedPropertyAccessExpression)mainOccurrence).getQualifier();
        }
        THashSet reported = new THashSet();
        String someDefaultName = null;
        boolean typeHasHigherPriorityThanName = options.contains((Object)NameSuggestOption.TypeHasHigherPriorityThanName);
        JSType expressionType = JSResolveUtil.getExpressionJSType(mainOccurrence);
        if (mainOccurrence instanceof JSCallExpression) {
            JSExpression methodExpression = ((JSCallExpression)mainOccurrence).getMethodExpression();
            boolean bl = typeHasHigherPriorityThanName = expressionType != null && !JSTypeUtils.isIndexableType(expressionType);
            if (methodExpression instanceof JSReferenceExpression) {
                String referencedName = ((JSReferenceExpression)methodExpression).getReferencedName();
                if (mainOccurrence instanceof JSNewExpression) {
                    JSReferenceExpression typeReference;
                    ASTNode node = methodExpression.getNode().findChildByType(JSElementTypes.GENERIC_SIGNATURE);
                    if (node != null && (typeReference = ((JSGenericSignature)node.getPsi()).getTypeReference()) != null) {
                        String typeText = typeReference.getText();
                        JSResolveUtil.GenericSignature signature = JSResolveUtil.extractGenericSignature(typeText);
                        referencedName = StringUtil.pluralize((String)(signature == null ? typeText : signature.elementType));
                    }
                    BasicIntroducedEntityInfoProvider.addName(referencedName, processor, (Set<String>)reported);
                } else {
                    String propertyName;
                    String string = propertyName = referencedName != null ? JSDocumentationUtils.getPropertyName(referencedName) : null;
                    if (propertyName != null) {
                        BasicIntroducedEntityInfoProvider.addName(propertyName, processor, (Set<String>)reported);
                    } else if ("$".equals(referencedName) || "get".equals(referencedName) || "set".equals(referencedName) || "require".equals(referencedName)) {
                        JSExpression[] arguments = ((JSCallExpression)mainOccurrence).getArguments();
                        if (arguments.length > 0 && arguments[0] instanceof JSLiteralExpression) {
                            int index;
                            String value = StringUtil.stripQuotesAroundValue((String)arguments[0].getText());
                            int start = 0;
                            if (value.length() > 0 && !Character.isJavaIdentifierStart(value.charAt(0))) {
                                ++start;
                            }
                            for (index = start; index < value.length() && Character.isJavaIdentifierPart(value.charAt(index)); ++index) {
                            }
                            if (index > start) {
                                String name2 = value.substring(start, index);
                                if ("$".equals(referencedName)) {
                                    name2 = "$" + name2;
                                }
                                BasicIntroducedEntityInfoProvider.addName(name2, processor, (Set<String>)reported);
                            }
                        }
                        someDefaultName = referencedName;
                    } else {
                        someDefaultName = referencedName;
                    }
                }
            }
        }
        if (mainOccurrence instanceof JSReferenceExpression) {
            JSReferenceExpression refExpr = (JSReferenceExpression)mainOccurrence;
            someDefaultName = refExpr.getReferencedName();
            if (refExpr.getParent() instanceof JSExpressionStatement) {
                BasicIntroducedEntityInfoProvider.addName(someDefaultName, processor, (Set<String>)reported);
                someDefaultName = null;
            }
        }
        if ((parent = mainOccurrence.getParent()) instanceof JSArgumentList && !options.contains((Object)NameSuggestOption.IgnoreParamName)) {
            JSResolveUtil.processParametersForUsedArgument(mainOccurrence, (JSArgumentList)parent, (Processor<JSParameterItem>)((Processor)arg_0 -> BasicIntroducedEntityInfoProvider.lambda$processCandidates$3(processor, (Set)reported, arg_0)));
        } else if (parent instanceof JSAssignmentExpression) {
            JSExpression expression;
            JSExpression lOperand = ((JSAssignmentExpression)parent).getLOperand();
            if (lOperand instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)lOperand).getExpression()) instanceof JSReferenceExpression) {
                String name3;
                JSParameterItem parameter;
                JSReferenceExpression referenceExpression = (JSReferenceExpression)expression;
                PsiElement resolve = referenceExpression.resolve();
                if (resolve instanceof JSFunction && (parameter = JSResolveUtil.getParameterFromSetAccessor((JSFunctionItem)((JSFunction)resolve))) != null && !"value".equals(name3 = parameter.getName())) {
                    BasicIntroducedEntityInfoProvider.addName(name3, processor, (Set<String>)reported);
                }
                String referencedName = referenceExpression.getReferencedName();
                BasicIntroducedEntityInfoProvider.addName(referencedName, processor, (Set<String>)reported);
            }
        } else if (parent instanceof JSProperty && BasicIntroducedEntityInfoProvider.isValidIdentifier(name = ((JSProperty)parent).getName(), (PsiElement)mainOccurrence)) {
            BasicIntroducedEntityInfoProvider.addName(name, processor, (Set<String>)reported);
        }
        if (expressionType != null && JSTypeUtils.isIndexableType(expressionType)) {
            typeHasHigherPriorityThanName = true;
        }
        String string = typeString = expressionType != null ? BasicIntroducedEntityInfoProvider.generateNameFromJSTypeOrNull(expressionType, (PsiElement)mainOccurrence) : null;
        if (typeHasHigherPriorityThanName) {
            BasicIntroducedEntityInfoProvider.addName(typeString, processor, (Set<String>)reported);
            BasicIntroducedEntityInfoProvider.addName(someDefaultName, processor, (Set<String>)reported);
        } else {
            BasicIntroducedEntityInfoProvider.addName(someDefaultName, processor, (Set<String>)reported);
            BasicIntroducedEntityInfoProvider.addName(typeString, processor, (Set<String>)reported);
        }
    }

    private static void addName(@Nullable String name, @NotNull Processor<String> processor, @NotNull Set<String> reported) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "addName"));
        }
        if (reported == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reported", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "addName"));
        }
        if (name != null && reported.add(name)) {
            processor.process((Object)name);
        }
    }

    private static boolean isValidIdentifier(String candidate, PsiElement context) {
        if (candidate == null) {
            return false;
        }
        candidate = QualifiedName.fromDottedString((String)candidate).getLastComponent();
        Language language = context.getContainingFile().getLanguage();
        return ((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(language)).isIdentifier(candidate, context.getProject());
    }

    @Override
    public PsiElement findNamedElementInScope(@NotNull String name, PsiElement place) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "findNamedElementInScope"));
        }
        return BasicIntroducedEntityInfoProvider.findExistingInScope(name, place, this.processStatics(place));
    }

    public static PsiElement findExistingInScope(@NotNull String name, PsiElement scope, boolean processStatics) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "findExistingInScope"));
        }
        SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(name, new ResolveResultSink(null, name));
        processor.getAccessibilityProcessingHandler().setProcessStatics(processStatics);
        if (scope instanceof JSClass) {
            processor.configureClassScope((JSClass)scope);
        }
        PsiElement realPlace = scope;
        if (scope instanceof JSObjectLiteralExpression) {
            scope = ((JSObjectLiteralExpression)scope).getFirstProperty();
        }
        scope.processDeclarations(processor, ResolveState.initial(), scope, realPlace);
        return processor.getResult();
    }

    protected boolean processStatics(PsiElement place) {
        return JSResolveUtil.calculateStaticFromContext(place);
    }

    @Nullable
    private static String generateNameFromJSTypeOrNull(@NotNull JSType type, @NotNull PsiElement context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "generateNameFromJSTypeOrNull"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "generateNameFromJSTypeOrNull"));
        }
        if (type instanceof JSAnyType) {
            return null;
        }
        if (type instanceof JSIntType || type instanceof JSUintType) {
            return "i";
        }
        if (type instanceof JSStringType) {
            return "s";
        }
        if (type instanceof JSBooleanType) {
            return "b";
        }
        if (type instanceof JSPrimitiveFunctionType) {
            return "f";
        }
        String s = type.getTypeText(JSType.TypeTextFormat.CODE);
        if ("Class".equals(s)) {
            return "cls";
        }
        JSType arrayComponentOrNull = JSTypeUtils.getIndexableComponentType(type);
        if (arrayComponentOrNull != null) {
            String componentText = arrayComponentOrNull.getTypeText(JSType.TypeTextFormat.CODE);
            return BasicIntroducedEntityInfoProvider.isValidIdentifier(componentText, context) ? StringUtil.pluralize((String)componentText) : null;
        }
        if (type instanceof JSGenericTypeImpl && ((JSGenericTypeImpl)type).getType() instanceof JSNamedType) {
            JSNamedType namedType = (JSNamedType)((JSGenericTypeImpl)type).getType();
            s = namedType.getTypeText(JSType.TypeTextFormat.CODE);
        }
        return StringUtil.isEmpty((String)s) || !BasicIntroducedEntityInfoProvider.isValidIdentifier(s, context) ? null : s;
    }

    @NotNull
    private static Collection<String> generateNamesFromQualifiedName(@NotNull String s, boolean removePlural) {
        String singular;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "generateNamesFromQualifiedName"));
        }
        ArrayList results = ContainerUtil.newArrayList();
        s = QualifiedName.fromDottedString((String)s).getLastComponent();
        assert (s != null);
        s = BasicIntroducedEntityInfoProvider.sanitizeJavaScriptIdentifier(s);
        if (removePlural && (singular = StringUtil.unpluralize((String)s)) != null) {
            s = singular;
        }
        for (String namePart : NameUtil.nameToWords((String)s)) {
            String name;
            if ("get".equals(namePart) || "set".equals(namePart) || "is".equals(namePart) || "create".equals(namePart) || !StringUtil.isJavaIdentifier((String)(name = namePart.toLowerCase() + s.substring(s.indexOf(namePart) + namePart.length())))) continue;
            results.add(name);
        }
        ArrayList arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "generateNamesFromQualifiedName"));
        }
        return arrayList;
    }

    @NotNull
    private static String sanitizeJavaScriptIdentifier(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "sanitizeJavaScriptIdentifier"));
        }
        StringBuilder result = new StringBuilder();
        boolean capitalize = false;
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '$') {
                if (result.length() == 0 && !Character.isJavaIdentifierStart(ch) && ch != '$') {
                    result.append("_");
                }
                result.append(capitalize ? Character.toUpperCase(ch) : ch);
                capitalize = false;
                continue;
            }
            capitalize = true;
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "sanitizeJavaScriptIdentifier"));
        }
        return string;
    }

    private static /* synthetic */ boolean lambda$processCandidates$3(@NotNull Processor processor, Set reported, JSParameterItem jsParameter) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider", "lambda$processCandidates$3"));
        }
        BasicIntroducedEntityInfoProvider.addName(jsParameter.getName(), (Processor<String>)processor, reported);
        return true;
    }

    public static enum NameSuggestOption {
        IgnoreParamName,
        TypeHasHigherPriorityThanName;

    }
}

