/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.settings;

import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.jetbrains.annotations.NotNull;

public class JSLanguageVersionModel
extends AbstractListModel<JSLanguageLevel>
implements ComboBoxModel<JSLanguageLevel> {
    private static Set<JSLanguageLevel> OBSOLETE_LEVELS = ContainerUtil.set((Object[])new JSLanguageLevel[]{JSLanguageLevel.JS_1_6, JSLanguageLevel.JS_1_7, JSLanguageLevel.JS_1_8});
    @NotNull
    private JSLanguageLevel myLanguageLevel = JSLanguageLevel.DEFAULT;
    @NotNull
    private List<JSLanguageLevel> myLevels = JSLanguageVersionModel.getAvailableLevels();

    JSLanguageVersionModel() {
    }

    @NotNull
    private static List<JSLanguageLevel> getAvailableLevels() {
        ArrayList<JSLanguageLevel> result = new ArrayList<JSLanguageLevel>(JSLanguageLevel.values().length);
        for (JSLanguageLevel value : JSLanguageLevel.values()) {
            if (OBSOLETE_LEVELS.contains((Object)value) || !PlatformUtils.isIntelliJ() && value == JSLanguageLevel.NASHORN) continue;
            result.add(value);
        }
        ArrayList<JSLanguageLevel> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/settings/JSLanguageVersionModel", "getAvailableLevels"));
        }
        return arrayList;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (!this.myLanguageLevel.equals(anItem) && this.myLevels.indexOf(anItem) != -1) {
            this.myLanguageLevel = (JSLanguageLevel)((Object)anItem);
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public JSLanguageLevel getSelectedItem() {
        return this.myLanguageLevel;
    }

    @Override
    public int getSize() {
        return this.myLevels.size();
    }

    @Override
    public JSLanguageLevel getElementAt(int index) {
        return this.myLevels.get(index);
    }
}

