/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.action;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSHighlightingInfoBuilder;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceResultContainer;
import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.lang.javascript.service.highlighting.JSLanguageServiceFilter;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptToolWindowProvider;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TypeScriptCompileActionBase
extends AnAction {
    public TypeScriptCompileActionBase(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    protected void logErrors(@NotNull JSLanguageServiceToolWindowManager manager, @NotNull Collection<JSAnnotationError> infos) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "logErrors"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "logErrors"));
        }
        manager.logProjectErrors((ImmutableList<JSAnnotationError>)ContainerUtil.immutableList((List)ContainerUtil.newArrayList(infos)), true);
    }

    protected boolean compileFile(@NotNull VirtualFile file, @NotNull ProgressIndicator indicator, @NotNull TypeScriptCompilerService service, @NotNull Collection<JSAnnotationError> infos, @NotNull Collection<String> processedFiles) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "compileFile"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "compileFile"));
        }
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "compileFile"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "compileFile"));
        }
        if (processedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedFiles", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "compileFile"));
        }
        indicator.checkCanceled();
        if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.LOGGER.debug("Action Compile: do compile for " + file.getName());
        }
        try {
            Future<JSLanguageServiceResultContainer> compile = service.compileFileAndGetErrors(file);
            if (compile != null) {
                JSLanguageServiceResultContainer container = compile.get(60L, TimeUnit.SECONDS);
                this.processCompileFileResult(container, infos, processedFiles);
            }
            return true;
        }
        catch (Exception e) {
            JSLanguageServiceQueue.LOGGER.info(e.getMessage(), (Throwable)e);
            indicator.checkCanceled();
            return false;
        }
    }

    protected void processCompileFileResult(@Nullable JSLanguageServiceResultContainer container, @NotNull Collection<JSAnnotationError> infos, @NotNull Collection<String> processedFiles) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "processCompileFileResult"));
        }
        if (processedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedFiles", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "processCompileFileResult"));
        }
        if (container != null) {
            infos.addAll((Collection<JSAnnotationError>)container.getAnnotationResults());
            List<String> compiledFiles = container.getProcessedFiles();
            if (compiledFiles != null) {
                for (String s : compiledFiles) {
                    if (StringUtil.isEmpty((String)s)) continue;
                    processedFiles.add(FileUtil.toSystemIndependentName((String)s));
                }
            }
        }
    }

    protected boolean compileConfig(ProgressIndicator indicator, TypeScriptCompilerService service, TypeScriptConfig config2, Collection<JSAnnotationError> infos) {
        indicator.checkCanceled();
        if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.LOGGER.debug("Action Compile: do compile for " + config2.getConfigFile().getName());
        }
        try {
            indicator.setText2(JSBundle.message((String)"typescript.compiler.action.compile.all.compile.config", (Object[])new Object[]{config2.getConfigFile().getPath()}));
            Future<JSLanguageServiceResultContainer> compile = service.compileConfigProjectAndGetErrors(config2);
            if (compile != null) {
                JSLanguageServiceResultContainer container = compile.get(60L, TimeUnit.SECONDS);
                this.processCompileConfigResult(container, infos);
            }
            return true;
        }
        catch (Exception e) {
            JSLanguageServiceQueue.LOGGER.info(e.getMessage(), (Throwable)e);
            indicator.cancel();
            return false;
        }
    }

    protected void processCompileConfigResult(@Nullable JSLanguageServiceResultContainer container, @NotNull Collection<JSAnnotationError> infos) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "processCompileConfigResult"));
        }
        if (container != null) {
            infos.addAll((Collection<JSAnnotationError>)container.getAnnotationResults());
        }
    }

    protected void logErrors(Project project, Collection<JSAnnotationError> infos) {
        JSLanguageServiceToolWindowManager manager = TypeScriptToolWindowProvider.getToolWindow(project);
        if (manager != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                manager.init();
                this.logErrors(manager, infos);
            }, project.getDisposed());
        }
    }

    public final synchronized void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        DataContext context = e.getDataContext();
        this.runCompile(project, context);
    }

    public final void runCompile(@NotNull Project project, @Nullable DataContext context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "runCompile"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        FileDocumentManager.getInstance().saveAllDocuments();
        Consumer<ProgressIndicator> background = this.getBackgroundProcess(project, context);
        if (background == null) {
            return;
        }
        this.runBackgroundTask(project, background);
    }

    private void runBackgroundTask(@NotNull Project project, final Consumer<ProgressIndicator> background) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "runBackgroundTask"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            background.consume(indicator == null ? new EmptyProgressIndicator() : indicator);
        } else {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Compiling TypeScript Files", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase$1", "run"));
                    }
                    try {
                        indicator.checkCanceled();
                        background.consume((Object)indicator);
                    }
                    catch (ProcessCanceledException processCanceledException) {
                    }
                    finally {
                        TypeScriptCompileActionBase.this.release();
                    }
                }
            });
        }
    }

    protected void release() {
    }

    @Nullable
    protected abstract Consumer<ProgressIndicator> getBackgroundProcess(@Nullable Project var1, @Nullable DataContext var2);

    protected void updateServerFiles(@NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull TypeScriptCompilerService languageCompilerService) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "updateServerFiles"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "updateServerFiles"));
        }
        if (languageCompilerService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageCompilerService", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "updateServerFiles"));
        }
        JSLanguageServiceUpdateContext context = (JSLanguageServiceUpdateContext)ReadAction.compute(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "lambda$updateServerFiles$1"));
            }
            if (languageCompilerService == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageCompilerService", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "lambda$updateServerFiles$1"));
            }
            return JSHighlightingInfoBuilder.createUpdateContext(project, (Condition<VirtualFile>)languageCompilerService.getAcceptableFilesFilter());
        });
        indicator.checkCanceled();
        languageCompilerService.update(context);
        indicator.checkCanceled();
    }

    protected void runBeforeStartingCompile(@NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull TypeScriptCompilerService languageCompilerService) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "runBeforeStartingCompile"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "runBeforeStartingCompile"));
        }
        if (languageCompilerService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageCompilerService", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "runBeforeStartingCompile"));
        }
        this.updateServerFiles(project, indicator, languageCompilerService);
        languageCompilerService.flushCompileQueue();
    }

    @Nullable
    protected TypeScriptCompilerService getServiceForConfig(@NotNull Project project, @NotNull VirtualFile configFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "getServiceForConfig"));
        }
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "getServiceForConfig"));
        }
        Ref serviceRef = Ref.create();
        ReadAction.run(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "lambda$getServiceForConfig$3"));
            }
            if (configFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "lambda$getServiceForConfig$3"));
            }
            TypeScriptCompilerService.processForServices(project, (Consumer<TypeScriptCompilerService>)((Consumer)service -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "lambda$null$2"));
                }
                if (configFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "lambda$null$2"));
                }
                if (JSLanguageServiceFilter.checkAvailable(project, service, configFile)) {
                    serviceRef.set(service);
                }
            }));
        });
        return (TypeScriptCompilerService)serviceRef.get();
    }
}

