/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.formatter;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.formatter.JSIndentOptionsEditor;
import com.intellij.lang.javascript.formatter.JSLanguageCodeStyleSettingsProvider;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    private static final String BLANK_LINES_SAMPLE = "/**\n * This is a sample file\n */\nimport {Component} from 'React'\nimport {add, subtract} from 'utils';\nclass Foo {\n    field1 = 1;\n    field2 = 2;\n    foo() {\n        console.log('foo')\n    }\n    static bar() {\n        function hello(n) {\n            console.log('hello ' + n)\n        }\n        var x = 1;\n\n\n        while (x < 10) {\n            hello(x)\n        }\n    }\n}\ninterface IFoo {\n    field: number\n    field2: number\n    foo(): void;\n}\n";
    private static final String SPACING_CODE_SAMPLE = "import {Component} from 'react'\nmodule Sayings {\n    export class Greeter extends Component {\n        greeting:string;\n        constructor(message:string) {            super();\n            this.greeting = message;\n        }\n        public greetFrom(...names:string[]) {\n            return (<div className=\"greeting\">\n                Hello, { this.greeting } from\n                { names.map(name => <Name>{ name }</Name>) }\n            </div>);\n        }        \n        public greetNTimes(request: { name: string, times: number }) {\n            var greeting = this.greetFrom(request.name);\n            for (var i = 0; i < request.times; i++) {\n                console.log(greeting)\n            }\n        }\n}\n\ntype Season = Winter | Spring | Summer | Autumn;\n\ntype Foobar = \n        { foo: string } \n        & { bar: number }\n\nvar g:Sayings.Greeter = new Sayings.Greeter(\"WebStorm\");\n\nfunction *fibonacci(current = 1, next = 1) {\n    yield current;\n    yield *fibonacci(next, current + next);\n}\n\nlet [first, second, ...rest] = take(fibonacci(), 10)\n\nfunction foo(x,y,z) {\n    var i = 0;\n    var x = {0:\"zero\",1:\"one\"};\n    var a = [0,1,2];\n    var foo = function () {}\n    var asyncFoo = async (x, y, z) => { }\n    var v = x.map( s => s.length );\n    if (!i > 10) {\n        for (var j = 0; j < 10; j++) {\n            switch (j) {\n                case 0:\n                    value = \"zero\";\n                    break;\n                case 1:\n                    value = \"one\";\n                    break;\n            }\n            var c = j > 5 ? \"GT 5\" : \"LE 5\";\n        }\n    } else {\n        var j = 0;\n        try {\n            while (j < 10) {\n                if (i == j || j > 5) {\n                    a[j] = i + j * 12;\n                }\n                i = (j << 2) & 4;\n                j++;\n            }\n            do {\n                j--;\n            } while (j > 0)\n        } catch (e) {\n            alert(\"Failure: \" + e.message);\n        } finally {\n            reset(a,i);\n        }\n    }\n}}\n";

    @NotNull
    public Language getLanguage() {
        JSLanguageDialect jSLanguageDialect = JavaScriptSupportLoader.TYPESCRIPT;
        if (jSLanguageDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/formatter/TypeScriptLanguageCodeStyleSettingsProvider", "getLanguage"));
        }
        return jSLanguageDialect;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "com/intellij/lang/typescript/formatter/TypeScriptLanguageCodeStyleSettingsProvider", "getCodeSample"));
        }
        switch (settingsType) {
            case SPACING_SETTINGS: {
                return SPACING_CODE_SAMPLE;
            }
            case WRAPPING_AND_BRACES_SETTINGS: {
                return "class Foo extends BarComponent, BazService, QuuxProvider {\n}\n\nimport {Component, property1, property2, property3} from 'react'\n\nfunction buzz() { return 0; }\nvar x = 1, y = 2, foregroundColor = 'transparent', highlightColor = 'lime', font = 'Arial';\n/*\n Multiline\n   C-style\n     Comment\n */\nvar myLink  = {img: \"btn.gif\"},\n    local   = true,\n    initial = -1;\nwidth = 400\nheight = 300\n\nvar foo = {\n    numbers:['one', 'two', 'three', 'four', 'five', 'six'],\n    data : {a:{id: 123, type: \"String\", isAvailable: true},\nb:{id: 456, type:\"Int\"}},\n// fBar : function (x,y);\n    fOne:function(a, b, c, d, e, f, g, h) {\n        var x = a + b + c + d + e + f + g + h;\n        fTwo(a, b, c, fThree(d, e, f, g, h));\n        var z = a == 'Some string' ? 'yes' : 'no';\n        z = a == 10 ? 'yes' : 'no';\n        var colors = ['red', 'green', 'blue', 'black', 'white', 'gray'];\n        for (j = 0; j < 2; j ++) i = a;        for (var i = 0; i < colors.length; i++)\n             var colorString = this.numbers[i];\n    },\n\n chainedCallSample: function(a,b,c,d,e,f) {\n        chainRoot.firstCall(a,b,c,d,e,f,g).secondCall(a,b,c,d).thirdCall(a,b,c,d).fourthCall().q(a).r(a,b).s();\n        chainRoot.x().y()\n        .z();     },\n callArgumentsSample: function () {\n    this.fTwo(\"one\", \"two\", \"three\", \"four\");\n    this.fThree({\n      strA: 'a',\n      strB: 'b',\n      strC: 'c',\n      strD: 'd'\n    }, 'strE');\n    [1, 2, 3].reduce(function (previousValue, currentValue) {\n      return previousValue + currentValue;\n    }, 10);\n  },\n    /**\n     * Function JSDoc. Long lines can be wrapped with 'Comments'/'Wrap at right margin' option\n     * @param {string} a Parameter A description.\n     * @param {string} b Parameter B description. Can extend beyond the right margin.\n     */\n    fTwo:function(a, b, c, d) {\n        foo(a, b, c, d); // Line comment which can be wrapped if long.\n        if (true)\n            return c;\n        if (a == 'one' && (b == 'two' || c == 'three')) {\n            return a + b + c + d;\n        } else return strD;\n        if (a == 'one') {\n            return 1;\n        }\n        else if(a == 'two') {\n            return 2;\n        }\n        var number = -10;\n        while (x < 0) {\n            number = number + 1;\n        }\n        do {\n            number = number + 1;\n        } while (number < 10);\n        return d;\n    },\n\n    fThree:function({strA, strB, strC, strD}, strE) {\n        var number = prompt(\"Enter a number:\", 0);\n        switch (number) {\n            case 0 :\n                alert(\"Zero\");\n                break;\n            case 1:\n                alert(\"One\");\n                break;\n        }\n        try {\n            a[2]= 10;\n        }\n        catch(e) {\n            alert(\"Failure: \" + e.message);\n        }\n        return strA + strB + strC + strD + strE;\n    }\n};";
            }
            case BLANK_LINES_SETTINGS: {
                return BLANK_LINES_SAMPLE;
            }
            case INDENT_SETTINGS: {
                return "foo(\n        \"demo\",\n        {\n            title:\"Demo\",\n            width:100\n        },\n        function() {\n            object.firstCall({\n            a:'a',\n            b:'b'})\n            .secondCall();\n        }\n);";
            }
        }
        return SPACING_CODE_SAMPLE;
    }

    @Nullable
    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings commonCodeStyleSettings = new CommonCodeStyleSettings(this.getLanguage());
        CommonCodeStyleSettings.IndentOptions indentOptions = commonCodeStyleSettings.initIndentOptions();
        indentOptions.CONTINUATION_INDENT_SIZE = 4;
        commonCodeStyleSettings.LINE_COMMENT_AT_FIRST_COLUMN = false;
        commonCodeStyleSettings.LINE_COMMENT_ADD_SPACE = true;
        return commonCodeStyleSettings;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new JSIndentOptionsEditor(JavaScriptSupportLoader.TYPESCRIPT);
    }

    @Nullable
    public PsiFile createFileFromText(Project project, String text) {
        return PsiFileFactory.getInstance((Project)project).createFileFromText("dummy", (Language)JavaScriptSupportLoader.TYPESCRIPT_JSX, (CharSequence)text);
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/typescript/formatter/TypeScriptLanguageCodeStyleSettingsProvider", "customizeSettings"));
        }
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "com/intellij/lang/typescript/formatter/TypeScriptLanguageCodeStyleSettingsProvider", "customizeSettings"));
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showStandardOptions(JSLanguageCodeStyleSettingsProvider.STANDARD_SPACING_OPTIONS);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACE_BEFORE_PROPERTY_COLON", JSBundle.message((String)"space.before.name.value.separator", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACE_AFTER_PROPERTY_COLON", JSBundle.message((String)"space.after.name.value.separator", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACE_AFTER_DOTS_IN_REST_PARAMETER", JSBundle.message((String)"space.after.dots.in.rest.parameter", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACE_BEFORE_GENERATOR_MULT", JSBundle.message((String)"space.before.generator.mult", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACE_AFTER_GENERATOR_MULT", JSBundle.message((String)"space.after.generator.mult", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACE_BEFORE_FUNCTION_LEFT_PARENTH", JSBundle.message((String)"space.before.function.left.parenth", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_BEFORE_PARENTHESES, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACE_BEFORE_TYPE_COLON", JSBundle.message((String)"space.before.type.colon", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACE_AFTER_TYPE_COLON", JSBundle.message((String)"space.after.type.colon", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACES_WITHIN_OBJECT_TYPE_BRACES", JSBundle.message((String)"spaces.within.object.type.braces", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACE_BEFORE_CLASS_LBRACE", JSBundle.message((String)"space.before.class.interface.module.lbrace", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_BEFORE_LEFT_BRACE, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACES_WITHIN_OBJECT_LITERAL_BRACES", JSBundle.message((String)"spaces.within.object.literal.braces", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACES_WITHIN_IMPORTS", JSBundle.message((String)"spaces.within.import.braces", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACES_WITHIN_UNION_TYPES", JSBundle.message((String)"spaces.within.union.and.intersection", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACE_AROUND_ARROW_FUNCTION_OPERATOR", JSBundle.message((String)"spaces.arrow.function", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACE_BEFORE_ASYNC_ARROW_LPAREN", JSBundle.message((String)"spaces.async.arrow.function", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_BEFORE_PARENTHESES, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACES_WITHIN_INTERPOLATION_EXPRESSIONS", JSBundle.message((String)"spaces.within.interpolation.expressions", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(JSLanguageCodeStyleSettingsProvider.STANDARD_WRAPPING_OPTIONS);
            consumer.renameStandardOption("ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE", JSBundle.message((String)"js.array.new.line.after.left.bracket", (Object[])new Object[0]));
            consumer.renameStandardOption("ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE", JSBundle.message((String)"js.array.new.line.before.right.bracket", (Object[])new Object[0]));
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "FUNCTION_EXPRESSION_BRACE_STYLE", JSBundle.message((String)"js.function.expression.brace.style", (Object[])new Object[0]), CodeStyleSettingsCustomizable.WRAPPING_BRACES, CodeStyleSettingsCustomizable.OptionAnchor.AFTER, "METHOD_BRACE_STYLE", new Object[]{CodeStyleSettingsCustomizable.BRACE_PLACEMENT_OPTIONS, CodeStyleSettingsCustomizable.BRACE_PLACEMENT_VALUES});
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "REFORMAT_C_STYLE_COMMENTS", JSBundle.message((String)"js.format.cstyle.comments", (Object[])new Object[0]), CodeStyleSettingsCustomizable.WRAPPING_COMMENTS, new Object[0]);
            TypeScriptLanguageCodeStyleSettingsProvider.addWrapOption(consumer, "OBJECT_LITERAL_WRAP", JSBundle.message((String)"js.code.style.object.literals.category.name", (Object[])new Object[0]));
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "ALIGN_OBJECT_PROPERTIES", JSBundle.message((String)"js.code.style.align.caption", (Object[])new Object[0]), JSBundle.message((String)"js.code.style.object.literals.category.name", (Object[])new Object[0]), new Object[]{JSLanguageCodeStyleSettingsProvider.ALIGN_OBJECT_PROPERTIES_OPTIONS, JSLanguageCodeStyleSettingsProvider.ALIGN_OBJECT_PROPERTIES_VALUES});
            TypeScriptLanguageCodeStyleSettingsProvider.addWrapOption(consumer, "VAR_DECLARATION_WRAP", JSBundle.message((String)"js.wrap.settings.var.group.name", (Object[])new Object[0]));
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "ALIGN_VAR_STATEMENTS", JSBundle.message((String)"js.code.style.align.caption", (Object[])new Object[0]), JSBundle.message((String)"js.wrap.settings.var.group.name", (Object[])new Object[0]), new Object[]{JSLanguageCodeStyleSettingsProvider.ALIGN_VAR_STATEMENT_OPTIONS, JSLanguageCodeStyleSettingsProvider.ALIGN_VAR_STATEMENT_VALUES});
            TypeScriptLanguageCodeStyleSettingsProvider.addWrapOption(consumer, "IMPORTS_WRAP", JSBundle.message((String)"js.wrap.settings.import", (Object[])new Object[0]));
            TypeScriptLanguageCodeStyleSettingsProvider.addWrapOption(consumer, "UNION_TYPES_WRAP", JSBundle.message((String)"js.wrap.settings.union.and.intersection.types", (Object[])new Object[0]));
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "CHAINED_CALL_DOT_ON_NEW_LINE", JSBundle.message((String)"js.chained.call.dot.on.next.line", (Object[])new Object[0]), CodeStyleSettingsCustomizable.WRAPPING_CALL_CHAIN, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            ArrayList<String> blankLinesOptions = new ArrayList<String>();
            blankLinesOptions.addAll(Arrays.asList(JSLanguageCodeStyleSettingsProvider.STANDARD_BLANK_LINES_OPTIONS));
            blankLinesOptions.add("BLANK_LINES_AROUND_FIELD_IN_INTERFACE");
            blankLinesOptions.add("BLANK_LINES_AROUND_METHOD_IN_INTERFACE");
            consumer.showStandardOptions(ArrayUtil.toStringArray(blankLinesOptions));
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "BLANK_LINES_AROUND_FUNCTION", JSBundle.message((String)"js.blank.lines.around.function", (Object[])new Object[0]), CodeStyleSettingsCustomizable.BLANK_LINES, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.COMMENTER_SETTINGS) {
            consumer.showStandardOptions(new String[]{"LINE_COMMENT_AT_FIRST_COLUMN"});
            consumer.showStandardOptions(new String[]{"LINE_COMMENT_ADD_SPACE"});
        }
    }

    private static void addWrapOption(@NotNull CodeStyleSettingsCustomizable consumer, String fieldName, String caption) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/typescript/formatter/TypeScriptLanguageCodeStyleSettingsProvider", "addWrapOption"));
        }
        consumer.showCustomOption(TypeScriptCodeStyleSettings.class, fieldName, caption, null, new Object[]{CodeStyleSettingsCustomizable.WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
    }
}

