/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.types.TypeFromUsageDetector;
import com.intellij.lang.typescript.inspection.TypescriptRemoveTypeDeclarationQuickFix;
import com.intellij.lang.typescript.inspection.TypescriptSpecifyTypeExplicitlyQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.ProcessingContext;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypescriptExplicitMemberTypeInspection
extends JSInspection
implements CleanupLocalInspectionTool {
    public boolean myPreferExplicitLocalVariableTypes;
    public boolean myPreferExplicitReturnTypes;

    public TypescriptExplicitMemberTypeInspection() {
        this(false, true);
    }

    public TypescriptExplicitMemberTypeInspection(boolean explicitVariableTypes, boolean explicitReturnTypes) {
        this.myPreferExplicitLocalVariableTypes = explicitVariableTypes;
        this.myPreferExplicitReturnTypes = explicitReturnTypes;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(JSBundle.message((String)"typescript.explicit.member.type.variables.option", (Object[])new Object[0]), "myPreferExplicitLocalVariableTypes");
        optionsPanel.addCheckbox(JSBundle.message((String)"typescript.explicit.member.type.functions.option", (Object[])new Object[0]), "myPreferExplicitReturnTypes");
        return optionsPanel;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSVariable(JSVariable node) {
                this.visitNode((JSElement)node, TypescriptExplicitMemberTypeInspection.this.myPreferExplicitLocalVariableTypes);
            }

            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/typescript/inspection/TypescriptExplicitMemberTypeInspection$1", "visitJSFunctionDeclaration"));
                }
                if (node.isConstructor()) {
                    return;
                }
                this.visitNode((JSElement)node, TypescriptExplicitMemberTypeInspection.this.myPreferExplicitReturnTypes);
            }

            private void visitNode(JSElement node, boolean preferExplicitTypes) {
                if (!TypescriptExplicitMemberTypeInspection.isSupportedDialect(node)) {
                    return;
                }
                if (ErrorUtil.containsError((PsiElement)node)) {
                    return;
                }
                this.inspectForRedundantTypeDeclaration(node, preferExplicitTypes);
                this.inspectForMissingDeclaration(node, preferExplicitTypes);
            }

            private void inspectForMissingDeclaration(@NotNull JSElement node, boolean preferExplicitTypes) {
                JSFunction function;
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/typescript/inspection/TypescriptExplicitMemberTypeInspection$1", "inspectForMissingDeclaration"));
                }
                JSFunction jSFunction = function = node instanceof JSFunction ? (JSFunction)node : null;
                if (function != null && function.getKind() == JSFunction.FunctionKind.SETTER) {
                    return;
                }
                if (TypescriptExplicitMemberTypeInspection.getTypeDeclarationElement((PsiElement)node) == null && TypescriptExplicitMemberTypeInspection.getInferredType((PsiElement)node) != null) {
                    ProblemHighlightType highlightType = preferExplicitTypes ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.INFORMATION;
                    PsiElement identifier = ((PsiNameIdentifierOwner)node).getNameIdentifier();
                    if (identifier == null) {
                        return;
                    }
                    if (holder.isOnTheFly() || preferExplicitTypes) {
                        holder.registerProblem(identifier, JSBundle.message((String)"typescript.specify.type.explicitly", (Object[])new Object[0]), highlightType, new LocalQuickFix[]{new TypescriptSpecifyTypeExplicitlyQuickFix()});
                    }
                }
            }

            private void inspectForRedundantTypeDeclaration(@NotNull JSElement declarationOwner, boolean preferExplicitTypes) {
                ProblemHighlightType highlightType;
                if (declarationOwner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationOwner", "com/intellij/lang/typescript/inspection/TypescriptExplicitMemberTypeInspection$1", "inspectForRedundantTypeDeclaration"));
                }
                JSElement declarationElement = TypescriptExplicitMemberTypeInspection.getTypeDeclarationElement((PsiElement)declarationOwner);
                if (declarationElement == null) {
                    return;
                }
                JSType inferredType = TypescriptExplicitMemberTypeInspection.getInferredType((PsiElement)declarationOwner);
                JSType declaredType = JSPsiImplUtils.getTypeFromDeclaration(declarationOwner);
                boolean isRedundant = !preferExplicitTypes && TypescriptExplicitMemberTypeInspection.isRedundantDeclaration(inferredType, declaredType);
                LocalQuickFix[] quickFixes = new LocalQuickFix[]{new TypescriptRemoveTypeDeclarationQuickFix()};
                String message = JSBundle.message((String)(isRedundant ? "typescript.redundant.declaration" : "typescript.remove.type.declaration"), (Object[])new Object[0]);
                ProblemHighlightType problemHighlightType = highlightType = isRedundant ? ProblemHighlightType.LIKE_UNUSED_SYMBOL : ProblemHighlightType.INFORMATION;
                if (isRedundant || holder.isOnTheFly()) {
                    holder.registerProblem((PsiElement)declarationElement, message, highlightType, quickFixes);
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/inspection/TypescriptExplicitMemberTypeInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private static boolean isSupportedDialect(@NotNull JSElement node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/typescript/inspection/TypescriptExplicitMemberTypeInspection", "isSupportedDialect"));
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)node);
        return dialect != null && dialect.isTypeScript;
    }

    private static boolean isRedundantDeclaration(@Nullable JSType inferredType, @Nullable JSType declaredType) {
        inferredType = JSTypeUtils.getValuableType(inferredType);
        return (declaredType = JSTypeUtils.getValuableType(declaredType)) != null && inferredType != null && !JSTypeCastUtil.isAlwaysAssignableType(declaredType) && !JSTypeCastUtil.isAlwaysAssignableType(inferredType) && TypescriptExplicitMemberTypeInspection.isEquivalent(inferredType, declaredType);
    }

    private static boolean isEquivalent(@NotNull JSType inferredType, @NotNull JSType declaredType) {
        if (inferredType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inferredType", "com/intellij/lang/typescript/inspection/TypescriptExplicitMemberTypeInspection", "isEquivalent"));
        }
        if (declaredType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaredType", "com/intellij/lang/typescript/inspection/TypescriptExplicitMemberTypeInspection", "isEquivalent"));
        }
        return inferredType.isEquivalentTo(declaredType, new ProcessingContext()) || inferredType instanceof JSStringLiteralTypeImpl && declaredType instanceof JSStringType && !(declaredType instanceof JSStringLiteralTypeImpl);
    }

    @Nullable
    public static JSElement getTypeDeclarationElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/inspection/TypescriptExplicitMemberTypeInspection", "getTypeDeclarationElement"));
        }
        if (element instanceof JSTypeDeclaration) {
            return (JSElement)element;
        }
        if (element.getParent() instanceof JSTypeDeclaration) {
            return (JSElement)element.getParent();
        }
        if (element instanceof JSTypeDeclarationOwner) {
            return (JSElement)((JSTypeDeclarationOwner)element).getTypeElement();
        }
        if (element instanceof JSFunction) {
            return (JSElement)((JSFunction)element).getReturnTypeElement();
        }
        return null;
    }

    @Nullable
    public static JSType getInferredType(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/inspection/TypescriptExplicitMemberTypeInspection", "getInferredType"));
        }
        return TypeFromUsageDetector.detectTypeFromUsage(element, element.getContainingFile());
    }
}

