/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.library;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TypeScriptLibraryProvider {
    public static final String LIB_D_TS = "lib.d.ts";
    public static final String LIB_ES6_D_TS = "lib.es6.d.ts";
    public static final Collection<String> LIBS_D_TS = ContainerUtil.immutableSet((Object[])new String[]{"lib.d.ts", "lib.es6.d.ts"});
    public static final Collection<String> LIBS_EXTENDED = ContainerUtil.immutableSet((Object[])new String[]{"lib.es2016.array.include.d.ts", "lib.es2016.d.ts", "lib.es2017.d.ts", "lib.dom.iterable.d.ts", "lib.es2017.object.d.ts", "lib.es2017.sharedmemory.d.ts"});
    public static final Collection<String> FILES_FROM_TYPESCRIPT = ContainerUtil.immutableSet((Object[])new String[]{"lib.core.d.ts", "lib.core.es6.d.ts", "lib.core.es7.d.ts", "lib.webworker.d.ts", "lib.es5.d.ts", "lib.es7.d.ts", "lib.es2015.d.ts ", "lib.es2016.d.ts ", "lib.dom.iterable.d.ts", "lib.es2017.d.ts ", "lib.es2015.core.d.ts", "lib.es2016.core.d.ts", "lib.es2017.core.d.ts", "typescriptServices.d.ts", "lib.scriptHost.d.ts"});
    public static final String REACT_D_TS = "react.d.ts";

    @NotNull
    public static TypeScriptLibraryProvider getService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/library/TypeScriptLibraryProvider", "getService"));
        }
        TypeScriptLibraryProvider typeScriptLibraryProvider = (TypeScriptLibraryProvider)ServiceManager.getService((Project)project, TypeScriptLibraryProvider.class);
        if (typeScriptLibraryProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraryProvider", "getService"));
        }
        return typeScriptLibraryProvider;
    }

    @NotNull
    public Set<VirtualFile> getPredefinedLibraries(@NotNull VirtualFile var1);

    @NotNull
    public Set<VirtualFile> getAllPredefinedLibraries();

    @NotNull
    public static Set<VirtualFile> getPredefinedLibraries(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/library/TypeScriptLibraryProvider", "getPredefinedLibraries"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/library/TypeScriptLibraryProvider", "getPredefinedLibraries"));
        }
        TypeScriptLibraryProvider service = TypeScriptLibraryProvider.getService(project);
        Set<VirtualFile> set = service.getPredefinedLibraries(file);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraryProvider", "getPredefinedLibraries"));
        }
        return set;
    }

    @NotNull
    public String getLibraryVersion();

    @NotNull
    public static String getVersion(@Nullable Project project) {
        if (project == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraryProvider", "getVersion"));
            }
            return "";
        }
        TypeScriptLibraryProvider service = TypeScriptLibraryProvider.getService(project);
        String string = service.getLibraryVersion();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraryProvider", "getVersion"));
        }
        return string;
    }

    @NotNull
    public static Set<VirtualFile> getAllPredefinedLibraries(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/library/TypeScriptLibraryProvider", "getAllPredefinedLibraries"));
        }
        TypeScriptLibraryProvider service = TypeScriptLibraryProvider.getService(project);
        Set<VirtualFile> set = service.getAllPredefinedLibraries();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraryProvider", "getAllPredefinedLibraries"));
        }
        return set;
    }
}

