/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSSymbolQualifiedNamesIndex;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSEvaluableTypeBase;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.psi.TypeScriptDeclarationMappings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptDeclarationMappingsImpl
implements TypeScriptDeclarationMappings {
    private static final String[] JS_GENERATED_EXTENSIONS = new String[]{".js", ".jsx"};
    private static final Logger LOGGER = Logger.getInstance(TypeScriptDeclarationMappingsImpl.class);
    @NotNull
    private final Project myProject;
    private static final Class<?>[] ACCEPTABLE_CLASSES = new Class[]{JSFunction.class, JSField.class, JSVariable.class, JSClass.class, TypeScriptModule.class};

    public TypeScriptDeclarationMappingsImpl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "<init>"));
        }
        this.myProject = project;
    }

    @Override
    @NotNull
    public Collection<JSQualifiedNamedElement> getDeclarationElements(@NotNull JSQualifiedNamedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getDeclarationElements"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (DumbService.isDumb((Project)this.myProject)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getDeclarationElements"));
            }
            return list;
        }
        PsiFile file = element.getContainingFile();
        if (file == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getDeclarationElements"));
            }
            return list;
        }
        String name = file.getName();
        if (!DialectDetector.isTypeScript((PsiElement)element)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getDeclarationElements"));
            }
            return list;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || TypeScriptLibraryProvider.getAllPredefinedLibraries(this.myProject).contains(virtualFile)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getDeclarationElements"));
            }
            return list;
        }
        String fileNameWithoutExtension = JSFileReference.getFileNameWithoutExtension(name, TypeScriptUtil.TYPESCRIPT_EXTENSIONS_WITHOUT_DTS);
        if (StringUtil.isEmpty((String)fileNameWithoutExtension)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getDeclarationElements"));
            }
            return list;
        }
        Collection<VirtualFile> candidates = this.getDeclarationFileCandidatesByName(element, fileNameWithoutExtension);
        Collection<JSQualifiedNamedElement> collection = this.getEqualElementsInFiles(element, candidates, false);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getDeclarationElements"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<JSQualifiedNamedElement> getTSSourceElements(@NotNull JSQualifiedNamedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getTSSourceElements"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile file = element.getContainingFile();
        if (file == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getTSSourceElements"));
            }
            return list;
        }
        String fileNameWithoutExtension = this.getDeclarationFileNameWithoutExtension(file);
        if (StringUtil.isEmpty((String)fileNameWithoutExtension) || DumbService.isDumb((Project)this.myProject)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getTSSourceElements"));
            }
            return list;
        }
        Collection<VirtualFile> candidates = this.getTypeScriptSourceFileCandidatesByName(element, fileNameWithoutExtension);
        Collection<JSQualifiedNamedElement> tsSourceElements = this.getEqualElementsInFiles(element, candidates, false);
        tsSourceElements.forEach(el -> el.putUserData(SOURCE_FILE_MARKER, (Object)true));
        Collection<JSQualifiedNamedElement> collection = tsSourceElements;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getTSSourceElements"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<JSQualifiedNamedElement> getSourceElement(@NotNull JSQualifiedNamedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getSourceElement"));
        }
        Collection<JSQualifiedNamedElement> elements = this.getTSSourceElements(element);
        if (!elements.isEmpty()) {
            Collection<JSQualifiedNamedElement> collection = elements;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getSourceElement"));
            }
            return collection;
        }
        Collection<JSQualifiedNamedElement> collection = this.getJSSourceElements(element);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getSourceElement"));
        }
        return collection;
    }

    @Nullable
    private String getDeclarationFileNameWithoutExtension(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getDeclarationFileNameWithoutExtension"));
        }
        if (!TypeScriptUtil.isDefinitionFile(file.getName())) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || TypeScriptLibraryProvider.getAllPredefinedLibraries(this.myProject).contains(virtualFile)) {
            return null;
        }
        return JSFileReference.getFileNameWithoutExtension(file.getName(), TypeScriptUtil.TYPESCRIPT_DECLARATIONS_FILE_EXTENSIONS);
    }

    @Override
    @NotNull
    public Collection<JSQualifiedNamedElement> getJSSourceElements(@NotNull JSQualifiedNamedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getJSSourceElements"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (element instanceof TypeScriptInterface || element instanceof TypeScriptTypeAlias) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getJSSourceElements"));
            }
            return list;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getJSSourceElements"));
            }
            return list;
        }
        String fileNameWithoutExtension = this.getDeclarationFileNameWithoutExtension(psiFile);
        if (StringUtil.isEmpty((String)fileNameWithoutExtension) || DumbService.isDumb((Project)this.myProject)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getJSSourceElements"));
            }
            return list;
        }
        final Collection<VirtualFile> candidates = this.getJavaScriptFileCandidatesByName(element, fileNameWithoutExtension);
        Collection<JSQualifiedNamedElement> elements = this.getEqualElementsInFiles(element, candidates, true);
        if (!elements.isEmpty()) {
            Collection<JSQualifiedNamedElement> collection = elements;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getJSSourceElements"));
            }
            return collection;
        }
        final VirtualFile currentVirtualFile = psiFile.getVirtualFile();
        GlobalSearchScope project = GlobalSearchScope.allScope((Project)this.myProject);
        GlobalSearchScope projectWithFileTypeFilter = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)project, (FileType[])new FileType[]{JavaScriptFileType.INSTANCE});
        DelegatingGlobalSearchScope resultScope = new DelegatingGlobalSearchScope(projectWithFileTypeFilter){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl$1", "contains"));
                }
                return !currentVirtualFile.equals(file) && !candidates.contains(file) && super.contains(file);
            }
        };
        Collection<JSQualifiedNamedElement> collection = this.getEqualElementsInScope(element, (GlobalSearchScope)resultScope, true);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getJSSourceElements"));
        }
        return collection;
    }

    @NotNull
    private Collection<VirtualFile> getJavaScriptFileCandidatesByName(@NotNull JSQualifiedNamedElement context, @NotNull String fileNameWithoutExtension) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getJavaScriptFileCandidatesByName"));
        }
        if (fileNameWithoutExtension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNameWithoutExtension", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getJavaScriptFileCandidatesByName"));
        }
        Collection<VirtualFile> collection = this.getFilesByName(context, fileNameWithoutExtension, JS_GENERATED_EXTENSIONS);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getJavaScriptFileCandidatesByName"));
        }
        return collection;
    }

    @NotNull
    private Collection<VirtualFile> getTypeScriptSourceFileCandidatesByName(@NotNull JSQualifiedNamedElement context, @NotNull String fileNameWithoutExtension) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getTypeScriptSourceFileCandidatesByName"));
        }
        if (fileNameWithoutExtension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNameWithoutExtension", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getTypeScriptSourceFileCandidatesByName"));
        }
        Collection<VirtualFile> collection = this.getFilesByName(context, fileNameWithoutExtension, TypeScriptUtil.TYPESCRIPT_EXTENSIONS_WITHOUT_DTS);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getTypeScriptSourceFileCandidatesByName"));
        }
        return collection;
    }

    private Collection<VirtualFile> getDeclarationFileCandidatesByName(@NotNull JSQualifiedNamedElement context, @NotNull String fileNameWithoutExtension) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getDeclarationFileCandidatesByName"));
        }
        if (fileNameWithoutExtension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNameWithoutExtension", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getDeclarationFileCandidatesByName"));
        }
        return this.getFilesByName(context, fileNameWithoutExtension, TypeScriptUtil.TYPESCRIPT_DECLARATIONS_FILE_EXTENSIONS);
    }

    private Collection<VirtualFile> getFilesByName(@NotNull JSQualifiedNamedElement context, @NotNull String fileNameWithoutExtension, String[] extensions) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getFilesByName"));
        }
        if (fileNameWithoutExtension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNameWithoutExtension", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getFilesByName"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ArrayList result = ContainerUtil.newArrayList();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        for (String extension : extensions) {
            ContainerUtil.addAll((Collection)result, (Iterable)FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)(fileNameWithoutExtension + extension), (GlobalSearchScope)scope));
        }
        return result;
    }

    @NotNull
    private Collection<JSQualifiedNamedElement> getEqualElementsInFiles(@NotNull JSQualifiedNamedElement element, @NotNull Collection<VirtualFile> files, boolean processWeakElements) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getEqualElementsInFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getEqualElementsInFiles"));
        }
        GlobalSearchScope scope = GlobalSearchScope.filesScope((Project)this.myProject, files);
        Collection<JSQualifiedNamedElement> collection = this.getEqualElementsInScope(element, scope, processWeakElements);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getEqualElementsInFiles"));
        }
        return collection;
    }

    @NotNull
    private Collection<JSQualifiedNamedElement> getEqualElementsInScope(@NotNull JSQualifiedNamedElement element, @NotNull GlobalSearchScope scope, boolean processWeakElements) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getEqualElementsInScope"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getEqualElementsInScope"));
        }
        scope = TypeScriptUtil.createFilterByNodeModuleScope(scope, (PsiElement)element);
        String qualifiedName = element.getQualifiedName();
        if (StringUtil.isEmpty((String)qualifiedName)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getEqualElementsInScope"));
            }
            return list;
        }
        List result = ContainerUtil.newSmartList();
        Processor processor = candidate -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "lambda$getEqualElementsInScope$1"));
            }
            try {
                if (candidate instanceof JSQualifiedNamedElement && TypeScriptDeclarationMappingsImpl.areElementsEqual(element, (JSQualifiedNamedElement)candidate)) {
                    result.add((JSQualifiedNamedElement)candidate);
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return true;
        };
        this.processSymbolsWithQualifier(scope, (Processor<JSElement>)processor, qualifiedName);
        if (!processWeakElements || result.size() > 0) {
            List list = result;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getEqualElementsInScope"));
            }
            return list;
        }
        String name = element.getName();
        if (!StringUtil.isEmpty((String)name) && !StringUtil.equals((CharSequence)qualifiedName, (CharSequence)name)) {
            PsiElement parent = JSResolveUtil.findParent((PsiElement)element);
            if (parent instanceof TypeScriptModule) {
                qualifiedName = name;
                this.processSymbolsWithQualifier(scope, (Processor<JSElement>)processor, qualifiedName);
            } else {
                JSClass container = JSUtils.getMemberContainingClass((PsiElement)element);
                if (container != null && !StringUtil.isEmpty((String)container.getName())) {
                    this.processSymbolsWithQualifier(scope, (Processor<JSElement>)processor, container.getName() + "." + name);
                }
            }
        }
        if (StringUtil.equals((CharSequence)qualifiedName, (CharSequence)name)) {
            this.processSymbolsWithQualifier(scope, (Processor<JSElement>)processor, "exports." + qualifiedName);
            this.processSymbolsWithQualifier(scope, (Processor<JSElement>)processor, "module.exports." + qualifiedName);
        }
        List list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getEqualElementsInScope"));
        }
        return list;
    }

    private void processSymbolsWithQualifier(@NotNull GlobalSearchScope scope, @NotNull Processor<JSElement> processor, @NotNull String name) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "processSymbolsWithQualifier"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "processSymbolsWithQualifier"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "processSymbolsWithQualifier"));
        }
        StubIndex.getInstance().processElements(JSSymbolQualifiedNamesIndex.KEY, (Object)name.hashCode(), this.myProject, scope, JSElement.class, processor);
    }

    public static boolean areElementsEqual(@NotNull JSQualifiedNamedElement original, @NotNull JSQualifiedNamedElement candidate) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areElementsEqual"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areElementsEqual"));
        }
        if (!TypeScriptDeclarationMappingsImpl.areNamesEqual(original, candidate) || !TypeScriptDeclarationMappingsImpl.areContextSimilar(original, candidate)) {
            return false;
        }
        if (TypeScriptDeclarationMappingsImpl.areKindsEqual(original, candidate)) {
            if (original instanceof JSFunction) {
                return TypeScriptDeclarationMappingsImpl.areFunctionsSimilar((JSFunction)original, (JSFunction)candidate);
            }
            if (original instanceof JSClass) {
                return TypeScriptDeclarationMappingsImpl.areJSClassesSimilar((JSClass)original, (JSClass)candidate);
            }
            if (original instanceof JSField) {
                return TypeScriptDeclarationMappingsImpl.areFieldsSimilar((JSField)original, (JSField)candidate);
            }
            if (original instanceof JSVariable) {
                return TypeScriptDeclarationMappingsImpl.areVariablesSimilar((JSVariable)original, (JSVariable)candidate);
            }
            if (original instanceof TypeScriptModule) {
                return TypeScriptDeclarationMappingsImpl.areModulesSimilar((TypeScriptModule)original, (TypeScriptModule)candidate);
            }
            return false;
        }
        if (original instanceof JSFunction && candidate instanceof JSClass) {
            return TypeScriptDeclarationMappingsImpl.areFunctionAndJSClassSimilar((JSFunction)original, (JSClass)candidate);
        }
        if (candidate instanceof JSFunction && original instanceof JSClass) {
            return TypeScriptDeclarationMappingsImpl.areFunctionAndJSClassSimilar((JSFunction)candidate, (JSClass)original);
        }
        if (candidate instanceof JSDefinitionExpression && original instanceof JSFunction) {
            return TypeScriptDeclarationMappingsImpl.areDefinitionAndFunctionSimilar((JSDefinitionExpression)candidate, (JSFunction)original);
        }
        if (candidate instanceof JSDefinitionExpression && original instanceof JSVariable) {
            return TypeScriptDeclarationMappingsImpl.areDefinitionAndVariableSimilar((JSDefinitionExpression)candidate, (JSVariable)original);
        }
        return false;
    }

    private static boolean areModulesSimilar(@NotNull TypeScriptModule original, @NotNull TypeScriptModule candidate) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areModulesSimilar"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areModulesSimilar"));
        }
        if (original.isInternal() != candidate.isInternal()) {
            return false;
        }
        Collection<String> originalMembers = TypeScriptDeclarationMappingsImpl.getPublicModuleMembers(original);
        Collection<String> candidateMembers = TypeScriptDeclarationMappingsImpl.getPublicModuleMembers(candidate);
        return originalMembers.equals(candidateMembers);
    }

    private static Collection<String> getPublicModuleMembers(@NotNull TypeScriptModule original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getPublicModuleMembers"));
        }
        return Arrays.stream(original.getChildren()).filter(el -> el instanceof JSQualifiedNamedElement).map(el -> (JSQualifiedNamedElement)el).filter(el -> el.getAccessType() == JSAttributeList.AccessType.PUBLIC).map(el -> el.getName()).filter(el -> el != null).collect(Collectors.toSet());
    }

    private static boolean areVariablesSimilar(@NotNull JSVariable original, @NotNull JSVariable candidate) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areVariablesSimilar"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areVariablesSimilar"));
        }
        if (original instanceof TypeScriptVariable && candidate instanceof TypeScriptVariable) {
            return original.isConst() == candidate.isConst() && original.hasBlockScope() == candidate.hasBlockScope();
        }
        return true;
    }

    public static boolean areFunctionAndJSClassSimilar(@NotNull JSFunction function, @NotNull JSClass jsClass) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areFunctionAndJSClassSimilar"));
        }
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areFunctionAndJSClassSimilar"));
        }
        JSFunction constructor = jsClass.getConstructor();
        if (constructor == null) {
            return function.getParameters().length == 0;
        }
        return TypeScriptDeclarationMappingsImpl.areFunctionsSimilar(constructor, function);
    }

    public static boolean areNamesEqual(@NotNull JSQualifiedNamedElement original, @NotNull JSQualifiedNamedElement candidate) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areNamesEqual"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areNamesEqual"));
        }
        return StringUtil.equals((CharSequence)original.getName(), (CharSequence)candidate.getName());
    }

    public static boolean areKindsEqual(@NotNull JSQualifiedNamedElement original, @NotNull JSQualifiedNamedElement candidate) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areKindsEqual"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areKindsEqual"));
        }
        for (Class<?> currentClass : ACCEPTABLE_CLASSES) {
            if (!currentClass.isInstance(original) || !currentClass.isInstance(candidate)) continue;
            return true;
        }
        return false;
    }

    private static int getCommonParameterLength(@NotNull JSParameterListElement[] original, @NotNull JSParameterListElement[] candidate, boolean isTypeScriptFunctions) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getCommonParameterLength"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getCommonParameterLength"));
        }
        if (original.length == candidate.length) {
            return original.length;
        }
        if (candidate.length == 0 || original.length == 0 || isTypeScriptFunctions) {
            return -1;
        }
        int lastNotVarArgs = original[original.length - 1].isRest() ? original.length - 1 : candidate.length;
        int lastNotVarArgsCandidate = candidate[candidate.length - 1].isRest() ? candidate.length - 1 : candidate.length;
        return lastNotVarArgs == lastNotVarArgsCandidate ? lastNotVarArgs : -1;
    }

    private static boolean areFunctionsSimilar(@NotNull JSFunction function, @NotNull JSFunction candidateFunction) {
        boolean isTypeScriptFunctions;
        JSParameterListElement[] parametersCandidate;
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areFunctionsSimilar"));
        }
        if (candidateFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateFunction", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areFunctionsSimilar"));
        }
        JSParameterListElement[] parameters = function.getParameters();
        int toCount = TypeScriptDeclarationMappingsImpl.getCommonParameterLength(parameters, parametersCandidate = candidateFunction.getParameters(), isTypeScriptFunctions = function instanceof TypeScriptFunction && candidateFunction instanceof TypeScriptFunction);
        if (toCount == -1) {
            return false;
        }
        for (int i = 0; i < toCount; ++i) {
            JSType candidateType;
            JSType type;
            JSParameterListElement parameter = parameters[i];
            JSParameterListElement candidateParameter = parametersCandidate[i];
            if (!StringUtil.equals((CharSequence)parameter.getName(), (CharSequence)candidateParameter.getName())) {
                return false;
            }
            if (!isTypeScriptFunctions || TypeScriptDeclarationMappingsImpl.skipType(type = parameter.getType()) || TypeScriptDeclarationMappingsImpl.skipType(candidateType = candidateParameter.getType())) continue;
            return TypeScriptDeclarationMappingsImpl.areTypeTextEqual(type, candidateType);
        }
        if (isTypeScriptFunctions) {
            TypeScriptFunction tsFunction = (TypeScriptFunction)function;
            TypeScriptFunction tsCandidateFunction = (TypeScriptFunction)candidateFunction;
            if (tsFunction.isOverloadImplementation() != tsCandidateFunction.isOverloadImplementation()) {
                return false;
            }
            JSType type = function.getReturnType();
            JSType candidateType = candidateFunction.getReturnType();
            if (!TypeScriptDeclarationMappingsImpl.skipType(type) && !TypeScriptDeclarationMappingsImpl.skipType(candidateType)) {
                return TypeScriptDeclarationMappingsImpl.areTypeTextEqual(type, candidateType);
            }
        }
        return true;
    }

    private static boolean areDefinitionAndFunctionSimilar(@NotNull JSDefinitionExpression definition, @NotNull JSFunction candidate) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areDefinitionAndFunctionSimilar"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areDefinitionAndFunctionSimilar"));
        }
        JSFunctionExpression expression = definition.tryGetFunctionExpressionInitializer();
        if (expression != null) {
            return TypeScriptDeclarationMappingsImpl.areFunctionsSimilar((JSFunction)expression, candidate);
        }
        return false;
    }

    private static boolean areDefinitionAndVariableSimilar(@NotNull JSDefinitionExpression definition, @NotNull JSVariable variable) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areDefinitionAndVariableSimilar"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areDefinitionAndVariableSimilar"));
        }
        JSClass fieldOwner = JSUtils.getMemberContainingClass((PsiElement)variable);
        if (fieldOwner != null && variable.getJSContext() == JSContext.INSTANCE) {
            JSClass constructorOwner;
            JSFunction constructorFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)definition, JSFunction.class);
            if (constructorFunction == null) {
                return false;
            }
            JSFunction container = constructorFunction;
            if ("constructor".equals(constructorFunction.getName()) && (constructorOwner = JSUtils.getMemberContainingClass((PsiElement)constructorFunction)) != null) {
                container = constructorOwner;
            }
            return StringUtil.equals((CharSequence)container.getName(), (CharSequence)fieldOwner.getName());
        }
        return true;
    }

    private static boolean areContextSimilar(@NotNull JSQualifiedNamedElement element, @NotNull JSQualifiedNamedElement candidate) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areContextSimilar"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areContextSimilar"));
        }
        JSContext originalContext = element.getJSContext();
        JSContext candidateContext = candidate.getJSContext();
        return originalContext == JSContext.UNKNOWN && candidateContext == JSContext.STATIC || originalContext == JSContext.STATIC && candidateContext == JSContext.UNKNOWN || element.getJSContext() == candidateContext;
    }

    private static boolean areTypeTextEqual(@NotNull JSType type, @NotNull JSType candidateType) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areTypeTextEqual"));
        }
        if (candidateType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateType", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areTypeTextEqual"));
        }
        String typeText = type.getTypeText(JSType.TypeTextFormat.SERIALIZED);
        String candidateText = candidateType.getTypeText(JSType.TypeTextFormat.SERIALIZED);
        return typeText.equals(candidateText);
    }

    @Contract(value="null -> true")
    private static boolean skipType(@Nullable JSType candidateType) {
        return candidateType == null || candidateType instanceof JSEvaluableTypeBase;
    }

    private static boolean areJSClassesSimilar(@NotNull JSClass<?> originalClass, @NotNull JSClass<?> candidateClass) {
        boolean isTypeScriptOnly;
        if (originalClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalClass", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areJSClassesSimilar"));
        }
        if (candidateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateClass", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areJSClassesSimilar"));
        }
        if (!TypeScriptDeclarationMappingsImpl.areReferenceListsEqual(originalClass.getExtendsList(), candidateClass.getExtendsList())) {
            return false;
        }
        ArrayList originalMembers = ContainerUtil.newArrayList((Iterable)originalClass.getMembers());
        ArrayList candidateMembers = ContainerUtil.newArrayList((Iterable)candidateClass.getMembers());
        Set<String> originalNames = TypeScriptDeclarationMappingsImpl.getMethodNames(originalMembers);
        Set<String> candidateNames = TypeScriptDeclarationMappingsImpl.getMethodNames(candidateMembers);
        boolean bl = isTypeScriptOnly = originalClass instanceof TypeScriptClass && candidateClass instanceof TypeScriptClass;
        if (!originalNames.equals(candidateNames)) {
            if (isTypeScriptOnly) {
                return false;
            }
            if (originalClass instanceof TypeScriptClass && !TypeScriptDeclarationMappingsImpl.areTypeScriptAndJSClassMembersSimilar(originalClass, candidateClass, originalNames, candidateNames)) {
                return false;
            }
            if (candidateClass instanceof TypeScriptClass && !TypeScriptDeclarationMappingsImpl.areTypeScriptAndJSClassMembersSimilar(candidateClass, originalClass, candidateNames, originalNames)) {
                return false;
            }
        }
        return !isTypeScriptOnly || TypeScriptDeclarationMappingsImpl.areReferenceListsEqual(originalClass.getImplementsList(), candidateClass.getImplementsList());
    }

    private static boolean areTypeScriptAndJSClassMembersSimilar(@NotNull JSClass tsClass, @NotNull JSClass jsClass, @NotNull Set<String> tsMembers, @NotNull Set<String> jsMembers) {
        if (tsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tsClass", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areTypeScriptAndJSClassMembersSimilar"));
        }
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areTypeScriptAndJSClassMembersSimilar"));
        }
        if (tsMembers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tsMembers", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areTypeScriptAndJSClassMembersSimilar"));
        }
        if (jsMembers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsMembers", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areTypeScriptAndJSClassMembersSimilar"));
        }
        return tsMembers.containsAll(jsMembers);
    }

    private static boolean areReferenceListsEqual(@Nullable JSReferenceList list, @Nullable JSReferenceList candidateExtendsList) {
        if ((list == null || candidateExtendsList == null) && list != candidateExtendsList) {
            return false;
        }
        if (list != null) {
            Object[] texts = list.getReferenceTexts();
            Object[] candidatesTexts = candidateExtendsList.getReferenceTexts();
            return Arrays.equals(texts, candidatesTexts);
        }
        return true;
    }

    @NotNull
    private static Set<String> getMethodNames(@NotNull List<JSElement> candidateMembers) {
        if (candidateMembers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateMembers", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getMethodNames"));
        }
        Set<String> set = candidateMembers.stream().map(el -> el.getName()).filter(el -> el != null && !"constructor".equals(el)).collect(Collectors.toSet());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "getMethodNames"));
        }
        return set;
    }

    private static boolean areFieldsSimilar(@NotNull JSField original, @NotNull JSField candidate) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areFieldsSimilar"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl", "areFieldsSimilar"));
        }
        JSClass originalClass = JSUtils.getMemberContainingClass((PsiElement)original);
        JSClass candidateClass = JSUtils.getMemberContainingClass((PsiElement)candidate);
        if (originalClass == null || candidateClass == null || !TypeScriptDeclarationMappingsImpl.areJSClassesSimilar(originalClass, candidateClass)) {
            return false;
        }
        JSType type = original.getType();
        JSType candidateType = candidate.getType();
        if (TypeScriptDeclarationMappingsImpl.skipType(type) || TypeScriptDeclarationMappingsImpl.skipType(candidateType)) {
            return true;
        }
        return TypeScriptDeclarationMappingsImpl.areTypeTextEqual(type, candidateType);
    }
}

