/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.search;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.typescript.psi.TypeScriptDeclarationMappings;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TypeScriptDeclarationDefinitionsSearch
extends QueryExecutorBase<PsiElement, DefinitionsScopedSearch.SearchParameters> {
    protected TypeScriptDeclarationDefinitionsSearch() {
        super(true);
    }

    public void processQuery(@NotNull DefinitionsScopedSearch.SearchParameters queryParameters, @NotNull Processor<PsiElement> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/lang/typescript/search/TypeScriptDeclarationDefinitionsSearch", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/typescript/search/TypeScriptDeclarationDefinitionsSearch", "processQuery"));
        }
        PsiElement element = queryParameters.getElement();
        if (!this.checkContext(element)) {
            return;
        }
        JSQualifiedNamedElement jsQualifiedNamedElement = (JSQualifiedNamedElement)element;
        Project project = element.getProject();
        TypeScriptDeclarationMappings declarationMappings = TypeScriptDeclarationMappings.getInstance(project);
        if (declarationMappings != null) {
            Collection<JSQualifiedNamedElement> elements = declarationMappings.getSourceElement(jsQualifiedNamedElement);
            elements.forEach(arg_0 -> consumer.process(arg_0));
        }
    }

    public boolean checkContext(PsiElement element) {
        return element instanceof JSQualifiedNamedElement && TypeScriptUtil.isDefinitionFile(element.getContainingFile().getName());
    }
}

