/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.settings.exclude;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="TypeScriptGeneratedFilesManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class TypeScriptGeneratedFilesManager
implements PersistentStateComponent<State> {
    private static final int VERSION = 1;
    private final Project myProject;
    private volatile State myState = new State();

    public TypeScriptGeneratedFilesManager(Project project) {
        this.myProject = project;
    }

    @Nullable
    public static TypeScriptGeneratedFilesManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesManager", "getInstance"));
        }
        return (TypeScriptGeneratedFilesManager)ServiceManager.getService((Project)project, TypeScriptGeneratedFilesManager.class);
    }

    public boolean isExcludeDeclarationFiles() {
        return this.myState.excludeDeclarationFiles;
    }

    public void setExcludeDeclarationFiles(boolean excludeDefinitionFiles) {
        this.myState.excludeDeclarationFiles = excludeDefinitionFiles;
    }

    public boolean isExcludeGeneratedFiles() {
        return this.myState.excludeGeneratedFiles;
    }

    public Collection<VirtualFile> getExcludedPlainFiles() {
        Collection<String> files = this.getExcludedPaths();
        if (files.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        LinkedHashSet filteredFiles = files.stream().map(el -> localFileSystem.findFileByPath(el)).filter(el -> el != null).collect(Collectors.toCollection(ContainerUtil::newLinkedHashSet));
        if (filteredFiles.size() != files.size()) {
            this.updateList(filteredFiles);
        }
        return filteredFiles;
    }

    @NotNull
    public Collection<String> getExcludedPaths() {
        Collection<String> collection = this.myState.exactExcludedFiles;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesManager", "getExcludedPaths"));
        }
        return collection;
    }

    private synchronized void updateList(Collection<VirtualFile> files) {
        this.myState.exactExcludedFiles = TypeScriptGeneratedFilesManager.mapToStrings(files);
    }

    public int getVersion() {
        return this.myState.version;
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public boolean isProjectProcessed() {
        return this.myState.version == 1;
    }

    public void updateVersion() {
        this.myState.version = 1;
    }

    public void addFiles(Collection<VirtualFile> files) {
        ArrayList result = ContainerUtil.newArrayList(this.getExcludedPaths());
        result.addAll(TypeScriptGeneratedFilesManager.mapToStrings(files));
        this.myState.exactExcludedFiles = result;
    }

    @NotNull
    private static List<String> mapToStrings(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesManager", "mapToStrings"));
        }
        List list = ContainerUtil.mapNotNull(files, el -> el.getCanonicalPath());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesManager", "mapToStrings"));
        }
        return list;
    }

    public void setFiles(Collection<VirtualFile> files) {
        this.myState.exactExcludedFiles = TypeScriptGeneratedFilesManager.mapToStrings(files);
    }

    public void loadState(State state) {
        this.myState = state;
    }

    public void updateProject() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(EmptyRunnable.getInstance(), false, true));
    }

    public static class State {
        public int version = 0;
        public boolean excludeDeclarationFiles = true;
        public boolean excludeGeneratedFiles = true;
        @NotNull
        public Collection<String> exactExcludedFiles = ContainerUtil.newArrayList();
    }
}

