/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.assignment;

import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.psi.PsiElement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignmentResultUsedJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("result.of.assignment.used.displayName", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/assignment/AssignmentResultUsedJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.ASSIGNMENT_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/assignment/AssignmentResultUsedJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("result.of.assignment.expression.used.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSAssignmentExpression(JSAssignmentExpression jsAssignmentExpression) {
            JSExpression lOperand;
            super.visitJSAssignmentExpression(jsAssignmentExpression);
            PsiElement parent = jsAssignmentExpression.getParent();
            if (parent == null) {
                return;
            }
            if (parent instanceof JSForStatement || parent instanceof JSForInStatement || parent instanceof JSExpressionStatement || parent instanceof JSCommaExpression) {
                return;
            }
            if (parent instanceof JSParenthesizedExpression && (lOperand = jsAssignmentExpression.getLOperand()) instanceof JSDefinitionExpression && ((JSDefinitionExpression)lOperand).getExpression() instanceof JSObjectLiteralExpression) {
                return;
            }
            this.registerError((PsiElement)jsAssignmentExpression);
        }
    }
}

