/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.bugs;

import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class InfiniteLoopJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("infinite.loop.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bugs/InfiniteLoopJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bugs/InfiniteLoopJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("infinite.loop.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSForStatement(@NotNull JSForStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/bugs/InfiniteLoopJSInspection$Visitor", "visitJSForStatement"));
            }
            super.visitJSForStatement(statement);
            if (ControlFlowUtils.statementMayCompleteNormally((JSStatement)statement)) {
                return;
            }
            if (ControlFlowUtils.elementContainsReturnOrYield((JSElement)statement)) {
                return;
            }
            this.registerStatementError((JSStatement)statement, new Object[0]);
        }

        public void visitJSWhileStatement(@NotNull JSWhileStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/bugs/InfiniteLoopJSInspection$Visitor", "visitJSWhileStatement"));
            }
            super.visitJSWhileStatement(statement);
            if (ControlFlowUtils.statementMayCompleteNormally((JSStatement)statement)) {
                return;
            }
            if (ControlFlowUtils.elementContainsReturnOrYield((JSElement)statement)) {
                return;
            }
            this.registerStatementError((JSStatement)statement, new Object[0]);
        }

        public void visitJSDoWhileStatement(@NotNull JSDoWhileStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/bugs/InfiniteLoopJSInspection$Visitor", "visitJSDoWhileStatement"));
            }
            super.visitJSDoWhileStatement(statement);
            if (ControlFlowUtils.statementMayCompleteNormally((JSStatement)statement)) {
                return;
            }
            if (ControlFlowUtils.elementContainsReturnOrYield((JSElement)statement)) {
                return;
            }
            this.registerStatementError((JSStatement)statement, new Object[0]);
        }
    }
}

