/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryLabelJSInspection
extends JavaScriptInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("unnecessary.label.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/UnnecessaryLabelJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONTROL_FLOW_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/UnnecessaryLabelJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnusedLabelVisitor();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("unnecessary.label.error.string", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/UnnecessaryLabelJSInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return new UnusedLabelFix();
    }

    private static class LabelFinder
    extends JSRecursiveElementVisitor {
        private boolean found = false;
        private String label = null;

        private LabelFinder(JSLabeledStatement target) {
            PsiElement labelIdentifier = target.getLabelIdentifier();
            this.label = labelIdentifier.getText();
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/sixrr/inspectjs/control/UnnecessaryLabelJSInspection$LabelFinder", "visitElement"));
            }
            if (!this.found) {
                super.visitElement(element);
            }
        }

        public void visitJSContinueStatement(@NotNull JSContinueStatement continueStatement) {
            if (continueStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "continueStatement", "com/sixrr/inspectjs/control/UnnecessaryLabelJSInspection$LabelFinder", "visitJSContinueStatement"));
            }
            if (this.found) {
                return;
            }
            super.visitJSContinueStatement(continueStatement);
            if (this.label.equals(continueStatement.getLabel())) {
                this.found = true;
            }
        }

        public void visitJSBreakStatement(@NotNull JSBreakStatement breakStatement) {
            if (breakStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakStatement", "com/sixrr/inspectjs/control/UnnecessaryLabelJSInspection$LabelFinder", "visitJSBreakStatement"));
            }
            if (this.found) {
                return;
            }
            super.visitJSBreakStatement(breakStatement);
            if (this.label.equals(breakStatement.getLabel())) {
                this.found = true;
            }
        }

        public boolean jumpFound() {
            return this.found;
        }
    }

    private static class UnusedLabelVisitor
    extends BaseInspectionVisitor {
        private UnusedLabelVisitor() {
        }

        private static boolean containsBreakOrContinueForLabel(JSLabeledStatement statement) {
            LabelFinder labelFinder = new LabelFinder(statement);
            statement.accept((PsiElementVisitor)labelFinder);
            return labelFinder.jumpFound();
        }

        public void visitJSLabeledStatement(JSLabeledStatement statement) {
            if (UnusedLabelVisitor.containsBreakOrContinueForLabel(statement)) {
                return;
            }
            PsiElement labelIdentifier = statement.getLabelIdentifier();
            this.registerError(labelIdentifier);
        }
    }

    private static class UnusedLabelFix
    extends InspectionJSFix {
        private UnusedLabelFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("remove.label.fix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/UnnecessaryLabelJSInspection$UnusedLabelFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement label = descriptor2.getPsiElement();
            JSLabeledStatement labeledStatement = (JSLabeledStatement)label.getParent();
            assert (labeledStatement != null);
            JSStatement innerStatement = labeledStatement.getStatement();
            if (innerStatement == null) {
                return;
            }
            labeledStatement.replace(innerStatement);
        }
    }
}

