/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.utils;

import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.sixrr.inspectjs.utils.BoolUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@NonNls
public class ConditionalUtils {
    private ConditionalUtils() {
    }

    public static JSStatement stripBraces(JSStatement branch) {
        if (branch instanceof JSBlockStatement) {
            JSBlockStatement block = (JSBlockStatement)branch;
            JSStatement[] statements = block.getStatements();
            if (statements.length == 1) {
                return statements[0];
            }
            return block;
        }
        return branch;
    }

    public static boolean isReturn(JSStatement statement, String value) {
        if (statement == null) {
            return false;
        }
        if (!(statement instanceof JSReturnStatement)) {
            return false;
        }
        JSReturnStatement returnStatement = (JSReturnStatement)statement;
        if (returnStatement.getExpression() == null) {
            return false;
        }
        JSExpression returnValue = returnStatement.getExpression();
        String returnValueText = returnValue.getText();
        return value.equals(returnValueText);
    }

    public static boolean isAssignment(JSStatement statement, String value) {
        if (statement == null) {
            return false;
        }
        if (!(statement instanceof JSExpressionStatement)) {
            return false;
        }
        JSExpressionStatement expressionStatement = (JSExpressionStatement)statement;
        JSExpression expression = expressionStatement.getExpression();
        if (!(expression instanceof JSAssignmentExpression)) {
            return false;
        }
        JSAssignmentExpression assignment = (JSAssignmentExpression)expression;
        JSExpression rhs = assignment.getROperand();
        if (rhs == null) {
            return false;
        }
        String rhsText = rhs.getText();
        return value.equals(rhsText);
    }

    public static String castToBoolean(@NotNull JSExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/utils/ConditionalUtils", "castToBoolean"));
        }
        String conditionText = expression.getText();
        if (BoolUtils.isBoolean(expression)) {
            return conditionText;
        }
        boolean skipPars = expression instanceof JSReferenceExpression || expression instanceof JSCallExpression || expression instanceof JSParenthesizedExpression || expression instanceof JSArrayLiteralExpression || expression instanceof JSThisExpression || expression instanceof JSFunctionExpression || expression instanceof JSIndexedPropertyAccessExpression || expression instanceof JSLiteralExpression || expression instanceof JSObjectLiteralExpression;
        return skipPars ? "!!" + conditionText : "!!(" + conditionText + ")";
    }
}

