/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote;

import com.intellij.execution.rmi.RemoteServer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.rmi.Remote;
import org.jetbrains.annotations.NotNull;

public class RemoteJdbcServerBase
extends RemoteServer {
    public static final String BITNESS_PATTERN = "#BITNESS";
    public static final String DOMAIN_AUTH_LIBRARY_PATH = "domain.auth.library";
    public static final String DEKAF_V2_WORKAROUND = "dekaf.workaround";
    public static final String DOMAIN_AUTH_MISSING_FILES = "Missing native authentication library: ";

    protected static void setupAndStart(Remote remote) throws Exception {
        RemoteJdbcServerBase.setupDomainAuth();
        RemoteJdbcServerBase.start((Remote)remote);
    }

    private static void setupDomainAuth() {
        String property = System.getProperty(DOMAIN_AUTH_LIBRARY_PATH);
        if (property != null) {
            try {
                String bitness = SystemInfo.is32Bit ? "x86" : "x64";
                File extracted = RemoteJdbcServerBase.extractLibraryFromJar(property.replace(BITNESS_PATTERN, bitness));
                RemoteJdbcServerBase.setLibraryPath(extracted.getParentFile().getAbsolutePath());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static File extractLibraryFromJar(@NotNull String path) throws Exception {
        String filename;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/remote/RemoteJdbcServerBase", "extractLibraryFromJar"));
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path to be absolute (start with '/').");
        }
        String[] parts = path.split("/");
        String string = filename = parts.length > 1 ? parts[parts.length - 1] : null;
        if (filename == null) {
            throw new IllegalArgumentException("The filename extracted from the path: '" + path + "' is null");
        }
        File auth = FileUtilRt.createTempDirectory((String)"win_auth", null, (boolean)true);
        File temp = new File(auth, filename);
        temp.deleteOnExit();
        if (!temp.createNewFile() || !temp.exists()) {
            throw new FileNotFoundException("File " + temp.getAbsolutePath() + " does not exist.");
        }
        byte[] buffer = new byte[5120];
        InputStream is = RemoteServer.class.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException(DOMAIN_AUTH_MISSING_FILES + path);
        }
        FileOutputStream os = new FileOutputStream(temp);
        try {
            int readBytes;
            while ((readBytes = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, readBytes);
            }
        }
        finally {
            ((OutputStream)os).close();
            is.close();
        }
        File file = temp;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/RemoteJdbcServerBase", "extractLibraryFromJar"));
        }
        return file;
    }

    private static void setLibraryPath(@NotNull String path) throws NoSuchFieldException, IllegalAccessException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/remote/RemoteJdbcServerBase", "setLibraryPath"));
        }
        System.setProperty("java.library.path", path);
        Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
        fieldSysPath.setAccessible(true);
        fieldSysPath.set(null, null);
    }
}

