/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.dbimport;

import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.database.remote.dbimport.ErrorRecord;
import gnu.trove.TIntLongHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OffsetBatchRecords
extends BatchRecords {
    private final TIntLongHashMap myStartOffsets;

    public OffsetBatchRecords(@NotNull List<Object[]> records, @NotNull TIntLongHashMap lines, @NotNull TIntLongHashMap startOffsets, double size) {
        if (records == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/database/remote/dbimport/OffsetBatchRecords", "<init>"));
        }
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/database/remote/dbimport/OffsetBatchRecords", "<init>"));
        }
        if (startOffsets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startOffsets", "com/intellij/database/remote/dbimport/OffsetBatchRecords", "<init>"));
        }
        super(records, lines, size);
        this.myStartOffsets = startOffsets;
    }

    @Override
    @NotNull
    public ErrorRecord getErrorRecord(@NotNull Exception e, int idx) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/remote/dbimport/OffsetBatchRecords", "getErrorRecord"));
        }
        OffsetRecord offsetRecord = new OffsetRecord(e, this.getLineNumber(idx), this.myStartOffsets.get(idx));
        if (offsetRecord == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/dbimport/OffsetBatchRecords", "getErrorRecord"));
        }
        return offsetRecord;
    }

    @Override
    @NotNull
    public BatchRecords.Builder builder() {
        MyBuilder myBuilder = new MyBuilder(this.myRecords, this.myLines, this.myStartOffsets);
        if (myBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/dbimport/OffsetBatchRecords", "builder"));
        }
        return myBuilder;
    }

    private static class MyBuilder
    extends BatchRecords.Builder {
        private final TIntLongHashMap myOldOffsets;
        private final TIntLongHashMap myOffsets;

        protected MyBuilder(@NotNull List<Object[]> records, @NotNull TIntLongHashMap lines, @NotNull TIntLongHashMap oldOffsets) {
            if (records == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/database/remote/dbimport/OffsetBatchRecords$MyBuilder", "<init>"));
            }
            if (lines == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/database/remote/dbimport/OffsetBatchRecords$MyBuilder", "<init>"));
            }
            if (oldOffsets == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldOffsets", "com/intellij/database/remote/dbimport/OffsetBatchRecords$MyBuilder", "<init>"));
            }
            super(lines, records);
            this.myOffsets = new TIntLongHashMap();
            this.myOldOffsets = oldOffsets;
        }

        @Override
        @NotNull
        public BatchRecords.Builder record(@NotNull Object[] record, int oldIndex) {
            if (record == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/database/remote/dbimport/OffsetBatchRecords$MyBuilder", "record"));
            }
            this.myOffsets.put(this.myRecords.size(), this.myOldOffsets.get(oldIndex));
            BatchRecords.Builder builder = super.record(record, oldIndex);
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/dbimport/OffsetBatchRecords$MyBuilder", "record"));
            }
            return builder;
        }

        @Override
        @NotNull
        public BatchRecords build() {
            OffsetBatchRecords offsetBatchRecords = new OffsetBatchRecords(this.myRecords, this.myLines, this.myOffsets, this.mySize);
            if (offsetBatchRecords == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/dbimport/OffsetBatchRecords$MyBuilder", "build"));
            }
            return offsetBatchRecords;
        }
    }

    public static class OffsetRecord
    extends ErrorRecord.ExceptionRecord {
        private final long myStartOffset;

        /*
         * WARNING - void declaration
         */
        public OffsetRecord(@NotNull Exception exception, long number, long l) {
            void startOffset;
            if (exception == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exception", "com/intellij/database/remote/dbimport/OffsetBatchRecords$OffsetRecord", "<init>"));
            }
            super(exception, number);
            this.myStartOffset = startOffset;
        }

        @Override
        @NotNull
        public String getMessage() {
            String string = String.format("%s:%s: %s", this.getLineNumber() + 1L, this.myStartOffset + 1L, this.getErrorText());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/dbimport/OffsetBatchRecords$OffsetRecord", "getMessage"));
            }
            return string;
        }

        @Override
        public int compareTo(@NotNull ErrorRecord o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/remote/dbimport/OffsetBatchRecords$OffsetRecord", "compareTo"));
            }
            int result = super.compareTo(o);
            if (!(o instanceof OffsetRecord) || result != 0) {
                return result;
            }
            OffsetRecord casted = (OffsetRecord)o;
            return this.myStartOffset > casted.myStartOffset ? 1 : (this.myStartOffset < casted.myStartOffset ? -1 : 0);
        }
    }
}

