/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.files;

import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.files.FtlGlobalVariableProvider;
import com.intellij.freemarker.psi.files.FtlXmlNamespaceType;
import com.intellij.freemarker.psi.variables.FtlCompositeType;
import com.intellij.freemarker.psi.variables.FtlCustomVariable;
import com.intellij.freemarker.psi.variables.FtlLightVariable;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.source.jsp.JspManager;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.XmlNSDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ServletGlobalVariableProvider
extends FtlGlobalVariableProvider {
    @NonNls
    private static final String JSP_TAGLIBS = "JspTaglibs";

    @Override
    @NotNull
    public List<? extends FtlVariable> getGlobalVariables(FtlFile file) {
        WebFacet facet = (WebFacet)JavaeeFacetUtil.getInstance().getJavaeeFacet((PsiElement)file, WebFacet.ID);
        JspManager jspManager = JspManager.getInstance((Project)file.getProject());
        if (facet == null || jspManager == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/files/ServletGlobalVariableProvider", "getGlobalVariables"));
            }
            return list;
        }
        FtlCustomVariable taglibs = new FtlCustomVariable(JSP_TAGLIBS, (PsiElement)file){};
        for (XmlFile xmlFile : jspManager.getPossibleTldFiles(facet.getModule())) {
            String uri;
            XmlNSDescriptor descriptor;
            XmlDocument document = xmlFile.getDocument();
            if (document == null || (descriptor = (XmlNSDescriptor)document.getMetaData()) == null || (uri = jspManager.getTaglibUri(xmlFile)) == null) continue;
            PsiElement declaration = descriptor.getDeclaration();
            if (declaration == null) {
                declaration = xmlFile;
            }
            taglibs.addSubVariable(new FtlTaglibNamespace(uri, descriptor, declaration));
            VirtualFile vFile = xmlFile.getVirtualFile();
            if (vFile == null) continue;
            for (WebRoot webRoot : facet.getWebRoots(true)) {
                String relPath;
                VirtualFile root = webRoot.getFile();
                if (root == null || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)vFile, (boolean)true) || (relPath = VfsUtilCore.getRelativePath((VirtualFile)vFile, (VirtualFile)root, (char)'/')) == null) continue;
                taglibs.addSubVariable(new FtlTaglibNamespace("/" + relPath, descriptor, declaration));
            }
        }
        List<FakePsiElement> list = Arrays.asList(taglibs, new FtlLightVariable("Application", (PsiElement)file, "freemarker.ext.servlet.ServletContextHashModel"), new FtlLightVariable("Session", (PsiElement)file, "freemarker.ext.servlet.HttpSessionHashModel"), new FtlLightVariable("RequestParameters", (PsiElement)file, "freemarker.ext.servlet.HttpRequestParametersHashModel"), new FtlLightVariable("Request", (PsiElement)file, "freemarker.ext.servlet.HttpRequestHashModel"));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/files/ServletGlobalVariableProvider", "getGlobalVariables"));
        }
        return list;
    }

    private static class FtlTaglibNamespace
    extends FtlCustomVariable {
        private final PsiElement myDeclaration;
        private final FtlXmlNamespaceType myType;

        public FtlTaglibNamespace(@NotNull String uri, XmlNSDescriptor descriptor, PsiElement declaration) {
            if (uri == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "com/intellij/freemarker/psi/files/ServletGlobalVariableProvider$FtlTaglibNamespace", "<init>"));
            }
            super(uri, declaration);
            this.myDeclaration = declaration;
            this.myType = new FtlXmlNamespaceType(descriptor);
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = this.myDeclaration;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/files/ServletGlobalVariableProvider$FtlTaglibNamespace", "getNavigationElement"));
            }
            return psiElement;
        }

        @Override
        public FtlType getType() {
            return new FtlCompositeType(this.myType, super.getType());
        }
    }
}

