/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.CombinedSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CombinedSpringModelImpl
extends SpringModel
implements CombinedSpringModel {
    private final Set<CommonSpringModel> myModels;

    public CombinedSpringModelImpl(@NotNull Set<? extends CommonSpringModel> models, @Nullable Module module) {
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/spring/contexts/model/CombinedSpringModelImpl", "<init>"));
        }
        super(module);
        this.myModels = new LinkedHashSet<CommonSpringModel>(models.size());
        this.myModels.addAll(models);
    }

    public CombinedSpringModelImpl(@NotNull Set<SpringModel> models, @NotNull Module module, @Nullable SpringFileSet fileSet) {
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/spring/contexts/model/CombinedSpringModelImpl", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/contexts/model/CombinedSpringModelImpl", "<init>"));
        }
        super(module, fileSet);
        this.myModels = new LinkedHashSet<CommonSpringModel>(models.size());
        this.myModels.addAll(models);
    }

    public Set<CommonSpringModel> getUnderlyingModels() {
        return this.getModelsToProcess(true);
    }

    @NotNull
    public Set<CommonSpringModel> getModelsToProcess(boolean checkActiveProfiles) {
        LinkedHashSet<CommonSpringModel> models = new LinkedHashSet<CommonSpringModel>();
        models.addAll(this.myModels);
        models.addAll(this.getDependencies());
        LinkedHashSet<CommonSpringModel> linkedHashSet = models;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/CombinedSpringModelImpl", "getModelsToProcess"));
        }
        return linkedHashSet;
    }

    @NotNull
    public Set<String> getAllProfiles() {
        LinkedHashSet profiles = ContainerUtil.newLinkedHashSet();
        this.processModels(model -> {
            profiles.addAll(model.getAllProfiles());
            return true;
        });
        LinkedHashSet linkedHashSet = profiles;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/CombinedSpringModelImpl", "getAllProfiles"));
        }
        return linkedHashSet;
    }

    @Nullable
    public Set<String> getActiveProfiles() {
        LinkedHashSet profiles = ContainerUtil.newLinkedHashSet();
        this.processModels(model -> {
            Set activeProfiles = model.getActiveProfiles();
            if (activeProfiles != null) {
                profiles.addAll(activeProfiles);
            }
            return true;
        });
        return profiles;
    }

    public String toString() {
        return "CombinedSpringModel[" + this.getModule().getName() + ", #" + this.myModels.size() + "]";
    }
}

