/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.dom;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomReferenceInjector;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderDomReferenceInjector
implements DomReferenceInjector {
    public static final ThreadLocal<Boolean> IS_COMPUTING = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private static final Set<Pair<String, String>> SKIP_ATTRS = ContainerUtil.immutableSet((Object[])new Pair[]{Pair.create((Object)"bean", (Object)"parent"), Pair.create((Object)"import", (Object)"resource"), Pair.create((Object)"component-scan", (Object)"base-package")});

    public String resolveString(@Nullable String unresolvedText, @NotNull ConvertContext context) {
        DomElement domElement;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/dom/PlaceholderDomReferenceInjector", "resolveString"));
        }
        if (unresolvedText == null) {
            return null;
        }
        Boolean isComputing = IS_COMPUTING.get();
        if (isComputing == Boolean.TRUE) {
            return unresolvedText;
        }
        if (!DumbService.isDumb((Project)context.getProject()) && (domElement = context.getInvocationElement()) instanceof GenericDomValue && !PlaceholderDomReferenceInjector.skipAttributes((GenericDomValue)domElement) && PlaceholderUtils.getInstance().containsDefaultPlaceholderDefinitions((GenericDomValue)domElement)) {
            return PlaceholderUtils.getInstance().resolvePlaceholders((GenericDomValue)domElement);
        }
        return unresolvedText;
    }

    private static boolean skipAttributes(final GenericDomValue domElement) {
        if (!(domElement instanceof GenericAttributeValue)) {
            return false;
        }
        String attributeName = domElement.getXmlElementName();
        NotNullLazyValue<String> tagName = new NotNullLazyValue<String>(){

            @NotNull
            protected String compute() {
                String string = domElement.getParent().getXmlElementName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/dom/PlaceholderDomReferenceInjector$2", "compute"));
                }
                return string;
            }
        };
        for (Pair<String, String> pair : SKIP_ATTRS) {
            if (!((String)pair.second).equals(attributeName) || !((String)pair.first).equals(tagName.getValue())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public PsiReference[] inject(@Nullable String unresolvedText, @NotNull PsiElement element, @NotNull ConvertContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/dom/PlaceholderDomReferenceInjector", "inject"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/dom/PlaceholderDomReferenceInjector", "inject"));
        }
        DomElement domElement = context.getInvocationElement();
        if (domElement instanceof GenericDomValue) {
            GenericDomValue genericDomValue = (GenericDomValue)domElement;
            if (PlaceholderUtils.getInstance().isPlaceholder(genericDomValue, genericDomValue.getRawText())) {
                XmlHighlightVisitor.setSkipValidation((PsiElement)element);
                PsiReference[] psiReferenceArray = PlaceholderUtils.getInstance().createPlaceholderPropertiesReferences((GenericDomValue)domElement);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/dom/PlaceholderDomReferenceInjector", "inject"));
                }
                return psiReferenceArray;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/dom/PlaceholderDomReferenceInjector", "inject"));
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

