/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.editor;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetImpl;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.facet.editor.AddFileType;
import com.intellij.spring.facet.editor.ParentContextListCellRenderer;
import com.intellij.spring.facet.editor.SpringFilesTree;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xml.config.ConfigFileSearcher;
import com.intellij.xml.config.ConfigFilesTreeBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSetEditor
extends DialogWrapper {
    private JPanel myMainPanel;
    private JTextField mySetName;
    private JBLabel myHelpLabel;
    private JComboBox myParentBox;
    private SpringFilesTree myFilesTree;
    private JPanel myTreePanel;
    private final SpringFileSet myOriginalSet;
    private final SpringFileSet myFileSet;
    private ConfigFilesTreeBuilder myBuilder;
    private final Module myModule;
    private Set<String> myExistingContextNames;
    private TreeExpander myTreeExpander;

    public FileSetEditor(@NotNull Module module, SpringFileSet fileSet, Set<SpringFileSet> currentModuleParentCandidates, ConfigFileSearcher ... searchers) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/facet/editor/FileSetEditor", "<init>"));
        }
        super(module.getProject(), true);
        this.myModule = module;
        this.myOriginalSet = fileSet;
        this.$$$setupUI$$$();
        this.myFileSet = new SpringFileSetImpl(this.myOriginalSet);
        this.init(fileSet, module, currentModuleParentCandidates, searchers);
    }

    public FileSetEditor(Component parent, @NotNull Module module, SpringFileSet fileSet, Set<SpringFileSet> currentModuleParentCandidates, ConfigFileSearcher ... searchers) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/facet/editor/FileSetEditor", "<init>"));
        }
        super(parent, true);
        this.myModule = module;
        this.myOriginalSet = fileSet;
        this.$$$setupUI$$$();
        this.myFileSet = new SpringFileSetImpl(this.myOriginalSet);
        this.init(fileSet, module, currentModuleParentCandidates, searchers);
    }

    private void init(SpringFileSet fileSet, @NotNull Module module, Set<SpringFileSet> currentModuleParentCandidates, ConfigFileSearcher ... searchers) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/facet/editor/FileSetEditor", "init"));
        }
        this.setTitle(this.myOriginalSet.isNew() ? SpringBundle.message("facet.context.new.title", new Object[0]) : SpringBundle.message("facet.context.edit.title", fileSet.getName()));
        this.mySetName.setText(fileSet.getName());
        this.mySetName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                FileSetEditor.this.updateFileSet();
            }
        });
        this.myHelpLabel.setText("<html>Configuration files referenced via <b>&lt;import></b> or <b>@Import</b> will be added implicitly.<br/>Configuration files used for testing must <em>not</em> be added to contexts.</html>");
        this.initParentSelection(fileSet, currentModuleParentCandidates);
        this.initTree(fileSet, module.getProject(), searchers);
        this.myExistingContextNames = new HashSet();
        Set allSets = SpringFileSetService.getInstance().getAllSets(fileSet.getFacet());
        allSets.remove(fileSet);
        for (SpringFileSet set : allSets) {
            this.myExistingContextNames.add(set.getName());
        }
        this.init();
        this.setOKActionEnabled(this.myOriginalSet.isNew());
    }

    private void initParentSelection(SpringFileSet fileSet, Set<SpringFileSet> currentModuleParentCandidates) {
        this.myParentBox.setRenderer(new ParentContextListCellRenderer());
        this.myParentBox.addItem(null);
        List<SpringFileSet> parentFileSetCandidates = FileSetEditor.getParentFileSetCandidates(fileSet, currentModuleParentCandidates);
        if (parentFileSetCandidates.isEmpty()) {
            this.myParentBox.setEnabled(false);
            return;
        }
        Set ourDependencies = fileSet.getDependencyFileSets();
        SpringFileSet selectedParentFileSet = null;
        for (SpringFileSet parentCandidate : parentFileSetCandidates) {
            if (parentCandidate.getDependencyFileSets().contains(fileSet)) continue;
            this.myParentBox.addItem(parentCandidate);
            if (!ourDependencies.contains(parentCandidate)) continue;
            selectedParentFileSet = parentCandidate;
        }
        this.myParentBox.setSelectedItem(selectedParentFileSet);
        this.myParentBox.addItemListener(e -> this.updateFileSet());
        new ComboboxSpeedSearch(this.myParentBox){

            protected String getElementText(Object element) {
                if (element == null) {
                    return SpringBundle.message("facet.context.edit.parent.none.selected", new Object[0]);
                }
                return ((SpringFileSet)element).getName();
            }
        };
    }

    private void initTree(SpringFileSet fileSet, Project project, ConfigFileSearcher[] searchers) {
        CheckedTreeNode myRoot = new CheckedTreeNode(null);
        this.myFilesTree = new SpringFilesTree();
        this.myFilesTree.setModel(new DefaultTreeModel((TreeNode)myRoot));
        for (ConfigFileSearcher searcher : searchers) {
            searcher.search();
        }
        this.myBuilder = new ConfigFilesTreeBuilder((JTree)((Object)this.myFilesTree)){

            protected DefaultMutableTreeNode createFileNode(Object file) {
                CheckedTreeNode node = new CheckedTreeNode(file);
                if (file instanceof PsiFile && FileSetEditor.this.myFileSet.hasFile(((PsiFile)file).getVirtualFile()) || file instanceof VirtualFile && FileSetEditor.this.myFileSet.hasFile((VirtualFile)file)) {
                    node.setChecked(true);
                } else {
                    node.setChecked(false);
                }
                return node;
            }
        };
        Set psiFiles = this.myBuilder.buildTree((DefaultMutableTreeNode)myRoot, searchers);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        List list = fileSet.getFiles();
        for (VirtualFilePointer pointer : list) {
            PsiFile psiFile;
            VirtualFile file = pointer.getFile();
            if (file == null || (psiFile = psiManager.findFile(file)) != null && psiFiles.contains(psiFile)) continue;
            this.myBuilder.addFile(file);
        }
        this.myFilesTree.getModel().addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            public void treeNodesChanged(TreeModelEvent e) {
                FileSetEditor.this.updateFileSet();
            }
        });
        this.myTreeExpander = new DefaultTreeExpander((JTree)((Object)this.myFilesTree));
        this.myTreeExpander.expandAll();
        this.initTreeToolbar();
    }

    private void initTreeToolbar() {
        CommonActionsManager actionManager = CommonActionsManager.getInstance();
        this.myTreePanel.add(ToolbarDecorator.createDecorator((JTree)((Object)this.myFilesTree)).setAddAction(this::doAddAction).addExtraAction(AnActionButton.fromAction((AnAction)actionManager.createExpandAllAction(this.myTreeExpander, (JComponent)((Object)this.myFilesTree)))).addExtraAction(AnActionButton.fromAction((AnAction)actionManager.createCollapseAllAction(this.myTreeExpander, (JComponent)((Object)this.myFilesTree)))).disableUpDownActions().createPanel());
    }

    private void doAddAction(AnActionButton button) {
        JBList list = new JBList((Object[])AddFileType.values());
        list.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/spring/facet/editor/FileSetEditor$5", "customizeCellRenderer"));
                }
                AddFileType variant = (AddFileType)((Object)value);
                this.setIcon(variant.getIcon());
                this.append(variant.getDisplayName());
            }
        });
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle(SpringBundle.message("facet.context.edit.add.file.choose.type", new Object[0])).setItemChoosenCallback(() -> {
            AddFileType addFileType = (AddFileType)((Object)((Object)list.getSelectedValue()));
            if (addFileType == null) {
                return;
            }
            this.performAddFiles(addFileType);
        }).createPopup().show(button.getPreferredPopupPoint());
    }

    private void performAddFiles(AddFileType addFileType) {
        Project project = this.myModule.getProject();
        final Condition<VirtualFile> fileVisibleCondition = addFileType.getFileVisibleCondition(project);
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, true, false, true, true){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                if (!super.isFileVisible(file, showHiddenFiles)) {
                    return false;
                }
                if (file.isDirectory() || file.getFileType() == FileTypes.ARCHIVE) {
                    return true;
                }
                return fileVisibleCondition.value((Object)file);
            }
        };
        descriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)this.myModule);
        descriptor.setTitle(addFileType.getDisplayName());
        VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Component)this.myMainPanel, (Project)project, null);
        if (files.length <= 0) {
            return;
        }
        DefaultMutableTreeNode treeNode = null;
        for (VirtualFile file : files) {
            treeNode = this.myBuilder.addFile(file);
            if (!(treeNode instanceof CheckedTreeNode)) continue;
            ((CheckedTreeNode)treeNode).setChecked(true);
        }
        this.updateFileSet();
        this.myTreeExpander.expandAll();
        TreeUtil.selectInTree((DefaultMutableTreeNode)treeNode, (boolean)false, (JTree)((Object)this.myFilesTree), (boolean)true);
    }

    @NotNull
    private static List<SpringFileSet> getParentFileSetCandidates(@NotNull SpringFileSet fileSet, Set<SpringFileSet> currentModuleParentCandidates) {
        if (fileSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSet", "com/intellij/spring/facet/editor/FileSetEditor", "getParentFileSetCandidates"));
        }
        Module module = fileSet.getFacet().getModule();
        HashSet allSets = new HashSet();
        HashSet dependentModules = new HashSet();
        ModuleUtilCore.getDependencies((Module)module, (Set)dependentModules);
        dependentModules.remove(module);
        for (Module dependentModule : dependentModules) {
            SpringFacet facet = SpringFacet.getInstance((Module)dependentModule);
            if (facet == null) continue;
            allSets.addAll(SpringFileSetService.getInstance().getAllSets(facet));
        }
        allSets.addAll(currentModuleParentCandidates);
        allSets.remove(fileSet);
        List activeSets = ContainerUtil.filter((Collection)allSets, set -> !set.isRemoved());
        Collections.sort(activeSets, (set, set2) -> {
            int compareModule = set.getFacet().getModule().getName().compareTo(set2.getFacet().getModule().getName());
            if (compareModule != 0) {
                return compareModule;
            }
            return set.getName().compareTo(set2.getName());
        });
        List list = activeSets;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/editor/FileSetEditor", "getParentFileSetCandidates"));
        }
        return list;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "spring file set editor";
    }

    public boolean isOKActionEnabled() {
        if (this.myOriginalSet.isNew()) {
            return true;
        }
        if (!this.myFileSet.getName().equals(this.myOriginalSet.getName())) {
            return true;
        }
        if (this.myFileSet.getFiles().size() != this.myOriginalSet.getFiles().size()) {
            return true;
        }
        List pointers = this.myFileSet.getFiles();
        for (int i = 0; i < pointers.size(); ++i) {
            if (((VirtualFilePointer)pointers.get(i)).getUrl().equals(((VirtualFilePointer)this.myOriginalSet.getFiles().get(i)).getUrl())) continue;
            return true;
        }
        return !Comparing.haveEqualElements((Collection)this.myFileSet.getDependencyFileSets(), (Collection)this.myOriginalSet.getDependencyFileSets());
    }

    protected void doOKAction() {
        this.updateFileSet();
        super.doOKAction();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myOriginalSet.isNew() ? this.mySetName : this.myFilesTree;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String name = this.mySetName.getText();
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return new ValidationInfo(SpringBundle.message("facet.context.edit.name.validation.not.empty", new Object[0]), (JComponent)this.mySetName);
        }
        if (!this.myOriginalSet.isAutodetected() && this.myExistingContextNames.contains(name)) {
            return new ValidationInfo(SpringBundle.message("facet.context.edit.name.validation.already.exists", new Object[0]), (JComponent)this.mySetName);
        }
        return null;
    }

    private void updateFileSet() {
        this.myFileSet.setName(this.mySetName.getText());
        this.myFilesTree.updateFileSet(this.myFileSet);
        SpringFileSet dependencyFileSet = (SpringFileSet)this.myParentBox.getSelectedItem();
        this.myFileSet.setDependencies(ContainerUtil.createMaybeSingletonList((Object)dependencyFileSet));
        this.getOKAction().setEnabled(this.isOKActionEnabled());
    }

    public SpringFileSet getEditedFileSet() {
        return this.myFileSet;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        JComboBox jComboBox;
        JTextField jTextField;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setMinimumSize(new Dimension(600, 200));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("resources/messages/SpringBundle").getString("facet.context.edit.name.label"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.mySetName = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, new Dimension(150, -1), null));
        this.myParentBox = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(490, 22), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("resources/messages/SpringBundle").getString("facet.context.edit.parent.label"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myHelpLabel = jBLabel = new JBLabel();
        jBLabel.setText("helpText");
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel.setHorizontalTextPosition(11);
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jPanel2.add((Component)jBLabel, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myTreePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jLabel.setLabelFor(jTextField);
        jLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

