/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.patterns.integration;

import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.MacroFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.actions.generate.SpringBeanGenerateProvider;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.actions.generate.DomTemplateRunner;
import com.intellij.util.xml.impl.DomTemplateRunnerImpl;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class MethodInvokingFactoryBean
extends SpringBeanGenerateProvider {
    public MethodInvokingFactoryBean(String text) {
        super(text, null);
    }

    protected void runTemplate(Editor editor, PsiFile file, SpringBean springBean, Map<String, String> predefinedVars) {
        super.runTemplate(editor, file, (DomElement)springBean, predefinedVars);
        ((DomTemplateRunnerImpl)DomTemplateRunner.getInstance((Project)file.getProject())).runTemplate((DomElement)springBean, editor, this.getTemplate(springBean), predefinedVars);
    }

    protected Template getTemplate(SpringBean springBean) {
        TemplateManager manager = TemplateManager.getInstance((Project)springBean.getManager().getProject());
        Template template = manager.createTemplate("", "");
        template.setToReformat(true);
        MacroCallNode completeExpression = new MacroCallNode(MacroFactory.createMacro((String)"complete"));
        Expression targetMethodExpression = MethodInvokingFactoryBean.getTargetMethodExpression(springBean);
        template.addTextSegment("<");
        template.addVariableSegment("NS_PREFIX");
        template.addTextSegment("bean id=\"");
        template.addVariable("BEAN_NAME", (Expression)completeExpression, (Expression)completeExpression, true);
        template.addTextSegment("\" class=\"" + this.getClassName() + "\">");
        template.addTextSegment("<");
        template.addVariableSegment("NS_PREFIX");
        template.addTextSegment("property name=\"targetObject\" ref=\"");
        template.addVariable("TARGET_OBJECT", (Expression)completeExpression, (Expression)completeExpression, true);
        template.addTextSegment("\" />");
        template.addTextSegment("<");
        template.addVariableSegment("NS_PREFIX");
        template.addTextSegment("property name=\"targetMethod\" value=\"");
        template.addVariable("TARGET_METHOD", targetMethodExpression, targetMethodExpression, true);
        template.addTextSegment("\" /></");
        template.addVariableSegment("NS_PREFIX");
        template.addTextSegment("bean>");
        return template;
    }

    protected abstract String getClassName();

    private static Expression getTargetMethodExpression(SpringBean springBean) {
        final SpringBean copy = (SpringBean)springBean.createStableCopy();
        return new Expression(){

            public Result calculateResult(ExpressionContext context) {
                return new TextResult("");
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return this.calculateResult(context);
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                PsiClass psiClass = MethodInvokingFactoryBean.getTargetObjectPsiClass(copy);
                if (psiClass == null) {
                    return LookupElement.EMPTY_ARRAY;
                }
                LinkedHashSet<LookupElementBuilder> items = new LinkedHashSet<LookupElementBuilder>();
                for (PsiMethod psiMethod : psiClass.getAllMethods()) {
                    if (!psiMethod.hasModifierProperty("public") || psiMethod.getParameterList().getParametersCount() != 0) continue;
                    items.add(JavaLookupElementBuilder.forMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY));
                }
                return items.toArray(new LookupElement[items.size()]);
            }
        };
    }

    @Nullable
    private static PsiClass getTargetObjectPsiClass(SpringBean springBean) {
        SpringPropertyDefinition property = SpringPropertyUtils.findPropertyByName((CommonSpringBean)springBean, (String)"targetObject");
        if (property == null) {
            return null;
        }
        SpringBeanPointer beanPointer = property.getRefValue();
        return beanPointer != null ? beanPointer.getBeanClass() : null;
    }
}

