/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters.fixes.bean;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.CreateElementQuickFixProvider;
import com.intellij.spring.model.converters.fixes.bean.SpringBeanResolveQuickFixProvider;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringInjection;
import com.intellij.spring.model.xml.beans.TypeHolder;
import com.intellij.spring.model.xml.beans.TypeHolderUtil;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GenericSpringBeanResolveQuickFixProvider
implements SpringBeanResolveQuickFixProvider {
    GenericSpringBeanResolveQuickFixProvider() {
    }

    @Override
    @NotNull
    public List<LocalQuickFix> getQuickFixes(ConvertContext context, @NotNull Beans beans, @Nullable String beanId, List<PsiClassType> requiredClasses) {
        if (beans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beans", "com/intellij/spring/model/converters/fixes/bean/GenericSpringBeanResolveQuickFixProvider", "getQuickFixes"));
        }
        LocalQuickFix[] fixes = new CreateGenericBeanQuickFix(beans, beanId).getQuickFixes((GenericDomValue)context.getInvocationElement());
        List<LocalQuickFix> list = Arrays.asList(fixes);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/GenericSpringBeanResolveQuickFixProvider", "getQuickFixes"));
        }
        return list;
    }

    private static class CreateGenericBeanQuickFix
    extends CreateElementQuickFixProvider<SpringBeanPointer> {
        private final Beans beans;
        @Nullable
        private final String beanId;

        private CreateGenericBeanQuickFix(Beans beans, @Nullable String beanId) {
            super(SpringBundle.message("model.bean.quickfix.message.family.name", new Object[0]));
            this.beans = beans;
            this.beanId = beanId;
        }

        @Override
        @Nullable
        protected String getElementName(@NotNull GenericDomValue<SpringBeanPointer> value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/spring/model/converters/fixes/bean/GenericSpringBeanResolveQuickFixProvider$CreateGenericBeanQuickFix", "getElementName"));
            }
            return this.beanId != null ? this.beanId : super.getElementName(value);
        }

        @Override
        protected void apply(String elementName, GenericDomValue<SpringBeanPointer> value) {
            PsiClass psiClass;
            PsiClassType classType;
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)this.beans.getXmlElement())) {
                return;
            }
            SpringBean springBean = this.beans.addBean();
            springBean.setName(elementName);
            DomElement parent = value.getParent();
            if (parent instanceof SpringInjection && (classType = TypeHolderUtil.getRequiredClassType((TypeHolder)((SpringInjection)parent))) != null && (psiClass = classType.resolve()) != null) {
                GenericAttributeValue clazzAttribute = springBean.getClazz();
                if (psiClass.isInterface()) {
                    clazzAttribute.setStringValue("");
                    PsiNavigateUtil.navigate((PsiElement)clazzAttribute.getXmlAttributeValue());
                    return;
                }
                clazzAttribute.setStringValue(psiClass.getQualifiedName());
            }
        }

        @Override
        @NotNull
        protected String getFixName(String elementName) {
            String string = SpringBundle.message("model.bean.quickfix.message", elementName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/GenericSpringBeanResolveQuickFixProvider$CreateGenericBeanQuickFix", "getFixName"));
            }
            return string;
        }
    }
}

