/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.SpringAutowireUtil;
import com.intellij.spring.model.highlighting.SpringConstructorArgResolveUtil;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.SpringModelElement;
import com.intellij.spring.model.xml.beans.Autowire;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.DefaultableBoolean;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutowiredDependenciesInspection
extends SpringBeanInspectionBase {
    public void checkFileElement(DomFileElement<Beans> domFileElement, DomElementAnnotationHolder holder) {
        super.checkFileElement(domFileElement, holder);
        Beans beans = (Beans)domFileElement.getRootElement();
        Autowire defaultAutowire = (Autowire)beans.getDefaultAutowire().getValue();
        if (defaultAutowire != null && !Autowire.NO.equals((Object)defaultAutowire)) {
            holder.createProblem((DomElement)beans.getDefaultAutowire(), HighlightSeverity.WARNING, SpringBundle.message("spring.bean.autowire.escape", new Object[0]), new LocalQuickFix[]{AutowiredDependenciesInspection.createDefaultAutowireEscapeQuickFixes((Beans)beans.createStableCopy(), defaultAutowire)});
        }
    }

    private static LocalQuickFix createDefaultAutowireEscapeQuickFixes(final Beans beans, final Autowire defaultAutowire) {
        return new LocalQuickFix(){

            @NotNull
            public String getFamilyName() {
                String string = SpringBundle.message("spring.bean.autowire.escape", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/AutowiredDependenciesInspection$1", "getFamilyName"));
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/AutowiredDependenciesInspection$1", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/highlighting/AutowiredDependenciesInspection$1", "applyFix"));
                }
                if (!beans.isValid()) {
                    return;
                }
                UsageTrigger.trigger((String)"spring.DefaultAutowireEscapeQuickFix");
                new WriteCommandAction.Simple(project, new PsiFile[]{DomUtil.getFile((DomElement)beans)}){

                    protected void run() throws Throwable {
                        for (SpringBean bean : beans.getBeans()) {
                            Autowire autowire;
                            if (!AutowiredDependenciesInspection.isAutowireCandidate(bean) || (autowire = (Autowire)bean.getAutowire().getValue()) != null && !autowire.getValue().equals(defaultAutowire.getValue()) && !autowire.equals((Object)Autowire.DEFAULT)) continue;
                            AutowiredDependenciesInspection.escapeAutowire(defaultAutowire.getValue(), bean);
                        }
                        beans.getDefaultAutowire().undefine();
                    }
                }.execute();
            }
        };
    }

    protected void checkBean(@NotNull SpringBean springBean, @NotNull Beans beans, @NotNull DomElementAnnotationHolder holder, @Nullable CommonSpringModel model) {
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/highlighting/AutowiredDependenciesInspection", "checkBean"));
        }
        if (beans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beans", "com/intellij/spring/model/highlighting/AutowiredDependenciesInspection", "checkBean"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/model/highlighting/AutowiredDependenciesInspection", "checkBean"));
        }
        if (AutowiredDependenciesInspection.isAutowireCandidate(springBean)) {
            AutowiredDependenciesInspection.addAutowireEscapeWarning(springBean, holder);
        }
    }

    private static boolean isAutowireCandidate(SpringBean springBean) {
        DefaultableBoolean autoWireCandidate = (DefaultableBoolean)springBean.getAutowireCandidate().getValue();
        return autoWireCandidate == null || autoWireCandidate.getBooleanValue() != false;
    }

    private static void addAutowireEscapeWarning(SpringBean springBean, DomElementAnnotationHolder holder) {
        Autowire autowire = (Autowire)springBean.getAutowire().getValue();
        if (autowire != null && !Autowire.NO.equals((Object)autowire)) {
            holder.createProblem((DomElement)springBean.getAutowire(), HighlightSeverity.WARNING, SpringBundle.message("spring.bean.use.autowire", new Object[0]), new LocalQuickFix[]{AutowiredDependenciesInspection.createEscapeAutowireQuickFixes((SpringBean)springBean.createStableCopy(), autowire)});
        }
    }

    private static LocalQuickFix createEscapeAutowireQuickFixes(final SpringBean springBean, final @NotNull Autowire autowire) {
        if (autowire == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "autowire", "com/intellij/spring/model/highlighting/AutowiredDependenciesInspection", "createEscapeAutowireQuickFixes"));
        }
        return new LocalQuickFix(){

            @NotNull
            public String getFamilyName() {
                String string = SpringBundle.message("spring.bean.autowire.escape", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/AutowiredDependenciesInspection$2", "getFamilyName"));
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/AutowiredDependenciesInspection$2", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/highlighting/AutowiredDependenciesInspection$2", "applyFix"));
                }
                if (!springBean.isValid()) {
                    return;
                }
                UsageTrigger.trigger((String)"spring.EscapeAutowireQuickFix");
                new WriteCommandAction.Simple(springBean.getManager().getProject(), new PsiFile[]{DomUtil.getFile((DomElement)springBean)}){

                    protected void run() throws Throwable {
                        AutowiredDependenciesInspection.escapeAutowire(autowire.getValue(), springBean);
                    }
                }.execute();
            }
        };
    }

    private static void escapeAutowire(@NotNull String autowire, SpringBean springBean) {
        if (autowire == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "autowire", "com/intellij/spring/model/highlighting/AutowiredDependenciesInspection", "escapeAutowire"));
        }
        CommonSpringModel model = SpringModelUtils.getInstance().getSpringModel((SpringModelElement)springBean);
        if (autowire.equals(Autowire.BY_TYPE.getValue())) {
            AutowiredDependenciesInspection.escapeByTypeAutowire(springBean, model);
        } else if (autowire.equals(Autowire.BY_NAME.getValue())) {
            AutowiredDependenciesInspection.escapeByNameAutowire(springBean);
        } else if (autowire.equals(Autowire.CONSTRUCTOR.getValue())) {
            AutowiredDependenciesInspection.escapeConstructorAutowire(springBean, model);
        } else if (autowire.equals(Autowire.AUTODETECT.getValue())) {
            if (SpringConstructorArgResolveUtil.hasEmptyConstructor(springBean) && !SpringConstructorArgResolveUtil.isInstantiatedByFactory(springBean)) {
                AutowiredDependenciesInspection.escapeByTypeAutowire(springBean, model);
            } else {
                AutowiredDependenciesInspection.escapeConstructorAutowire(springBean, model);
            }
        }
    }

    private static void escapeConstructorAutowire(SpringBean springBean, CommonSpringModel model) {
        Map<PsiType, Collection<SpringBeanPointer>> map = SpringAutowireUtil.getConstructorAutowiredProperties(springBean, model);
        for (PsiType psiType : map.keySet()) {
            ConstructorArg arg = springBean.addConstructorArg();
            arg.getType().setStringValue(psiType.getCanonicalText());
            arg.getRefAttr().setStringValue(AutowiredDependenciesInspection.chooseReferencedBeanName(map.get(psiType)));
        }
        springBean.getAutowire().undefine();
    }

    private static void escapeByNameAutowire(SpringBean springBean) {
        Map<PsiMethod, SpringBeanPointer> autowiredProperties = SpringAutowireUtil.getByNameAutowiredProperties(springBean);
        for (PsiMethod psiMethod : autowiredProperties.keySet()) {
            SpringProperty springProperty = springBean.addProperty();
            SpringBeanPointer autowiredBean = autowiredProperties.get(psiMethod);
            String refBeanName = autowiredBean != null && autowiredBean.getName() != null ? autowiredBean.getName() : "";
            springProperty.getName().setStringValue(PropertyUtil.getPropertyNameBySetter((PsiMethod)psiMethod));
            springProperty.getRefAttr().setStringValue(refBeanName);
        }
        springBean.getAutowire().undefine();
    }

    private static void escapeByTypeAutowire(SpringBean springBean, CommonSpringModel model) {
        Map<PsiMethod, Collection<SpringBeanPointer>> autowiredProperties = SpringAutowireUtil.getByTypeAutowiredProperties(springBean, model);
        for (PsiMethod psiMethod : autowiredProperties.keySet()) {
            SpringProperty springProperty = springBean.addProperty();
            springProperty.getName().setStringValue(PropertyUtil.getPropertyNameBySetter((PsiMethod)psiMethod));
            springProperty.getRefAttr().setStringValue(AutowiredDependenciesInspection.chooseReferencedBeanName(autowiredProperties.get(psiMethod)));
        }
        springBean.getAutowire().undefine();
    }

    @NotNull
    private static String chooseReferencedBeanName(Collection<SpringBeanPointer> autowiredBeans) {
        if (autowiredBeans != null) {
            for (SpringBeanPointer autowiredBean : autowiredBeans) {
                CommonSpringModel model;
                String beanName = SpringBeanCoreUtils.getReferencedName(autowiredBean, (model = SpringModelUtils.getInstance().getSpringModelByBean(autowiredBean.getSpringBean())).getAllCommonBeans());
                if (beanName == null || beanName.trim().length() <= 0) continue;
                String string = beanName;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/AutowiredDependenciesInspection", "chooseReferencedBeanName"));
                }
                return string;
            }
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/AutowiredDependenciesInspection", "chooseReferencedBeanName"));
        }
        return "";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("AutowiredDependenciesInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/AutowiredDependenciesInspection", "getShortName"));
        }
        return "AutowiredDependenciesInspection";
    }
}

