/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.lookup;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.highlighting.jam.SpringBeanPointerResolveInspection;
import com.intellij.spring.model.jam.lookup.SpringLookupInjection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringLookupInjectionInspection
extends SpringBeanPointerResolveInspection {
    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/model/jam/lookup/SpringLookupInjectionInspection", "checkMethod"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/jam/lookup/SpringLookupInjectionInspection", "checkMethod"));
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass != null && SpringLookupInjectionInspection.isPlainJavaFileInSpringModule((PsiElement)aClass)) {
            PsiClass psiClass;
            SpringLookupInjection lookupInjection = (SpringLookupInjection)SpringLookupInjection.META.getJamElement((PsiModifierListOwner)method);
            if (lookupInjection == null) {
                return null;
            }
            PsiType returnType = method.getReturnType();
            if (returnType instanceof PsiClassType && (psiClass = ((PsiClassType)returnType).resolve()) != null) {
                ProblemsHolder holder = new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly);
                SpringLookupInjectionInspection.checkBeanPointerResolve((ProblemsHolder)holder, lookupInjection.getValueAttributeElement(), (String)psiClass.getQualifiedName());
                return holder.getResultsArray();
            }
        }
        return null;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringLookupInjectionInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/lookup/SpringLookupInjectionInspection", "getShortName"));
        }
        return "SpringLookupInjectionInspection";
    }
}

