/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.stereotype;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiClass;
import com.intellij.psi.targets.AliasingPsiTarget;
import com.intellij.psi.targets.AliasingPsiTargetMapper;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringStereotypeAliasingPsiTargetMapper
implements AliasingPsiTargetMapper {
    @NotNull
    public Set<AliasingPsiTarget> getTargets(@NotNull PomTarget psiTarget) {
        if (psiTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiTarget", "com/intellij/spring/model/jam/stereotype/SpringStereotypeAliasingPsiTargetMapper", "getTargets"));
        }
        if (!(psiTarget instanceof PsiClass)) {
            Set<AliasingPsiTarget> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/stereotype/SpringStereotypeAliasingPsiTargetMapper", "getTargets"));
            }
            return set;
        }
        Set set = (Set)ReadAction.compute(() -> {
            if (psiTarget == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiTarget", "com/intellij/spring/model/jam/stereotype/SpringStereotypeAliasingPsiTargetMapper", "lambda$getTargets$1"));
            }
            PsiClass psiClass = (PsiClass)psiTarget;
            if (psiClass.isInterface()) {
                return Collections.emptySet();
            }
            return (Set)DumbService.getInstance((Project)psiClass.getProject()).runReadActionInSmartMode(() -> {
                if (!SpringCommonUtils.isSpringBeanCandidateClassInSpringProject((PsiClass)psiClass)) {
                    return Collections.emptySet();
                }
                SpringStereotypeElement stereotypeElement = SpringJamUtils.getInstance().findStereotypeElement(psiClass);
                if (stereotypeElement != null && stereotypeElement.getPsiTarget() instanceof AliasingPsiTarget) {
                    return Collections.singleton((AliasingPsiTarget)stereotypeElement.getPsiTarget());
                }
                return Collections.emptySet();
            });
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/stereotype/SpringStereotypeAliasingPsiTargetMapper", "getTargets"));
        }
        return set;
    }
}

