/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamEnumAttributeElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.jam.testContexts.SpringContextHierarchy;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import com.intellij.spring.model.jam.testContexts.dirtiesContexts.SpringTestingDirtiesContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringTestingDirtiesContextInspection
extends BaseJavaLocalInspectionTool {
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/model/jam/testContexts/SpringTestingDirtiesContextInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/jam/testContexts/SpringTestingDirtiesContextInspection", "checkClass"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
        if (module != null && (SpringTestContextUtil.getInstance().isTestContextConfigurationClass(aClass) || ApplicationManager.getApplication().isUnitTestMode())) {
            ProblemsHolder holder = new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly);
            SpringTestingDirtiesContext dirtiesContext = (SpringTestingDirtiesContext)SpringTestingDirtiesContext.CLASS_META.getJamElement((PsiModifierListOwner)aClass);
            if (dirtiesContext != null) {
                this.checkMethodModeOnClass(holder, dirtiesContext);
                this.checkHierarchyMode(aClass, holder, dirtiesContext);
            }
            for (PsiMethod method : aClass.getMethods()) {
                SpringTestingDirtiesContext methodDirties = (SpringTestingDirtiesContext)SpringTestingDirtiesContext.METHOD_META.getJamElement((PsiModifierListOwner)method);
                if (methodDirties == null) continue;
                this.checkHierarchyMode(aClass, holder, methodDirties);
                this.checkClassModeOnMethod(holder, methodDirties);
            }
            return holder.getResultsArray();
        }
        return super.checkClass(aClass, manager, isOnTheFly);
    }

    public void checkMethodModeOnClass(ProblemsHolder holder, SpringTestingDirtiesContext dirtiesContext) {
        PsiAnnotationMemberValue psiElement;
        JamEnumAttributeElement methodModeElement = dirtiesContext.getMethodModeElement();
        if (methodModeElement.getValue() != null && (psiElement = methodModeElement.getPsiElement()) != null) {
            holder.registerProblem((PsiElement)psiElement, SpringBundle.message("spring.testing.model.dirties.method.mode.error.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    public void checkClassModeOnMethod(ProblemsHolder holder, SpringTestingDirtiesContext methodDirties) {
        PsiAnnotationMemberValue psiElement;
        JamEnumAttributeElement methodModeElement = methodDirties.getClassModeElement();
        if (methodModeElement.getValue() != null && (psiElement = methodModeElement.getPsiElement()) != null) {
            holder.registerProblem((PsiElement)psiElement, SpringBundle.message("spring.testing.model.dirties.class.mode.error.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    public void checkHierarchyMode(@Nullable PsiClass aClass, ProblemsHolder holder, @NotNull SpringTestingDirtiesContext dirtiesContext) {
        PsiAnnotationMemberValue psiElement;
        if (dirtiesContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirtiesContext", "com/intellij/spring/model/jam/testContexts/SpringTestingDirtiesContextInspection", "checkHierarchyMode"));
        }
        if (aClass == null) {
            return;
        }
        JamEnumAttributeElement hierarchyModeElement = dirtiesContext.getHierarchyModeElement();
        if (hierarchyModeElement.getValue() != null && SpringContextHierarchy.META.getJamElement((PsiModifierListOwner)aClass) == null && (psiElement = hierarchyModeElement.getPsiElement()) != null) {
            holder.registerProblem((PsiElement)psiElement, SpringBundle.message("spring.testing.model.dirties.hierarchy.mode.error.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringTestingDirtiesContextInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/SpringTestingDirtiesContextInspection", "getShortName"));
        }
        return "SpringTestingDirtiesContextInspection";
    }
}

