/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.run;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.execution.filters.Filter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.ShowBeansQuickFix;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.run.SpringMultipleOccurrencesFilter;
import com.intellij.util.Consumer;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

class BeanNameFilter
extends SpringMultipleOccurrencesFilter {
    private static final String[] DETECTION_MESSAGES = new String[]{"Error creating bean with name '", "containing bean '"};

    BeanNameFilter() {
    }

    @Override
    @Nullable
    protected Filter.Result findNextOccurrence(int startOffset, String line, int entireLength) {
        int index = -1;
        int messageLength = -1;
        for (String message : DETECTION_MESSAGES) {
            index = StringUtil.indexOf((CharSequence)line, (CharSequence)message, (int)startOffset);
            if (index == -1) continue;
            messageLength = message.length();
            break;
        }
        if (index == -1) {
            return null;
        }
        int beanNameStart = index + messageLength;
        int beanNameEnd = StringUtil.indexOf((CharSequence)line, (char)'\'', (int)beanNameStart);
        if (beanNameEnd == -1) {
            return null;
        }
        String beanName = line.substring(beanNameStart, beanNameEnd);
        int textStartOffset = entireLength - line.length() + beanNameStart;
        return new Filter.Result(textStartOffset, textStartOffset + beanName.length(), project -> BeanNameFilter.showResult((Consumer<Editor>)((Consumer)editor -> {
            List<SpringBeanPointer> beans = BeanNameFilter.findBeanCandidates(project, beanName);
            if (!beans.isEmpty()) {
                ShowBeansQuickFix.showBeanTargets(editor, beans);
                return;
            }
            PsiClass byBeanName = JavaPsiFacade.getInstance((Project)project).findClass(beanName, GlobalSearchScope.allScope((Project)project));
            if (byBeanName != null) {
                PsiNavigateUtil.navigate((PsiElement)byBeanName);
                return;
            }
            HintManager.getInstance().showErrorHint(editor, "Could not find bean with name '" + beanName + "'");
        })));
    }

    private static List<SpringBeanPointer> findBeanCandidates(Project project, String beanName) {
        SmartList beans = new SmartList();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Set models = SpringManager.getInstance((Project)project).getAllModelsWithoutDependencies(module);
            for (SpringModel model : models) {
                SpringBeanPointer byName = SpringModelSearchers.findBean((CommonSpringModel)model, (String)beanName);
                ContainerUtil.addIfNotNull((Collection)beans, (Object)byName);
            }
        }
        return beans;
    }
}

