/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.junit.TestsPattern;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.testframework.AbstractPatternBasedConfigurationProducer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.LinkedHashSet;
import java.util.Set;

public class PatternConfigurationProducer
extends AbstractPatternBasedConfigurationProducer<JUnitConfiguration> {
    public PatternConfigurationProducer() {
        super((ConfigurationType)JUnitConfigurationType.getInstance());
    }

    protected String getMethodPresentation(PsiMember psiMember) {
        return psiMember instanceof PsiMethod ? JUnitConfiguration.Data.getMethodPresentation((PsiMethod)psiMember) : super.getMethodPresentation(psiMember);
    }

    protected boolean setupConfigurationFromContext(JUnitConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        String paramSetName;
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        PsiElement element = this.checkPatterns(context, classes);
        if (element == null) {
            return false;
        }
        sourceElement.set((Object)element);
        JUnitConfiguration.Data data = configuration.getPersistentData();
        data.setPatterns(classes);
        data.TEST_OBJECT = "pattern";
        data.setScope(this.setupPackageConfiguration(context, (ModuleBasedConfiguration)configuration, data.getScope()));
        configuration.setGeneratedName();
        Location contextLocation = context.getLocation();
        if (contextLocation instanceof PsiMemberParameterizedLocation && (paramSetName = ((PsiMemberParameterizedLocation)contextLocation).getParamSetName()) != null) {
            configuration.setProgramParameters(paramSetName);
        }
        return true;
    }

    protected Module findModule(JUnitConfiguration configuration, Module contextModule) {
        Set<String> patterns = configuration.getPersistentData().getPatterns();
        return this.findModule((ModuleBasedConfiguration)configuration, contextModule, patterns);
    }

    public boolean isConfigurationFromContext(JUnitConfiguration unitConfiguration, ConfigurationContext context) {
        Set<String> patterns;
        TestObject testobject = unitConfiguration.getTestObject();
        return testobject instanceof TestsPattern && this.isConfiguredFromContext(context, patterns = unitConfiguration.getPersistentData().getPatterns());
    }
}

