/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.utils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.facet.FacetManager;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.ws.WSBundle;
import com.intellij.ws.WebServicesPluginSettings;
import com.intellij.ws.engines.jwsdp.JWSDPWSEngine;
import com.intellij.ws.engines.wsengine.WSEngine;
import com.intellij.ws.index.FileBasedWSIndex;
import com.intellij.ws.index.WSIndexEntry;
import com.intellij.ws.utils.CommonWsUtils;
import com.intellij.ws.utils.LibUtils;
import com.intellij.xml.XmlElementDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployUtils {
    public static Logger LOG = Logger.getInstance((String)"webservicesplugin.enablewssupport");

    public static boolean isAcceptableMethod(PsiMethod method) {
        return method.hasModifierProperty("public") && !method.isConstructor();
    }

    @Nullable
    public static String checkIfClassIsUpToDate(Project project, PsiClass myClass) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return null;
        }
        VirtualFile file = myClass.getContainingFile().getVirtualFile();
        boolean notUpToDate = DeployUtils.isMarkedForCompilation(project, file);
        return notUpToDate ? WSBundle.message("class.was.not.recompiled.after.changes.please.compile.before.proceeding.deploymnet.problem", myClass.getName()) : null;
    }

    private static boolean isMarkedForCompilation(Project project, VirtualFile file) {
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        return !compilerManager.isUpToDate(compilerManager.createFilesCompileScope(new VirtualFile[]{file}));
    }

    public static void removeFromConfigFile(String[] pathComponents, boolean at, Module module, Processor<XmlTag> processor) {
        if (!CommonWsUtils.isWebModule((Module)module)) {
            return;
        }
        VirtualFile fileByPath = CommonWsUtils.findFileByPath((Module)module, (String[])pathComponents, (boolean)at);
        if (fileByPath != null) {
            Runnable action = () -> {
                PsiManager instance = PsiManager.getInstance((Project)module.getProject());
                PsiFile file = instance.findFile(fileByPath);
                try {
                    XmlTag rootTag;
                    if (file instanceof XmlFile && (rootTag = ((XmlFile)file).getDocument().getRootTag()) != null) {
                        for (XmlTag t : rootTag.getSubTags()) {
                            if (!processor.process((Object)t)) continue;
                            t.delete();
                        }
                    }
                }
                catch (IncorrectOperationException ex) {
                    LOG.error((Throwable)ex);
                }
            };
            CommandProcessor.getInstance().executeCommand(module.getProject(), () -> ApplicationManager.getApplication().runWriteAction(action), "Remove from web services deployment descriptor", null);
        }
    }

    public static void addToConfigFile(String[] pathComponents, boolean createInContentRoot, Module module, @NonNls String fragmentToInsert, WSEngine engine) {
        if (!CommonWsUtils.hasJ2EE) {
            return;
        }
        WebFacet webFacet = (WebFacet)FacetManager.getInstance((Module)module).getFacetByType(WebFacet.ID);
        if (webFacet == null) {
            return;
        }
        VirtualFile fileByPath = CommonWsUtils.findFileByPath((Module)module, (String[])pathComponents, (boolean)createInContentRoot);
        if (fileByPath == null) {
            engine.doAdditionalWSServerSetup(module, webFacet);
            CommonWsUtils.doFileSystemRefresh();
            fileByPath = CommonWsUtils.findFileByPath((Module)module, (String[])pathComponents, (boolean)createInContentRoot);
        }
        if (fileByPath != null) {
            VirtualFile fileByPath1 = fileByPath;
            PsiManager instance = PsiManager.getInstance((Project)module.getProject());
            PsiFile file = instance.findFile(fileByPath1);
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)file)) {
                return;
            }
            Runnable action = () -> {
                try {
                    XmlTag rootTag;
                    PsiFile fileFromText = PsiFileFactory.getInstance((Project)instance.getProject()).createFileFromText("a.xml", fragmentToInsert);
                    if (fileFromText instanceof XmlFile && file instanceof XmlFile && (rootTag = ((XmlFile)file).getDocument().getRootTag()) != null) {
                        rootTag.add((PsiElement)((XmlFile)fileFromText).getDocument().getRootTag());
                    }
                }
                catch (IncorrectOperationException ex) {
                    LOG.error((Throwable)ex);
                }
            };
            CommandProcessor.getInstance().executeCommand(module.getProject(), () -> ApplicationManager.getApplication().runWriteAction(action), "Add to web services deployment descriptor", null);
        }
    }

    public static void processTagsInConfigFile(String[] pathComponents, boolean findInContentRoot, Module module, Processor<XmlTag> processor) {
        PsiManager instance;
        PsiFile file;
        if (!CommonWsUtils.isWebModule((Module)module)) {
            return;
        }
        VirtualFile fileByPath = CommonWsUtils.findFileByPath((Module)module, (String[])pathComponents, (boolean)findInContentRoot);
        if (fileByPath != null && (file = (instance = PsiManager.getInstance((Project)module.getProject())).findFile(fileByPath)) instanceof XmlFile) {
            XmlTag tag;
            XmlDocument document = ((XmlFile)file).getDocument();
            XmlTag xmlTag = tag = document != null ? document.getRootTag() : null;
            if (tag != null) {
                for (XmlTag t : tag.getSubTags()) {
                    if (processor.process((Object)t)) continue;
                    return;
                }
            }
        }
    }

    public static void updateWebXml(Project project, VirtualFile result, @NotNull String deploymentServletName, String deploymentServletClass) {
        if (deploymentServletName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentServletName", "com/intellij/ws/utils/DeployUtils", "updateWebXml"));
        }
        try {
            boolean seenWsServlet;
            XmlFile file = (XmlFile)PsiManager.getInstance((Project)project).findFile(result);
            XmlTag rootTag = file.getDocument().getRootTag();
            XmlTag[] tags = rootTag.findSubTags("servlet");
            boolean bl = seenWsServlet = LibUtils.findServletWithName(tags, deploymentServletName, deploymentServletClass) != null;
            if (!seenWsServlet) {
                String s = DeployUtils.loadWSWebXml(deploymentServletName);
                XmlTag tagFromText = XmlElementFactory.getInstance((Project)project).createTagFromText((CharSequence)s, StdFileTypes.XML.getLanguage());
                XmlTag[] nestedTags = tagFromText.getSubTags();
                CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        for (XmlTag nestedTag : nestedTags) {
                            if (nestedTag.getName().equals("servlet")) {
                                XmlElementDescriptor descriptor;
                                XmlElementDescriptor tagDescriptor = rootTag.getDescriptor();
                                XmlElementDescriptor xmlElementDescriptor = descriptor = tagDescriptor != null ? tagDescriptor.getElementDescriptor(nestedTag, null) : null;
                                if (descriptor == null) {
                                    rootTag.add((PsiElement)nestedTag);
                                    continue;
                                }
                                StringBuilder tagText = new StringBuilder();
                                tagText.append("<").append(XmlChildRole.START_TAG_NAME_FINDER.findChild(nestedTag.getNode()).getText()).append(">\n");
                                for (XmlElementDescriptor e : descriptor.getElementsDescriptors(nestedTag)) {
                                    XmlTag tag = nestedTag.findFirstSubTag(e.getName());
                                    if (tag == null) continue;
                                    tagText.append(tag.getText()).append("\n");
                                }
                                tagText.append("</").append(XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(nestedTag.getNode()).getText()).append(">");
                                rootTag.add((PsiElement)XmlElementFactory.getInstance((Project)project).createTagFromText((CharSequence)tagText.toString(), StdFileTypes.XML.getLanguage()));
                                continue;
                            }
                            rootTag.add((PsiElement)nestedTag);
                        }
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }), "Edit web.xml", null);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public static String loadWSWebXml(@NotNull String deploymentServletName) throws IOException {
        if (deploymentServletName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentServletName", "com/intellij/ws/utils/DeployUtils", "loadWSWebXml"));
        }
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(LibUtils.getResourcesStream(deploymentServletName + ".web.xml")));
        final StringBuffer xmlText = new StringBuffer();
        CommonWsUtils.doScanFile((LineNumberReader)reader, (CommonWsUtils.FileProcessor)new CommonWsUtils.FileProcessor(){
            final String urlPattern = "<url-pattern>";
            final Pattern p = Pattern.compile("(.*<url-pattern>)(/services)(.*)");

            public void fileScanningEnded() throws IOException {
            }

            public boolean process(String s) throws IOException {
                Matcher m;
                if (s.indexOf("<url-pattern>") != -1 && (m = this.p.matcher(s)).matches()) {
                    String escapedPrefix = StringUtil.escapeXml((String)WebServicesPluginSettings.getInstance().getWebServicesUrlPathPrefix());
                    xmlText.append(m.group(1)).append(escapedPrefix).append(m.group(3));
                    return true;
                }
                xmlText.append(s);
                return true;
            }
        });
        return xmlText.toString();
    }

    public static String determineWhereToPlaceTheFileUnderWebInf(Module module, @NonNls String baseWsdlFileName) {
        VirtualFile originalVirtualFile;
        WebDirectoryElement rootWebDirectory;
        VirtualFile originalVirtualFile2;
        String outputFileName = null;
        WebFacet webFacet = (WebFacet)FacetManager.getInstance((Module)module).getFacetByType(WebFacet.ID);
        WebDirectoryElement webInf = CommonWsUtils.findWebDirectoryByElement((String)"/WEB-INF", (WebFacet)webFacet);
        if (webInf != null && (originalVirtualFile2 = webInf.getOriginalVirtualFile()) != null) {
            outputFileName = originalVirtualFile2.getPath() + File.separatorChar + baseWsdlFileName;
        }
        String wsdlFileName = "WEB-INF" + File.separatorChar + baseWsdlFileName;
        if (outputFileName == null && (rootWebDirectory = CommonWsUtils.findWebDirectoryByElement((String)"/", (WebFacet)webFacet)) != null && (originalVirtualFile = rootWebDirectory.getOriginalVirtualFile()) != null) {
            outputFileName = originalVirtualFile.getPath() + wsdlFileName;
        }
        if (outputFileName == null) {
            outputFileName = ModuleRootManager.getInstance((Module)module).getContentRoots()[0].getPath() + File.separatorChar + wsdlFileName;
        }
        return outputFileName;
    }

    public static <T> boolean isMethodAnnotatedAs(PsiMethod method, String name, String attribute, Class<T> type, T value) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{name});
        if (annotation == null) {
            return false;
        }
        String val = AnnotationModelUtil.getObjectValue((PsiAnnotation)annotation, (String)attribute, type).getStringValue();
        return val != null && val.equals(value.toString());
    }

    public static boolean canBeWebMethod(PsiMember member) {
        if (!(member instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)member;
        if (DeployUtils.isMethodAnnotatedAs(method, "javax.jws.WebMethod", "exclude", Boolean.TYPE, false)) {
            return true;
        }
        if (DeployUtils.isMethodAnnotatedAs(method, "javax.jws.WebMethod", "exclude", Boolean.TYPE, true)) {
            return false;
        }
        PsiClass psiClass = method.getContainingClass();
        WSIndexEntry[] entries = FileBasedWSIndex.getWsEntries(member.getContainingClass());
        if (entries.length > 0 && entries[0].hasNonImplicitRef(member)) {
            return true;
        }
        if (psiClass == null || !DeployUtils.isAcceptableMethod(method)) {
            return false;
        }
        if (AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, JWSDPWSEngine.wsClassesSet) == null) {
            return DeployUtils.isAcceptableMethod(method);
        }
        return !DeployUtils.isMethodAnnotatedAsExist("javax.jws.WebMethod", psiClass.getMethods());
    }

    private static boolean isMethodAnnotatedAsExist(String annoFQN, PsiMethod ... methods) {
        for (PsiMethod method : methods) {
            if (AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{annoFQN}) == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getWebServiceName(Module module, final PsiClass currentClass, String[] components, boolean findInContentRoot, final String implementor, final String id) {
        VirtualFile xml = CommonWsUtils.findFileByPath((Module)module, (String[])components, (boolean)findInContentRoot);
        if (xml == null) {
            return null;
        }
        final Ref ref = new Ref();
        try {
            NanoXmlUtil.parse((InputStream)xml.getInputStream(), (IXMLBuilder)new NanoXmlUtil.IXMLBuilderAdapter(){
                private Map<String, String> map = new HashMap<String, String>();

                public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                    this.map.put(key, value);
                }

                public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
                    if (this.map.get(implementor).equals(currentClass.getQualifiedName())) {
                        ref.set((Object)this.map.get(id));
                    }
                    this.map.clear();
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (String)ref.get();
    }
}

