/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.jaxb;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.ws.WSBundle;
import com.intellij.ws.WebServicesPluginSettings;
import com.intellij.ws.actions.WebServicePlatformUtils;
import com.intellij.ws.utils.LibUtils;
import com.intellij.ws.utils.ui.GenerateFromJavaCodeDialogBase;
import com.intellij.ws.utils.ui.MethodDeploymentTableModel;
import com.intellij.ws.utils.ui.MyDialogWrapper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GenerateJAXBSchemasFromJavaDialog
extends GenerateFromJavaCodeDialogBase {
    private JPanel myPanel;
    private JLabel className;
    private JLabel classNameText;
    private JCheckBox includeFollowingMethods;
    private JTable methodsTable;
    private JScrollPane myMethodsScrollPane;

    public GenerateJAXBSchemasFromJavaDialog(Project _project, PsiClass clazz, @Nullable GenerateJAXBSchemasFromJavaDialog previousDialog) {
        super(_project, clazz);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(WSBundle.message("generate.xml.schema.from.java.using.jaxb.dialog.title", objectArray));
        this.includeFollowingMethods.setSelected(true);
        this.includeFollowingMethods.setMnemonic('i');
        this.includeFollowingMethods.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = GenerateJAXBSchemasFromJavaDialog.this.includeFollowingMethods.isSelected();
                GenerateJAXBSchemasFromJavaDialog.this.myMethodsScrollPane.setVisible(selected);
                GenerateJAXBSchemasFromJavaDialog.this.myMethodsScrollPane.getParent().invalidate();
                GenerateJAXBSchemasFromJavaDialog.this.myMethodsScrollPane.getParent().validate();
                GenerateJAXBSchemasFromJavaDialog.this.pack();
            }
        });
        if (previousDialog != null) {
            SwingUtilities.invokeLater(() -> {
                this.setCurrentClass(previousDialog.getCurrentClass());
                this.setClassNameToUI(previousDialog.getCurrentClass());
                this.methodsTable.setModel(previousDialog.getMethodsTable().getModel());
                this.includeFollowingMethods.setSelected(previousDialog.includeFollowingMethods.isSelected());
            });
        } else {
            this.includeFollowingMethods.setSelected(false);
        }
        this.init();
    }

    @Override
    protected JTable getMethodsTable() {
        return this.methodsTable;
    }

    @Override
    protected ValidationInfo doValidate(MyDialogWrapper.ValidationData _data) {
        Module module;
        PsiClass psiClass = this.getCurrentClass();
        Module module2 = module = psiClass != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass) : null;
        if (module == null) {
            if (psiClass == null) {
                return new ValidationInfo("No class is selected");
            }
            String fqn = (String)ReadAction.compute(() -> psiClass.getQualifiedName());
            return new ValidationInfo("Class " + fqn + " doesn't belong to some project module", null);
        }
        ValidationInfo validationResult = GenerateJAXBSchemasFromJavaDialog.checkJWSDPPathSet(module);
        if (validationResult != null) {
            return validationResult;
        }
        String path = WebServicesPluginSettings.getInstance().getEngineManager().getExternalEngineByName("JAXB 2").getBasePath();
        if (path == null && !JavaVersionService.getInstance().isAtLeast((PsiElement)psiClass, JavaSdkVersion.JDK_1_6) && LibUtils.getLibUrlsForToolRunning("com.sun.tools.internal.jxc.SchemaGenerator", this.myProject).length == 0) {
            return new ValidationInfo("Please, specify JWSDP/Glassfish Path in plugin settings", null);
        }
        validationResult = super.doValidate(_data);
        if (validationResult == null) {
            MyValidationData validationData = (MyValidationData)_data;
            if (validationData.includeTypesOfMethods && validationData.selectedMethods.length == 0) {
                return new ValidationInfo("No methods selected", null);
            }
        }
        return validationResult;
    }

    static ValidationInfo checkJWSDPPathSet(Module module) {
        if (WebServicesPluginSettings.getInstance().getJwsdpPath() == null && !WebServicePlatformUtils.isJdk1_6SetUpForModule(module)) {
            return new ValidationInfo("Please, specify JWSDP/Glassfish Path in plugin settings or use JDK 6", null);
        }
        return null;
    }

    @Override
    protected MyValidationData createValidationData() {
        return new MyValidationData();
    }

    @Override
    protected MethodDeploymentTableModel createMethodDeploymentTable(List<PsiMethod> methodsAllowedForDeployment, List<PsiMethod> methodsNotAllowedForDeployment) {
        return new MethodDeploymentTableModel(methodsAllowedForDeployment, methodsNotAllowedForDeployment){

            @Override
            public String getColumnName(int column) {
                if (column == 0) {
                    return "Add to JAXB Generation";
                }
                return "Parameter / return types of following method";
            }
        };
    }

    @Override
    protected JComponent getClassName() {
        return this.className;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    boolean toIncludeTypesOfMethods() {
        return this.includeFollowingMethods.isSelected();
    }

    @Override
    @NotNull
    protected String getHelpId() {
        if ("GenerateJAXBSchemasFromJava.html" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/xml/jaxb/GenerateJAXBSchemasFromJavaDialog", "getHelpId"));
        }
        return "GenerateJAXBSchemasFromJava.html";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.classNameText = jLabel2 = new JLabel();
        jLabel2.setText("Class name:");
        jLabel2.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("jaxb.classname.tooltip"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.className = jLabel = new JLabel();
        jLabel.setText("");
        jLabel.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("jaxb.classname.tooltip"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.includeFollowingMethods = jCheckBox = new JCheckBox();
        jCheckBox.setText("Include parameter and return types of following methods:");
        jCheckBox.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("jaxb.include.parameters.return.types.of.methods.tooltips"));
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        this.myMethodsScrollPane = jBScrollPane;
        jBScrollPane.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("jaxb.include.parameters.return.types.of.methods.tooltips"));
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        JBTable jBTable = new JBTable();
        this.methodsTable = jBTable;
        jBTable.setPreferredScrollableViewportSize(new Dimension(250, 200));
        jBScrollPane.setViewportView((Component)jBTable);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    class MyValidationData
    extends GenerateFromJavaCodeDialogBase.MyValidationData {
        boolean includeTypesOfMethods;

        MyValidationData() {
        }

        @Override
        protected void doAcquire() {
            this.includeTypesOfMethods = GenerateJAXBSchemasFromJavaDialog.this.toIncludeTypesOfMethods();
            super.doAcquire();
        }
    }
}

