/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.openapi.module.Module;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.actions.SurroundAction;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.inspections.BaseFormInspection;
import com.intellij.uiDesigner.inspections.FormErrorCollector;
import com.intellij.uiDesigner.inspections.FormInspectionUtil;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.quickFixes.QuickFix;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import org.jetbrains.annotations.NotNull;

public class NoScrollPaneInspection
extends BaseFormInspection {
    public NoScrollPaneInspection() {
        super("NoScrollPane");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = UIDesignerBundle.message("inspection.no.scroll.pane", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/inspections/NoScrollPaneInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected void checkComponentProperties(Module module, @NotNull IComponent component, FormErrorCollector collector) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/uiDesigner/inspections/NoScrollPaneInspection", "checkComponentProperties"));
        }
        if (FormInspectionUtil.isComponentClass(module, component, Scrollable.class) && !FormInspectionUtil.isComponentClass(module, component, JTextField.class) && !FormInspectionUtil.isComponentClass(module, (IComponent)component.getParentContainer(), JScrollPane.class)) {
            collector.addError(this.getID(), component, null, UIDesignerBundle.message("inspection.no.scroll.pane", new Object[0]), MyQuickFix::new);
        }
    }

    private static class MyQuickFix
    extends QuickFix {
        MyQuickFix(GuiEditor editor, RadComponent component) {
            super(editor, UIDesignerBundle.message("inspection.no.scroll.pane.quickfix", new Object[0]), component);
        }

        @Override
        public void run() {
            String scrollPane = JScrollPane.class.getName();
            ComponentItem item = Palette.getInstance(this.myEditor.getProject()).getItem(scrollPane);
            SurroundAction action = new SurroundAction(item == null ? JBScrollPane.class.getName() : scrollPane);
            ArrayList<RadComponent> targetList = new ArrayList<RadComponent>(Collections.singletonList(this.myComponent));
            action.actionPerformed(this.myEditor, targetList, null);
        }
    }
}

