/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.make;

import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.uiDesigner.ErrorAnalyzer;
import com.intellij.uiDesigner.ErrorInfo;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.PsiPropertiesProvider;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.compiler.AlienFormFileException;
import com.intellij.uiDesigner.compiler.ClassToBindNotFoundException;
import com.intellij.uiDesigner.compiler.CodeGenerationException;
import com.intellij.uiDesigner.compiler.FormErrorInfo;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.core.SupportCode;
import com.intellij.uiDesigner.lw.ColorDescriptor;
import com.intellij.uiDesigner.lw.FontDescriptor;
import com.intellij.uiDesigner.lw.IButtonGroup;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IContainer;
import com.intellij.uiDesigner.lw.IRootContainer;
import com.intellij.uiDesigner.lw.IconDescriptor;
import com.intellij.uiDesigner.lw.LwComponent;
import com.intellij.uiDesigner.lw.LwContainer;
import com.intellij.uiDesigner.lw.LwIntroComponentProperty;
import com.intellij.uiDesigner.lw.LwIntroEnumProperty;
import com.intellij.uiDesigner.lw.LwIntroListModelProperty;
import com.intellij.uiDesigner.lw.LwIntrospectedProperty;
import com.intellij.uiDesigner.lw.LwNestedForm;
import com.intellij.uiDesigner.lw.LwRbIntroStringProperty;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.lw.LwScrollPane;
import com.intellij.uiDesigner.lw.LwSplitPane;
import com.intellij.uiDesigner.lw.LwTabbedPane;
import com.intellij.uiDesigner.lw.LwToolBar;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.make.BorderLayoutSourceGenerator;
import com.intellij.uiDesigner.make.CardLayoutSourceGenerator;
import com.intellij.uiDesigner.make.FlowLayoutSourceGenerator;
import com.intellij.uiDesigner.make.FormLayoutSourceGenerator;
import com.intellij.uiDesigner.make.GridBagLayoutSourceGenerator;
import com.intellij.uiDesigner.make.GridLayoutSourceGenerator;
import com.intellij.uiDesigner.make.LayoutSourceGenerator;
import com.intellij.uiDesigner.make.PsiNestedFormLoader;
import com.intellij.uiDesigner.make.ScrollPaneLayoutSourceGenerator;
import com.intellij.uiDesigner.make.SplitPaneLayoutSourceGenerator;
import com.intellij.uiDesigner.make.TabbedPaneLayoutSourceGenerator;
import com.intellij.uiDesigner.make.ToolBarLayoutSourceGenerator;
import com.intellij.uiDesigner.shared.BorderType;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FormSourceCodeGenerator {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.uiDesigner.make.FormSourceCodeGenerator");
    @NonNls
    private StringBuffer myBuffer;
    private Stack<Boolean> myIsFirstParameterStack;
    private final Project myProject;
    private final ArrayList<FormErrorInfo> myErrors;
    private boolean myNeedLoadLabelText;
    private boolean myNeedLoadButtonText;
    private static final Map<Class, LayoutSourceGenerator> ourComponentLayoutCodeGenerators = new HashMap<Class, LayoutSourceGenerator>();
    private static final Map<String, LayoutSourceGenerator> ourContainerLayoutCodeGenerators = new HashMap<String, LayoutSourceGenerator>();
    @NonNls
    private static final TIntObjectHashMap<String> ourFontStyleMap = new TIntObjectHashMap();
    @NonNls
    private static final TIntObjectHashMap<String> ourTitleJustificationMap = new TIntObjectHashMap();
    @NonNls
    private static final TIntObjectHashMap<String> ourTitlePositionMap = new TIntObjectHashMap();
    private static final ElementPattern ourSuperCallPattern = PsiJavaPatterns.psiExpressionStatement().withFirstChild((ElementPattern)PlatformPatterns.psiElement(PsiMethodCallExpression.class).withFirstChild((ElementPattern)PlatformPatterns.psiElement().withText("super")));
    private String myGetFontMethod;

    public FormSourceCodeGenerator(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/uiDesigner/make/FormSourceCodeGenerator", "<init>"));
        }
        this.myProject = project;
        this.myErrors = new ArrayList();
    }

    public void generate(VirtualFile formFile) {
        LwRootContainer rootContainer;
        this.myNeedLoadLabelText = false;
        this.myNeedLoadButtonText = false;
        Module module = ModuleUtil.findModuleForFile((VirtualFile)formFile, (Project)this.myProject);
        if (module == null) {
            return;
        }
        ourContainerLayoutCodeGenerators.clear();
        ourContainerLayoutCodeGenerators.put("GridLayoutManager", new GridLayoutSourceGenerator());
        ourContainerLayoutCodeGenerators.put("GridBagLayout", new GridBagLayoutSourceGenerator());
        ourContainerLayoutCodeGenerators.put("BorderLayout", new BorderLayoutSourceGenerator());
        ourContainerLayoutCodeGenerators.put("FlowLayout", new FlowLayoutSourceGenerator());
        ourContainerLayoutCodeGenerators.put("CardLayout", new CardLayoutSourceGenerator());
        ourContainerLayoutCodeGenerators.put("FormLayout", new FormLayoutSourceGenerator());
        this.myErrors.clear();
        PsiPropertiesProvider propertiesProvider = new PsiPropertiesProvider(module);
        Document doc = FileDocumentManager.getInstance().getDocument(formFile);
        try {
            rootContainer = Utils.getRootContainer((String)doc.getText(), (PropertiesProvider)propertiesProvider);
        }
        catch (AlienFormFileException ignored) {
            return;
        }
        catch (Exception e) {
            this.myErrors.add(new FormErrorInfo(null, UIDesignerBundle.message("error.cannot.process.form.file", e)));
            return;
        }
        if (rootContainer.getClassToBind() == null) {
            return;
        }
        ErrorAnalyzer.analyzeErrors(module, formFile, null, (IRootContainer)rootContainer, null);
        FormEditingUtil.iterate((IComponent)rootContainer, new FormEditingUtil.ComponentVisitor<LwComponent>(){

            @Override
            public boolean visit(LwComponent iComponent) {
                ErrorInfo errorInfo = ErrorAnalyzer.getErrorForComponent((IComponent)iComponent);
                if (errorInfo != null) {
                    String message = iComponent.getBinding() != null ? UIDesignerBundle.message("error.for.component", iComponent.getBinding(), errorInfo.myDescription) : errorInfo.myDescription;
                    FormSourceCodeGenerator.this.myErrors.add(new FormErrorInfo(iComponent.getId(), message));
                }
                return true;
            }
        });
        if (this.myErrors.size() != 0) {
            return;
        }
        try {
            this._generate(rootContainer, module);
        }
        catch (ClassToBindNotFoundException e) {
        }
        catch (CodeGenerationException e) {
            this.myErrors.add(new FormErrorInfo(e.getComponentId(), e.getMessage()));
        }
        catch (IncorrectOperationException e) {
            this.myErrors.add(new FormErrorInfo(null, e.getMessage()));
        }
    }

    public ArrayList<FormErrorInfo> getErrors() {
        return this.myErrors;
    }

    private void _generate(LwRootContainer rootContainer, Module module) throws CodeGenerationException, IncorrectOperationException {
        boolean haveCustomCreateComponents;
        this.myBuffer = new StringBuffer();
        this.myIsFirstParameterStack = new Stack();
        HashMap<LwComponent, String> component2variable = new HashMap<LwComponent, String>();
        TObjectIntHashMap class2variableIndex = new TObjectIntHashMap();
        HashMap<String, LwComponent> id2component = new HashMap<String, LwComponent>();
        if (rootContainer.getComponentCount() != 1) {
            throw new CodeGenerationException(null, UIDesignerBundle.message("error.one.toplevel.component.required", new Object[0]));
        }
        LwComponent topComponent = (LwComponent)rootContainer.getComponent(0);
        String id = Utils.findNotEmptyPanelWithXYLayout((IComponent)topComponent);
        if (id != null) {
            throw new CodeGenerationException(id, UIDesignerBundle.message("error.nonempty.xy.panels.found", new Object[0]));
        }
        PsiClass classToBind = FormEditingUtil.findClassToBind(module, rootContainer.getClassToBind());
        if (classToBind == null) {
            throw new ClassToBindNotFoundException(UIDesignerBundle.message("error.class.to.bind.not.found", rootContainer.getClassToBind()));
        }
        boolean bl = haveCustomCreateComponents = Utils.getCustomCreateComponentCount((IContainer)rootContainer) > 0;
        if (haveCustomCreateComponents) {
            if (FormEditingUtil.findCreateComponentsMethod(classToBind) == null) {
                throw new CodeGenerationException(null, UIDesignerBundle.message("error.no.custom.create.method", new Object[0]));
            }
            this.myBuffer.append("createUIComponents").append("();");
        }
        this.generateSetupCodeForComponent(topComponent, component2variable, (TObjectIntHashMap<String>)class2variableIndex, id2component, module, classToBind);
        this.generateComponentReferenceProperties(topComponent, component2variable, (TObjectIntHashMap<String>)class2variableIndex, id2component, classToBind);
        this.generateButtonGroups(rootContainer, component2variable, (TObjectIntHashMap<String>)class2variableIndex, id2component, classToBind);
        String methodText = this.myBuffer.toString();
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
        PsiClass newClass = (PsiClass)classToBind.copy();
        FormSourceCodeGenerator.cleanup(newClass);
        PsiClass fakeClass = elementFactory.createClassFromText("{\n// GUI initializer generated by " + ApplicationNamesInfo.getInstance().getFullProductName() + " GUI Designer\n// >>> IMPORTANT!! <<<\n// DO NOT EDIT OR ADD ANY CODE HERE!\n" + "$$$setupUI$$$" + "();\n}\n\n/** Method generated by " + ApplicationNamesInfo.getInstance().getFullProductName() + " GUI Designer\n * >>> IMPORTANT!! <<<\n * DO NOT edit this method OR call it in your code!\n * @noinspection ALL\n */\nprivate void " + "$$$setupUI$$$" + "()\n{\n" + methodText + "}\n", null);
        CodeStyleManager formatter = CodeStyleManager.getInstance((Project)module.getProject());
        JavaCodeStyleManager styler = JavaCodeStyleManager.getInstance((Project)module.getProject());
        PsiMethod method = (PsiMethod)newClass.add((PsiElement)fakeClass.getMethods()[0]);
        boolean needInitializer = true;
        boolean needSetupUI = false;
        for (PsiMethod constructor : newClass.getConstructors()) {
            if (FormSourceCodeGenerator.containsMethodIdentifier((PsiElement)constructor, method)) {
                needInitializer = false;
                continue;
            }
            if (!haveCustomCreateComponents || !FormSourceCodeGenerator.hasCustomComponentAffectingReferences((PsiElement)constructor, newClass, rootContainer, null)) continue;
            needInitializer = false;
            needSetupUI = true;
        }
        if (needSetupUI) {
            for (PsiMethod constructor : newClass.getConstructors()) {
                FormSourceCodeGenerator.addSetupUICall(constructor, rootContainer, method);
            }
        }
        if (needInitializer) {
            newClass.addBefore((PsiElement)fakeClass.getInitializers()[0], (PsiElement)method);
        }
        String grcMethodText = "/** @noinspection ALL */ public javax.swing.JComponent $$$getRootComponent$$$() { return " + topComponent.getBinding() + "; }";
        this.generateMethodIfRequired(newClass, method, "$$$getRootComponent$$$", grcMethodText, topComponent.getBinding() != null);
        String loadButtonTextMethodText = this.getLoadMethodText("$$$loadButtonText$$$", AbstractButton.class, module);
        this.generateMethodIfRequired(newClass, method, "$$$loadButtonText$$$", loadButtonTextMethodText, this.myNeedLoadButtonText);
        String loadLabelTextMethodText = this.getLoadMethodText("$$$loadLabelText$$$", JLabel.class, module);
        this.generateMethodIfRequired(newClass, method, "$$$loadLabelText$$$", loadLabelTextMethodText, this.myNeedLoadLabelText);
        if (this.myGetFontMethod != null) {
            String getFontMethod = "/** @noinspection ALL */ private java.awt.Font " + this.myGetFontMethod + "(String fontName, int style, int size, java.awt.Font currentFont) {if (currentFont == null) return null;String resultName;if (fontName == null) {resultName = currentFont.getName();}else {  java.awt.Font testFont = new java.awt.Font(fontName, java.awt.Font.PLAIN, 10);  if (testFont.canDisplay('a') && testFont.canDisplay('1')) {resultName = fontName;}  else {resultName = currentFont.getName();}}return new java.awt.Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());}";
            this.generateMethodIfRequired(newClass, method, this.myGetFontMethod, getFontMethod, true);
        }
        newClass = (PsiClass)styler.shortenClassReferences((PsiElement)newClass);
        if (!FormSourceCodeGenerator.lexemsEqual(classToBind, newClass = (PsiClass)formatter.reformat((PsiElement)newClass))) {
            classToBind.replace((PsiElement)newClass);
        }
    }

    private static void addSetupUICall(PsiMethod constructor, LwRootContainer rootContainer, PsiMethod setupUIMethod) {
        PsiCodeBlock psiCodeBlock = constructor.getBody();
        if (psiCodeBlock == null) {
            return;
        }
        PsiClass classToBind = constructor.getContainingClass();
        PsiStatement[] statements = psiCodeBlock.getStatements();
        PsiJavaToken anchor = psiCodeBlock.getRBrace();
        Ref callsThisConstructor = new Ref((Object)Boolean.FALSE);
        for (PsiStatement statement : statements) {
            if (FormSourceCodeGenerator.containsMethodIdentifier((PsiElement)statement, setupUIMethod)) {
                return;
            }
            if (ourSuperCallPattern.accepts((Object)statement) || !FormSourceCodeGenerator.hasCustomComponentAffectingReferences((PsiElement)statement, classToBind, rootContainer, (Ref<Boolean>)callsThisConstructor)) continue;
            anchor = statement;
            break;
        }
        if (!((Boolean)callsThisConstructor.get()).booleanValue()) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)constructor.getProject()).getElementFactory();
            try {
                PsiStatement setupUIStatement = factory.createStatementFromText("$$$setupUI$$$();", (PsiElement)constructor);
                psiCodeBlock.addBefore((PsiElement)setupUIStatement, (PsiElement)anchor);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static boolean hasCustomComponentAffectingReferences(PsiElement element, final PsiClass classToBind, final LwRootContainer rootContainer, final @Nullable Ref<Boolean> callsThisConstructor) {
        final Ref result = new Ref((Object)Boolean.FALSE);
        element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                super.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
                PsiElement psiElement = expression.resolve();
                if (psiElement == null) {
                    return;
                }
                if (psiElement instanceof PsiField) {
                    PsiField field = (PsiField)psiElement;
                    if (field.getContainingClass().equals(classToBind) && Utils.isBoundField((IComponent)rootContainer, (String)field.getName())) {
                        result.set((Object)Boolean.TRUE);
                    }
                } else if (psiElement instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)psiElement;
                    if (method.isConstructor()) {
                        if (method.getContainingClass() == classToBind) {
                            if (callsThisConstructor != null) {
                                callsThisConstructor.set((Object)Boolean.TRUE);
                            }
                        } else if (method.getContainingClass() != classToBind.getSuperClass()) {
                            result.set((Object)Boolean.TRUE);
                        }
                    } else {
                        result.set((Object)Boolean.TRUE);
                    }
                }
            }
        });
        return (Boolean)result.get();
    }

    private static boolean lexemsEqual(PsiClass classToBind, PsiClass newClass) {
        Lexer oldTextLexer = JavaParserDefinition.createLexer((LanguageLevel)LanguageLevel.HIGHEST);
        Lexer newTextLexer = JavaParserDefinition.createLexer((LanguageLevel)LanguageLevel.HIGHEST);
        String oldBuffer = classToBind.getText();
        String newBuffer = newClass.getText();
        oldTextLexer.start((CharSequence)oldBuffer);
        newTextLexer.start((CharSequence)newBuffer);
        while (true) {
            IElementType oldLexem = oldTextLexer.getTokenType();
            IElementType newLexem = newTextLexer.getTokenType();
            if (oldLexem == null || newLexem == null) {
                return oldLexem == null && newLexem == null;
            }
            if (oldLexem != newLexem) {
                return false;
            }
            if (oldLexem != TokenType.WHITE_SPACE && oldLexem != JavaDocElementType.DOC_COMMENT) {
                int newLength;
                int oldStart = oldTextLexer.getTokenStart();
                int newStart = newTextLexer.getTokenStart();
                int oldLength = oldTextLexer.getTokenEnd() - oldTextLexer.getTokenStart();
                if (oldLength != (newLength = newTextLexer.getTokenEnd() - newTextLexer.getTokenStart())) {
                    return false;
                }
                for (int i = 0; i < oldLength; ++i) {
                    if (oldBuffer.charAt(oldStart + i) == newBuffer.charAt(newStart + i)) continue;
                    return false;
                }
            }
            oldTextLexer.advance();
            newTextLexer.advance();
        }
    }

    @NonNls
    private String getLoadMethodText(String methodName, Class componentClass, Module module) {
        boolean needIndex = this.haveSetDisplayedMnemonic(componentClass, module);
        return "/** @noinspection ALL */ private void " + methodName + "(" + componentClass.getName() + " component, java.lang.String text) {  StringBuffer result = new StringBuffer();   boolean haveMnemonic = false;      char mnemonic = '\\0';" + (needIndex ? "int mnemonicIndex = -1;" : "") + "  for(int i=0; i<text.length(); i++) {    if (text.charAt(i) == '&') {      i++;      if (i == text.length()) break;      if (!haveMnemonic && text.charAt(i) != '&') {        haveMnemonic = true;        mnemonic = text.charAt(i);" + (needIndex ? "mnemonicIndex = result.length();" : "") + "      }    }    result.append(text.charAt(i));  }  component.setText(result.toString());   if (haveMnemonic) {" + (componentClass.equals(AbstractButton.class) ? "        component.setMnemonic(mnemonic);" : "        component.setDisplayedMnemonic(mnemonic);") + (needIndex ? "component.setDisplayedMnemonicIndex(mnemonicIndex);" : "") + "} }";
    }

    private void generateMethodIfRequired(PsiClass aClass, PsiMethod anchor, String methodName, String methodText, boolean condition) throws IncorrectOperationException {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
        PsiMethod newMethod = null;
        PsiMethod[] oldMethods = aClass.findMethodsByName(methodName, false);
        if (!condition) {
            for (PsiMethod oldMethod : oldMethods) {
                oldMethod.delete();
            }
        } else {
            newMethod = elementFactory.createMethodFromText(methodText, (PsiElement)aClass);
            newMethod = oldMethods.length > 0 ? (PsiMethod)oldMethods[0].replace((PsiElement)newMethod) : (PsiMethod)aClass.addAfter((PsiElement)newMethod, (PsiElement)anchor);
        }
    }

    public static void cleanup(PsiClass aClass) throws IncorrectOperationException {
        PsiMethod[] methods;
        for (PsiMethod method : methods = aClass.findMethodsByName("$$$setupUI$$$", false)) {
            PsiClassInitializer[] initializers;
            for (PsiClassInitializer initializer : initializers = aClass.getInitializers()) {
                if (!FormSourceCodeGenerator.containsMethodIdentifier((PsiElement)initializer, method)) continue;
                initializer.delete();
            }
            method.delete();
        }
        FormSourceCodeGenerator.deleteMethods(aClass, "$$$getRootComponent$$$");
        FormSourceCodeGenerator.deleteMethods(aClass, "$$$loadButtonText$$$");
        FormSourceCodeGenerator.deleteMethods(aClass, "$$$loadLabelText$$$");
    }

    private static void deleteMethods(PsiClass aClass, String methodName) throws IncorrectOperationException {
        PsiMethod[] grcMethods;
        for (PsiMethod grcMethod : grcMethods = aClass.findMethodsByName(methodName, false)) {
            grcMethod.delete();
        }
    }

    private static boolean containsMethodIdentifier(PsiElement element, PsiMethod setupMethod) {
        PsiMethod psiMethod;
        if (element instanceof PsiMethodCallExpression && setupMethod.equals(psiMethod = ((PsiMethodCallExpression)element).resolveMethod())) {
            return true;
        }
        PsiElement[] children = element.getChildren();
        for (int i = children.length - 1; i >= 0; --i) {
            if (!FormSourceCodeGenerator.containsMethodIdentifier(children[i], setupMethod)) continue;
            return true;
        }
        return false;
    }

    private void generateSetupCodeForComponent(LwComponent component, HashMap<LwComponent, String> component2TempVariable, TObjectIntHashMap<String> class2variableIndex, HashMap<String, LwComponent> id2component, Module module, PsiClass aClass) throws CodeGenerationException {
        LwContainer container;
        String componentClass;
        id2component.put(component.getId(), component);
        GlobalSearchScope globalSearchScope = module.getModuleWithDependenciesAndLibrariesScope(false);
        LwContainer parent = component.getParent();
        String variable = FormSourceCodeGenerator.getVariable(component, component2TempVariable, class2variableIndex, aClass);
        String string = componentClass = component instanceof LwNestedForm ? FormSourceCodeGenerator.getNestedFormClass(module, (LwNestedForm)component) : FormSourceCodeGenerator.getComponentLayoutGenerator(component.getParent()).mapComponentClass(component.getComponentClassName());
        if (component.isCustomCreate() && component.getBinding() == null) {
            throw new CodeGenerationException(component.getId(), UIDesignerBundle.message("error.custom.create.no.binding", new Object[0]));
        }
        if (!component.isCustomCreate()) {
            String binding = component.getBinding();
            if (binding != null) {
                this.myBuffer.append(binding);
            } else {
                this.myBuffer.append("final ");
                this.myBuffer.append(componentClass);
                this.myBuffer.append(" ");
                this.myBuffer.append(variable);
            }
            this.myBuffer.append('=');
            this.startConstructor(componentClass);
            this.endConstructor();
        }
        if (component instanceof LwContainer && (!(container = (LwContainer)component).isCustomCreate() || container.getComponentCount() > 0)) {
            FormSourceCodeGenerator.getComponentLayoutGenerator(container).generateContainerLayout(container, this, variable);
        }
        LwIntrospectedProperty[] introspectedProperties = component.getAssignedIntrospectedProperties();
        Arrays.sort(introspectedProperties, (p1, p2) -> p1.getName().compareTo(p2.getName()));
        for (LwIntrospectedProperty property : introspectedProperties) {
            ColorDescriptor descriptor;
            String propertyClass;
            boolean isTextWithMnemonicProperty;
            if (property instanceof LwIntroComponentProperty) continue;
            Object value = component.getPropertyValue(property);
            boolean bl = isTextWithMnemonicProperty = "text".equals(property.getName()) && (this.isAssignableFrom(AbstractButton.class.getName(), componentClass, globalSearchScope) || this.isAssignableFrom(JLabel.class.getName(), componentClass, globalSearchScope));
            if (property instanceof LwRbIntroStringProperty) {
                StringDescriptor descriptor2 = (StringDescriptor)value;
                if (descriptor2.getValue() == null) {
                    if (isTextWithMnemonicProperty) {
                        if (this.isAssignableFrom(AbstractButton.class.getName(), componentClass, globalSearchScope)) {
                            this.myNeedLoadButtonText = true;
                            this.startMethodCall("this", "$$$loadButtonText$$$");
                            this.pushVar(variable);
                            this.push(descriptor2);
                            this.endMethod();
                            continue;
                        }
                        this.myNeedLoadLabelText = true;
                        this.startMethodCall("this", "$$$loadLabelText$$$");
                        this.pushVar(variable);
                        this.push(descriptor2);
                        this.endMethod();
                        continue;
                    }
                    this.startMethodCall(variable, property.getWriteMethodName());
                    this.push(descriptor2);
                    this.endMethod();
                    continue;
                }
                value = descriptor2.getValue();
            } else if (property instanceof LwIntroListModelProperty) {
                this.generateListModelProperty(property, class2variableIndex, aClass, value, variable);
                continue;
            }
            SupportCode.TextWithMnemonic textWithMnemonic = null;
            if (isTextWithMnemonicProperty) {
                textWithMnemonic = SupportCode.parseText((String)((String)value));
                value = textWithMnemonic.myText;
            }
            if ((propertyClass = property.getPropertyClassName()).equals(Color.class.getName()) && !(descriptor = (ColorDescriptor)value).isColorSet()) continue;
            if (propertyClass.equals(Font.class.getName())) {
                this.pushFontProperty(variable, (FontDescriptor)value, property.getReadMethodName(), property.getWriteMethodName());
                continue;
            }
            this.startMethodCall(variable, property.getWriteMethodName());
            if (propertyClass.equals(Dimension.class.getName())) {
                this.newDimension((Dimension)value);
            } else if (propertyClass.equals(Integer.class.getName())) {
                this.push((Integer)value);
            } else if (propertyClass.equals(Double.class.getName())) {
                this.push((Double)value);
            } else if (propertyClass.equals(Float.class.getName())) {
                this.push(((Float)value).floatValue());
            } else if (propertyClass.equals(Long.class.getName())) {
                this.push((Long)value);
            } else if (propertyClass.equals(Short.class.getName())) {
                this.push((Short)value);
            } else if (propertyClass.equals(Byte.class.getName())) {
                this.push((Byte)value);
            } else if (propertyClass.equals(Character.class.getName())) {
                this.push(((Character)value).charValue());
            } else if (propertyClass.equals(Boolean.class.getName())) {
                this.push((Boolean)value);
            } else if (propertyClass.equals(Rectangle.class.getName())) {
                this.newRectangle((Rectangle)value);
            } else if (propertyClass.equals(Insets.class.getName())) {
                this.newInsets((Insets)value);
            } else if (propertyClass.equals(String.class.getName())) {
                this.push((String)value);
            } else if (propertyClass.equals(Color.class.getName())) {
                this.pushColor((ColorDescriptor)value);
            } else if (propertyClass.equals(Icon.class.getName())) {
                this.pushIcon((IconDescriptor)value);
            } else if (property instanceof LwIntroEnumProperty) {
                this.pushVar(propertyClass.replace('$', '.') + "." + value.toString());
            } else {
                throw new RuntimeException("unexpected property class: " + propertyClass);
            }
            this.endMethod();
            if (!isTextWithMnemonicProperty || textWithMnemonic.myMnemonicIndex == -1) continue;
            if (this.isAssignableFrom(AbstractButton.class.getName(), componentClass, globalSearchScope)) {
                this.generateSetMnemonic(variable, textWithMnemonic, module, "setMnemonic", AbstractButton.class);
                continue;
            }
            if (!this.isAssignableFrom(JLabel.class.getName(), componentClass, globalSearchScope)) continue;
            this.generateSetMnemonic(variable, textWithMnemonic, module, "setDisplayedMnemonic", JLabel.class);
        }
        this.generateClientProperties(component, variable);
        if (!(component.getParent() instanceof LwRootContainer)) {
            String parentVariable = FormSourceCodeGenerator.getVariable((LwComponent)parent, component2TempVariable, class2variableIndex, aClass);
            String componentVar = variable;
            if (component instanceof LwNestedForm) {
                componentVar = variable + "." + "$$$getRootComponent$$$" + "()";
            }
            FormSourceCodeGenerator.getComponentLayoutGenerator(component.getParent()).generateComponentLayout(component, this, componentVar, parentVariable);
        }
        if (component instanceof LwContainer) {
            LwContainer container2 = (LwContainer)component;
            this.generateBorder(container2, variable);
            for (int i = 0; i < container2.getComponentCount(); ++i) {
                this.generateSetupCodeForComponent((LwComponent)container2.getComponent(i), component2TempVariable, class2variableIndex, id2component, module, aClass);
            }
        }
    }

    private void generateSetMnemonic(String variable, SupportCode.TextWithMnemonic textWithMnemonic, Module module, @NonNls String setMethodName, Class controlClass) {
        this.startMethodCall(variable, setMethodName);
        this.pushVar("'" + textWithMnemonic.getMnemonicChar() + "'");
        this.endMethod();
        if (this.haveSetDisplayedMnemonic(controlClass, module)) {
            this.startMethodCall(variable, "setDisplayedMnemonicIndex");
            this.push(textWithMnemonic.myMnemonicIndex);
            this.endMethod();
        }
    }

    private boolean haveSetDisplayedMnemonic(Class controlClass, Module module) {
        PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(controlClass.getName(), module.getModuleWithLibrariesScope());
        return aClass != null && aClass.findMethodsByName("setDisplayedMnemonicIndex", true).length > 0;
    }

    private void generateListModelProperty(LwIntrospectedProperty property, TObjectIntHashMap<String> class2variableIndex, PsiClass aClass, Object value, String variable) {
        String[] items;
        String valueClassName = property.getPropertyClassName().equals(ComboBoxModel.class.getName()) ? DefaultComboBoxModel.class.getName() : DefaultListModel.class.getName();
        String modelVarName = FormSourceCodeGenerator.generateUniqueVariableName(valueClassName, class2variableIndex, aClass);
        this.myBuffer.append("final ");
        this.myBuffer.append(valueClassName);
        this.myBuffer.append(" ");
        this.myBuffer.append(modelVarName);
        this.myBuffer.append("= new ").append(valueClassName).append("();");
        for (String item : items = (String[])value) {
            this.startMethodCall(modelVarName, "addElement");
            this.push(item);
            this.endMethod();
        }
        this.startMethodCall(variable, property.getWriteMethodName());
        this.pushVar(modelVarName);
        this.endMethod();
    }

    private void generateBorder(LwContainer container, String variable) {
        BorderType borderType = container.getBorderType();
        StringDescriptor borderTitle = container.getBorderTitle();
        Insets borderSize = container.getBorderSize();
        String borderFactoryMethodName = borderType.getBorderFactoryMethodName();
        boolean borderNone = borderType.equals((Object)BorderType.NONE);
        if (!borderNone || borderTitle != null) {
            this.startMethodCall(variable, "setBorder");
            this.startStaticMethodCall(BorderFactory.class, "createTitledBorder");
            if (!borderNone) {
                this.startStaticMethodCall(BorderFactory.class, borderFactoryMethodName);
                if (borderType.equals((Object)BorderType.LINE)) {
                    if (container.getBorderColor() == null) {
                        this.pushVar("java.awt.Color.black");
                    } else {
                        this.pushColor(container.getBorderColor());
                    }
                } else if (borderType.equals((Object)BorderType.EMPTY) && borderSize != null) {
                    this.push(borderSize.top);
                    this.push(borderSize.left);
                    this.push(borderSize.bottom);
                    this.push(borderSize.right);
                }
                this.endMethod();
            } else if (FormSourceCodeGenerator.isCustomBorder(container)) {
                this.push((String)null);
            }
            this.push(borderTitle);
            if (FormSourceCodeGenerator.isCustomBorder(container)) {
                this.push(container.getBorderTitleJustification(), ourTitleJustificationMap);
                this.push(container.getBorderTitlePosition(), ourTitlePositionMap);
                if (container.getBorderTitleFont() != null || container.getBorderTitleColor() != null) {
                    if (container.getBorderTitleFont() == null) {
                        this.push((String)null);
                    } else {
                        this.pushFont(variable, container.getBorderTitleFont(), "getFont");
                    }
                    if (container.getBorderTitleColor() != null) {
                        this.pushColor(container.getBorderTitleColor());
                    }
                }
            }
            this.endMethod();
            this.endMethod();
        }
    }

    private static boolean isCustomBorder(LwContainer container) {
        return container.getBorderTitleJustification() != 0 || container.getBorderTitlePosition() != 0 || container.getBorderTitleColor() != null || container.getBorderTitleFont() != null;
    }

    private void generateClientProperties(LwComponent component, String variable) throws CodeGenerationException {
        HashMap props = component.getDelegeeClientProperties();
        Iterator iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry e = o = iterator.next();
            this.startMethodCall(variable, "putClientProperty");
            this.push((String)e.getKey());
            Object value = e.getValue();
            if (value instanceof StringDescriptor) {
                this.push(((StringDescriptor)value).getValue());
            } else if (value instanceof Boolean) {
                if (((Boolean)value).booleanValue()) {
                    this.pushVar("Boolean.TRUE");
                } else {
                    this.pushVar("Boolean.FALSE");
                }
            } else {
                this.startConstructor(value.getClass().getName());
                if (value instanceof Integer) {
                    this.push((Integer)value);
                } else if (value instanceof Double) {
                    this.push((Double)value);
                } else {
                    throw new CodeGenerationException(component.getId(), "Unknown client property value type");
                }
                this.endConstructor();
            }
            this.endMethod();
        }
    }

    private static String getNestedFormClass(Module module, LwNestedForm nestedForm) throws CodeGenerationException {
        try {
            LwRootContainer container = new PsiNestedFormLoader(module).loadForm(nestedForm.getFormFileName());
            return container.getClassToBind();
        }
        catch (Exception e) {
            throw new CodeGenerationException(nestedForm.getId(), e.getMessage());
        }
    }

    private void generateComponentReferenceProperties(LwComponent component, HashMap<LwComponent, String> component2variable, TObjectIntHashMap<String> class2variableIndex, HashMap<String, LwComponent> id2component, PsiClass aClass) {
        LwIntrospectedProperty[] introspectedProperties;
        String variable = FormSourceCodeGenerator.getVariable(component, component2variable, class2variableIndex, aClass);
        for (LwIntrospectedProperty property : introspectedProperties = component.getAssignedIntrospectedProperties()) {
            LwComponent target;
            String componentId;
            if (!(property instanceof LwIntroComponentProperty) || (componentId = (String)component.getPropertyValue(property)) == null || componentId.length() <= 0 || (target = id2component.get(componentId)) == null) continue;
            String targetVariable = FormSourceCodeGenerator.getVariable(target, component2variable, class2variableIndex, aClass);
            this.startMethodCall(variable, property.getWriteMethodName());
            this.pushVar(targetVariable);
            this.endMethod();
        }
        if (component instanceof LwContainer) {
            LwContainer container = (LwContainer)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.generateComponentReferenceProperties((LwComponent)container.getComponent(i), component2variable, class2variableIndex, id2component, aClass);
            }
        }
    }

    private void generateButtonGroups(LwRootContainer rootContainer, HashMap<LwComponent, String> component2variable, TObjectIntHashMap<String> class2variableIndex, HashMap<String, LwComponent> id2component, PsiClass aClass) {
        IButtonGroup[] groups = rootContainer.getButtonGroups();
        boolean haveGroupDeclaration = false;
        for (IButtonGroup group : groups) {
            String[] ids;
            boolean haveGroupConstructor = false;
            for (String id : ids = group.getComponentIds()) {
                LwComponent target = id2component.get(id);
                if (target == null) continue;
                if (!haveGroupConstructor) {
                    if (group.isBound()) {
                        this.append(group.getName());
                    } else {
                        if (!haveGroupDeclaration) {
                            this.append("javax.swing.ButtonGroup buttonGroup;");
                            haveGroupDeclaration = true;
                        }
                        this.append("buttonGroup");
                    }
                    this.append("= new javax.swing.ButtonGroup();");
                    haveGroupConstructor = true;
                }
                String targetVariable = FormSourceCodeGenerator.getVariable(target, component2variable, class2variableIndex, aClass);
                this.startMethodCall(group.isBound() ? group.getName() : "buttonGroup", "add");
                this.pushVar(targetVariable);
                this.endMethod();
            }
        }
    }

    private static LayoutSourceGenerator getComponentLayoutGenerator(LwContainer container) {
        LayoutSourceGenerator generator = ourComponentLayoutCodeGenerators.get(container.getClass());
        if (generator != null) {
            return generator;
        }
        for (LwContainer parent = container; parent != null; parent = parent.getParent()) {
            String layoutManager = parent.getLayoutManager();
            if (layoutManager == null || layoutManager.length() <= 0 || (generator = ourContainerLayoutCodeGenerators.get(layoutManager)) == null) continue;
            return generator;
        }
        return GridLayoutSourceGenerator.INSTANCE;
    }

    void push(StringDescriptor descriptor) {
        if (descriptor == null) {
            this.push((String)null);
        } else if (descriptor.getValue() != null) {
            this.push(descriptor.getValue());
        } else {
            this.startMethodCall("java.util.ResourceBundle.getBundle(\"" + descriptor.getBundleName() + "\")", "getString");
            this.push(descriptor.getKey());
            this.endMethod();
        }
    }

    private void pushColor(ColorDescriptor descriptor) {
        if (descriptor.getColor() != null) {
            this.startConstructor(Color.class.getName());
            this.push(descriptor.getColor().getRGB());
            this.endConstructor();
        } else if (descriptor.getSwingColor() != null) {
            this.startStaticMethodCall(UIManager.class, "getColor");
            this.push(descriptor.getSwingColor());
            this.endMethod();
        } else if (descriptor.getSystemColor() != null) {
            this.pushVar("java.awt.SystemColor." + descriptor.getSystemColor());
        } else if (descriptor.getAWTColor() != null) {
            this.pushVar("java.awt.Color." + descriptor.getAWTColor());
        } else {
            throw new IllegalStateException("Unknown color type");
        }
    }

    private void pushFontProperty(String variable, FontDescriptor fontDescriptor, String getterName, String setterName) {
        this.myBuffer.append("java.awt.Font ").append(variable).append("Font = ");
        this.pushFont(variable, fontDescriptor, getterName);
        this.myBuffer.append("if (").append(variable).append("Font != null) ").append(variable).append(".").append(setterName).append("(").append(variable).append("Font);\n");
    }

    private void pushFont(String variable, FontDescriptor fontDescriptor, @NonNls String getterName) {
        if (fontDescriptor.getSwingFont() != null) {
            this.startStaticMethodCall(UIManager.class, "getFont");
            this.push(fontDescriptor.getSwingFont());
            this.endMethod();
        } else {
            if (this.myGetFontMethod == null) {
                this.myGetFontMethod = "$$$getFont$$$";
            }
            this.startMethodCall("this", this.myGetFontMethod);
            this.push(fontDescriptor.getFontName());
            this.push(fontDescriptor.getFontStyle(), ourFontStyleMap);
            this.push(fontDescriptor.getFontSize());
            this.pushVar(variable + "." + getterName + "()");
            this.endMethod();
        }
    }

    public void pushIcon(IconDescriptor iconDescriptor) {
        this.startConstructor(ImageIcon.class.getName());
        this.startMethodCall("getClass()", "getResource");
        this.push("/" + iconDescriptor.getIconPath());
        this.endMethod();
        this.endMethod();
    }

    private boolean isAssignableFrom(String className, String fromName, GlobalSearchScope scope) {
        PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(className, scope);
        PsiClass fromClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(fromName, scope);
        if (aClass == null || fromClass == null) {
            return false;
        }
        return InheritanceUtil.isInheritorOrSelf((PsiClass)fromClass, (PsiClass)aClass, (boolean)true);
    }

    private static String getVariable(LwComponent component, HashMap<LwComponent, String> component2variable, TObjectIntHashMap<String> class2variableIndex, PsiClass aClass) {
        if (component2variable.containsKey(component)) {
            return component2variable.get(component);
        }
        if (component.getBinding() != null) {
            return component.getBinding();
        }
        String className = component instanceof LwNestedForm ? "nestedForm" : component.getComponentClassName();
        String result = FormSourceCodeGenerator.generateUniqueVariableName(className, class2variableIndex, aClass);
        component2variable.put(component, result);
        return result;
    }

    private static String generateUniqueVariableName(@NonNls String className, TObjectIntHashMap<String> class2variableIndex, PsiClass aClass) {
        int newIndex;
        String result;
        int idx;
        String shortName = className.startsWith("javax.swing.J") ? className.substring("javax.swing.J".length()) : ((idx = className.lastIndexOf(46)) != -1 ? className.substring(idx + 1) : className);
        if (!class2variableIndex.containsKey((Object)className)) {
            class2variableIndex.put((Object)className, 0);
        }
        do {
            class2variableIndex.increment((Object)className);
            newIndex = class2variableIndex.get((Object)className);
        } while (aClass.findFieldByName(result = Character.toLowerCase(shortName.charAt(0)) + shortName.substring(1) + newIndex, true) != null);
        return result;
    }

    void newDimensionOrNull(Dimension dimension) {
        if (dimension.width == -1 && dimension.height == -1) {
            this.checkParameter();
            this.myBuffer.append("null");
        } else {
            this.newDimension(dimension);
        }
    }

    void newDimension(Dimension dimension) {
        this.startConstructor(Dimension.class.getName());
        this.push(dimension.width);
        this.push(dimension.height);
        this.endConstructor();
    }

    void newInsets(Insets insets) {
        this.startConstructor(Insets.class.getName());
        this.push(insets.top);
        this.push(insets.left);
        this.push(insets.bottom);
        this.push(insets.right);
        this.endConstructor();
    }

    private void newRectangle(Rectangle rectangle) {
        this.startConstructor(Rectangle.class.getName());
        this.push(rectangle.x);
        this.push(rectangle.y);
        this.push(rectangle.width);
        this.push(rectangle.height);
        this.endConstructor();
    }

    void startMethodCall(@NonNls String variable, @NonNls String methodName) {
        this.checkParameter();
        this.append(variable);
        this.myBuffer.append('.');
        this.myBuffer.append(methodName);
        this.myBuffer.append('(');
        this.myIsFirstParameterStack.push(Boolean.TRUE);
    }

    private void startStaticMethodCall(Class aClass, @NonNls String methodName) {
        this.checkParameter();
        this.myBuffer.append(aClass.getName());
        this.myBuffer.append('.');
        this.myBuffer.append(methodName);
        this.myBuffer.append('(');
        this.myIsFirstParameterStack.push(Boolean.TRUE);
    }

    void endMethod() {
        this.myBuffer.append(')');
        this.myIsFirstParameterStack.pop();
        if (this.myIsFirstParameterStack.empty()) {
            this.myBuffer.append(";\n");
        }
    }

    void startConstructor(String className) {
        this.checkParameter();
        this.myBuffer.append("new ");
        this.myBuffer.append(className);
        this.myBuffer.append('(');
        this.myIsFirstParameterStack.push(Boolean.TRUE);
    }

    void endConstructor() {
        this.endMethod();
    }

    void push(byte value) {
        this.checkParameter();
        this.append(value);
    }

    void append(byte value) {
        this.myBuffer.append("(byte) ");
        this.myBuffer.append(value);
    }

    void push(short value) {
        this.checkParameter();
        this.append(value);
    }

    void append(short value) {
        this.myBuffer.append("(short) ");
        this.myBuffer.append(value);
    }

    void push(int value) {
        this.checkParameter();
        this.append(value);
    }

    void append(int value) {
        this.myBuffer.append(value);
    }

    void push(int value, TIntObjectHashMap map) {
        String stringRepresentation = (String)map.get(value);
        if (stringRepresentation != null) {
            this.checkParameter();
            this.myBuffer.append(stringRepresentation);
        } else {
            this.push(value);
        }
    }

    private void push(double value) {
        this.checkParameter();
        this.append(value);
    }

    public void append(double value) {
        this.myBuffer.append(value);
    }

    private void push(float value) {
        this.checkParameter();
        this.append(value);
    }

    public void append(float value) {
        this.myBuffer.append(value).append("f");
    }

    private void push(long value) {
        this.checkParameter();
        this.append(value);
    }

    public void append(long value) {
        this.myBuffer.append(value).append("L");
    }

    private void push(char value) {
        this.checkParameter();
        this.append(value);
    }

    public void append(char value) {
        this.myBuffer.append("'").append(value).append("'");
    }

    void push(boolean value) {
        this.checkParameter();
        this.myBuffer.append(value);
    }

    void push(String value) {
        this.checkParameter();
        if (value == null) {
            this.myBuffer.append("null");
        } else {
            this.myBuffer.append('\"');
            this.myBuffer.append(StringUtil.escapeStringCharacters((String)value));
            this.myBuffer.append('\"');
        }
    }

    void pushVar(@NonNls String variable) {
        this.checkParameter();
        this.append(variable);
    }

    void append(@NonNls String text) {
        this.myBuffer.append(text);
    }

    void checkParameter() {
        if (!this.myIsFirstParameterStack.empty()) {
            Boolean b = this.myIsFirstParameterStack.pop();
            if (b.equals(Boolean.FALSE)) {
                this.myBuffer.append(',');
            }
            this.myIsFirstParameterStack.push(Boolean.FALSE);
        }
    }

    static {
        ourComponentLayoutCodeGenerators.put(LwSplitPane.class, new SplitPaneLayoutSourceGenerator());
        ourComponentLayoutCodeGenerators.put(LwTabbedPane.class, new TabbedPaneLayoutSourceGenerator());
        ourComponentLayoutCodeGenerators.put(LwScrollPane.class, new ScrollPaneLayoutSourceGenerator());
        ourComponentLayoutCodeGenerators.put(LwToolBar.class, new ToolBarLayoutSourceGenerator());
        ourFontStyleMap.put(0, (Object)"java.awt.Font.PLAIN");
        ourFontStyleMap.put(1, (Object)"java.awt.Font.BOLD");
        ourFontStyleMap.put(2, (Object)"java.awt.Font.ITALIC");
        ourFontStyleMap.put(3, (Object)"java.awt.Font.BOLD | java.awt.Font.ITALIC");
        ourTitlePositionMap.put(0, (Object)"javax.swing.border.TitledBorder.DEFAULT_POSITION");
        ourTitlePositionMap.put(1, (Object)"javax.swing.border.TitledBorder.ABOVE_TOP");
        ourTitlePositionMap.put(2, (Object)"javax.swing.border.TitledBorder.TOP");
        ourTitlePositionMap.put(3, (Object)"javax.swing.border.TitledBorder.BELOW_TOP");
        ourTitlePositionMap.put(4, (Object)"javax.swing.border.TitledBorder.ABOVE_BOTTOM");
        ourTitlePositionMap.put(5, (Object)"javax.swing.border.TitledBorder.BOTTOM");
        ourTitlePositionMap.put(6, (Object)"javax.swing.border.TitledBorder.BELOW_BOTTOM");
        ourTitleJustificationMap.put(0, (Object)"javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION");
        ourTitleJustificationMap.put(1, (Object)"javax.swing.border.TitledBorder.LEFT");
        ourTitleJustificationMap.put(2, (Object)"javax.swing.border.TitledBorder.CENTER");
        ourTitleJustificationMap.put(3, (Object)"javax.swing.border.TitledBorder.RIGHT");
        ourTitleJustificationMap.put(4, (Object)"javax.swing.border.TitledBorder.LEADING");
        ourTitleJustificationMap.put(5, (Object)"javax.swing.border.TitledBorder.TRAILING");
    }
}

