/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.database.view.ui.DbRefactoringDialogHelper;
import com.intellij.database.view.ui.DbRefactoringHelper;
import com.intellij.database.view.ui.DbTableDialog;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseObjectRefactoring
extends BaseRefactoringAction {
    public static final DataKey<Consumer<AbstractDbRefactoringDialog>> INTERCEPTOR = DataKey.create((String)"DatabaseObjectRefactoring.INTERCEPTOR");

    @Nullable
    public static DasObject getDasObject(@Nullable PsiElement element) {
        if (element instanceof DasObject) {
            return (DasObject)element;
        }
        DasObject res = DatabaseObjectRefactoring.getDasObject(element == null ? null : element.getReference());
        if (res == null) {
            res = (DasObject)PsiTreeUtil.getParentOfType((PsiElement)element, PsiObject.class, (boolean)false);
        }
        return res;
    }

    @Nullable
    public static DasObject getDasObject(@Nullable PsiReference ref) {
        return ref == null ? null : (DasObject)ObjectUtils.tryCast((Object)ref.resolve(), DasObject.class);
    }

    @Nullable
    public static DasObject getDasObject(@Nullable Editor editor, @Nullable PsiFile file) {
        DasObject res = null;
        if (file != null && editor != null && (res = DatabaseObjectRefactoring.getDasObject(file.findReferenceAt(editor.getCaretModel().getOffset()))) == null) {
            res = DatabaseObjectRefactoring.getDasObject(file.findElementAt(editor.getCaretModel().getOffset()));
        }
        return res;
    }

    @Nullable
    public static PsiElement getPlace(@Nullable Editor editor, @Nullable PsiFile file) {
        return file != null && editor != null ? file.findElementAt(editor.getCaretModel().getOffset()) : null;
    }

    @Nullable
    public static DasObject getDasObject(@NotNull DataContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/actions/DatabaseObjectRefactoring", "getDasObject"));
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        DasObject res = DatabaseObjectRefactoring.getDasObject(editor, file);
        if (res == null && element != null) {
            res = DatabaseObjectRefactoring.getDasObject(element);
        }
        return res;
    }

    @NotNull
    public static JBIterable<DasObject> getDasObjects(@NotNull DataContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/actions/DatabaseObjectRefactoring", "getDasObjects"));
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        JBIterable res = JBIterable.empty();
        if (editor != null && file != null) {
            res = JBIterable.from((Iterable)editor.getCaretModel().getAllCarets()).transform(caret -> DatabaseObjectRefactoring.getDasObject(file.findReferenceAt(caret.getOffset()))).filter(Condition.NOT_NULL);
        }
        JBIterable jBIterable = res.isEmpty() ? JBIterable.of((Object)DatabaseObjectRefactoring.getDasObject(context)) : res;
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseObjectRefactoring", "getDasObjects"));
        }
        return jBIterable;
    }

    public boolean isAvailableInEditorOnly() {
        return false;
    }

    public boolean isEnabledOnElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/actions/DatabaseObjectRefactoring", "isEnabledOnElement"));
        }
        DasObject object = DatabaseObjectRefactoring.getDasObject(element);
        DatabaseEditorContext context = object == null ? null : DbRefactoringHelper.createContext(object, element);
        return context != null && DbRefactoringHelper.isTableOrEditableTableChild(object, context) && !DataImporter.isBusy(object);
    }

    protected boolean isAvailableForLanguage(Language language) {
        return language instanceof SqlLanguage;
    }

    public boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/actions/DatabaseObjectRefactoring", "isEnabledOnElements"));
        }
        if (elements.length != 1) {
            return false;
        }
        return this.isEnabledOnElement(elements[0]);
    }

    private static void showDialog(@Nullable PsiElement place, @Nullable DasObject object, @Nullable Consumer<AbstractDbRefactoringDialog> interceptor) {
        DatabaseEditorContext context;
        DatabaseEditorContext databaseEditorContext = context = object == null ? null : DbRefactoringHelper.createContext(object, place);
        if (context == null || !DbRefactoringHelper.isTableOrEditableTableChild(object, context)) {
            return;
        }
        DbTableDialog dialog = new DbTableDialog(context);
        AbstractDbRefactoringDialog.ResultProcessor proc = DbRefactoringHelper.getResultProcessor(object, dialog, place);
        dialog.setResultProcessor(proc);
        dialog.configureForModification(object, DbRefactoringHelper.isForceCreate(object));
        DbRefactoringDialogHelper.bootstrap(dialog, (Computable<DeObject>)((Computable)() -> dialog.export(object, true)));
        if (interceptor != null) {
            interceptor.consume((Object)dialog);
        } else {
            dialog.finishAndShow();
        }
    }

    @Nullable
    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/actions/DatabaseObjectRefactoring", "getHandler"));
        }
        return new RefactoringActionHandler(){

            public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/DatabaseObjectRefactoring$1", "invoke"));
                }
                DatabaseObjectRefactoring.showDialog(DatabaseObjectRefactoring.getPlace(editor, file), DatabaseObjectRefactoring.getDasObject(editor, file), (Consumer<AbstractDbRefactoringDialog>)((Consumer)INTERCEPTOR.getData(dataContext)));
            }

            public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/DatabaseObjectRefactoring$1", "invoke"));
                }
                if (elements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/actions/DatabaseObjectRefactoring$1", "invoke"));
                }
                if (elements.length == 1) {
                    DatabaseObjectRefactoring.showDialog(elements[0], DatabaseObjectRefactoring.getDasObject(elements[0]), (Consumer<AbstractDbRefactoringDialog>)((Consumer)INTERCEPTOR.getData(dataContext)));
                }
            }
        };
    }

    @NotNull
    private static String getDesc(@NotNull ObjectKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/actions/DatabaseObjectRefactoring", "getDesc"));
        }
        String string = "Modify " + DatabaseObjectRefactoring.getKindTitle(kind) + "...";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseObjectRefactoring", "getDesc"));
        }
        return string;
    }

    @NotNull
    public static String getKindTitle(@NotNull ObjectKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/actions/DatabaseObjectRefactoring", "getKindTitle"));
        }
        String string = StringUtil.capitalizeWords((String)StringUtil.toLowerCase((String)kind.toString().replaceAll("[-_]", " ")), (boolean)true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseObjectRefactoring", "getKindTitle"));
        }
        return string;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (presentation.isEnabled()) {
            DasObject object = DatabaseObjectRefactoring.getDasObject(e.getDataContext());
            if (object != null) {
                presentation.setText(DatabaseObjectRefactoring.getDesc(object.getKind()));
                if (e.getPlace() != "unknown" && object instanceof PsiElement) {
                    presentation.setIcon(((PsiElement)object).getIcon(0));
                }
            }
        } else {
            presentation.setVisible(false);
        }
    }
}

