/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.GenerateScriptAction;
import com.intellij.database.actions.GenerateScriptDialog;
import com.intellij.database.dataSource.DataSourceManagerEx;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicScriptable;
import com.intellij.database.psi.DbElement;
import com.intellij.database.scripting.ScriptingFactory;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u00012B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020'H\u0016J\b\u0010)\u001a\u00020'H\u0002J\b\u0010*\u001a\u00020'H\u0002J\b\u0010+\u001a\u00020'H\u0002J\n\u0010,\u001a\u0004\u0018\u00010-H\u0002J\u0006\u0010.\u001a\u00020'J\u0006\u0010/\u001a\u00020'J\u000e\u00100\u001a\u00020'2\u0006\u00101\u001a\u00020\u0012R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/database/actions/GenerateScriptDialog;", "Lcom/intellij/openapi/Disposable;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/database/psi/DbElement;", "(Lcom/intellij/database/model/basic/BasicModel;Lcom/intellij/openapi/project/Project;Lcom/intellij/database/psi/DbElement;)V", "dialog", "Lcom/intellij/openapi/ui/DialogBuilder;", "done", "", "editorFactory", "Lcom/intellij/openapi/editor/EditorFactory;", "getElement", "()Lcom/intellij/database/psi/DbElement;", "generatedText", "", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "scriptingFactory", "Lcom/intellij/database/scripting/ScriptingFactory;", "selection", "", "Lcom/intellij/database/model/basic/BasicNode;", "getSelection", "()Ljava/util/List;", "toolbar1", "Ljavax/swing/JPanel;", "toolbar2", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "viewer", "Lcom/intellij/ui/EditorTextField;", "viewerComponent", "Ljavax/swing/JComponent;", "close", "", "dispose", "doCopyToClipboard", "doOpenInConsole", "doSaveToFile", "findDsForModel", "Lcom/intellij/database/dataSource/LocalDataSource;", "regenerate", "show", "showTheScript", "scriptText", "FinalAction", "database-impl"})
public final class GenerateScriptDialog
implements Disposable {
    @NotNull
    private final List<BasicNode> selection;
    private final ScriptingFactory scriptingFactory;
    private final EditorFactory editorFactory;
    private final JComponent viewerComponent;
    private final JPanel toolbar1;
    private final ActionToolbar toolbar2;
    private EditorTextField viewer;
    private DialogBuilder dialog;
    private String generatedText;
    private boolean done;
    @NotNull
    private final BasicModel model;
    @NotNull
    private final Project project;
    @NotNull
    private final DbElement element;

    @NotNull
    public final List<BasicNode> getSelection() {
        return this.selection;
    }

    public final void show() {
        JPanel toolBarStripe = new JPanel(new BorderLayout(), false);
        toolBarStripe.add((Component)this.toolbar1, "West");
        toolBarStripe.add((Component)this.toolbar2.getComponent(), "East");
        DialogBuilder dia = new DialogBuilder();
        dia.removeAllActions();
        dia.setTitle("SQL script generation");
        dia.setNorthPanel((JComponent)toolBarStripe);
        dia.setCenterPanel(this.viewerComponent);
        EditorTextField editorTextField = this.viewer;
        if (editorTextField == null) {
            Intrinsics.throwNpe();
        }
        dia.setPreferredFocusComponent(editorTextField.getComponent());
        dia.addDisposable((Disposable)this);
        dia.setDimensionServiceKey(GenerateScriptAction.class.getSimpleName());
        dia.showNotModal();
        this.regenerate();
        this.dialog = dia;
    }

    public final void regenerate() {
        JBIterable sel = JBIterable.from((Iterable)this.selection);
        JBIterable explicitDatabases = sel.filter(BasicDatabase.class);
        JBIterable explicitSchemas = sel.filter(BasicSchema.class);
        JBIterable explicitScriptableObjects = sel.filter(BasicScriptable.class);
        List schemasToGenerate2 = explicitDatabases.flatten((Function)regenerate.schemasToGenerate.1.INSTANCE).append((Iterable)explicitSchemas).toList();
        List objectsToGenerate2 = explicitScriptableObjects.filter((Condition)new Condition<BasicScriptable>(schemasToGenerate2){
            final /* synthetic */ List $schemasToGenerate;

            public final boolean value(BasicScriptable it) {
                return this.$schemasToGenerate.contains(ModelFun.getSchema(it)) ^ true;
            }
            {
                this.$schemasToGenerate = list;
            }
        }).toList();
        ScriptingService service = ScriptingFactory.DefaultImpls.createScriptingService$default(this.scriptingFactory, this.model, null, 2, null);
        Collection collection = schemasToGenerate2;
        if (!collection.isEmpty()) {
            List list = schemasToGenerate2;
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"schemasToGenerate");
            service.makeScript(ScriptingTask.CREATE_COMPLETE, list);
        }
        if (!(collection = (Collection)objectsToGenerate2).isEmpty()) {
            List list = objectsToGenerate2;
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"objectsToGenerate");
            ScriptingService.DefaultImpls.makeScript$default(service, ScriptingTask.CREATE_COMPLETE, list, false, 4, null);
        }
        String string = this.generatedText = service.getScriptText();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this.showTheScript(string);
    }

    public final void showTheScript(@NotNull String scriptText) {
        Intrinsics.checkParameterIsNotNull((Object)scriptText, (String)"scriptText");
        ApplicationManager.getApplication().runWriteAction(new Runnable(this, scriptText){
            final /* synthetic */ GenerateScriptDialog this$0;
            final /* synthetic */ String $scriptText;

            public final void run() {
                EditorTextField editorTextField = GenerateScriptDialog.access$getViewer$p(this.this$0);
                if (editorTextField == null) {
                    Intrinsics.throwNpe();
                }
                editorTextField.setText(this.$scriptText);
            }
            {
                this.this$0 = generateScriptDialog;
                this.$scriptText = string;
            }
        });
    }

    private final void doCopyToClipboard() {
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(this.generatedText));
        this.done = true;
    }

    private final void doSaveToFile() {
    }

    private final void doOpenInConsole() {
        String string = this.generatedText;
        if (string == null) {
            return;
        }
        String text = string;
        LocalDataSource localDataSource = this.findDsForModel();
        if (localDataSource == null) {
            return;
        }
        LocalDataSource ds = localDataSource;
        VirtualFile virtualFile = DatabaseEditorHelper.createNewConsoleVirtualFile((DatabaseSystem)ds);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
        if (document == null) {
            return;
        }
        Document document2 = document;
        WriteCommandAction.runWriteCommandAction((Project)this.project, (Runnable)new Runnable(document2, text){
            final /* synthetic */ Document $document;
            final /* synthetic */ String $text;

            public final void run() {
                this.$document.setText((CharSequence)this.$text);
            }
            {
                this.$document = document;
                this.$text = string;
            }
        });
        DatabaseEditorHelper.openConsoleForFile(this.project, null, virtualFile2);
        this.done = true;
    }

    private final LocalDataSource findDsForModel() {
        Object v0;
        block1: {
            Iterable $receiver$iv = DataSourceManagerEx.getInstanceEx(this.project).getDataSources();
            for (Object element$iv : $receiver$iv) {
                LocalDataSource ds = (LocalDataSource)element$iv;
                if (!(ds instanceof LocalDataSource && Intrinsics.areEqual((Object)ds.getModel(), (Object)this.model))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final void close() {
        DialogBuilder dia;
        EditorTextField v = this.viewer;
        if (v != null) {
            this.viewer = null;
        }
        if ((dia = this.dialog) != null) {
            dia.getWindow().setVisible(false);
            dia.dispose();
            this.dialog = null;
        }
    }

    public void dispose() {
        this.close();
    }

    @NotNull
    public final BasicModel getModel() {
        return this.model;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DbElement getElement() {
        return this.element;
    }

    public GenerateScriptDialog(@NotNull BasicModel model, @NotNull Project project, @NotNull DbElement element) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.model = model;
        this.project = project;
        this.element = element;
        this.selection = new ArrayList();
        Object object = ServiceManager.getService(ScriptingFactory.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026ptingFactory::class.java)");
        this.scriptingFactory = (ScriptingFactory)object;
        ActionManager actionManager = ActionManager.getInstance();
        EditorFactory editorFactory = EditorFactory.getInstance();
        if (editorFactory == null) {
            Intrinsics.throwNpe();
        }
        this.editorFactory = editorFactory;
        DasNamespace searchPathObject = DbImplUtil.getSearchPathObject(this.element);
        EditorTextField editorTextField = this.viewer = DatabaseDialogsHelper.createLanguageEditorArea(this.project, this.element.getDataSource(), CollectionsKt.listOf((Object)searchPathObject), "");
        if (editorTextField == null) {
            Intrinsics.throwNpe();
        }
        editorTextField.addSettingsProvider((EditorSettingsProvider)1.INSTANCE);
        EditorTextField editorTextField2 = this.viewer;
        if (editorTextField2 == null) {
            Intrinsics.throwNpe();
        }
        JComponent jComponent = editorTextField2.getComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"viewer!!.component");
        this.viewerComponent = jComponent;
        FinalAction doCopyToClipboardAction2 = new FinalAction(this, "Copy to Clipboard", null, AllIcons.Actions.Copy, (Function0)new Function0<Unit>(this){
            final /* synthetic */ GenerateScriptDialog this$0;

            public final void invoke() {
                GenerateScriptDialog.access$doCopyToClipboard(this.this$0);
            }
            {
                this.this$0 = generateScriptDialog;
                super(0);
            }
        }, 2, null);
        FinalAction doSaveToFileAction2 = new FinalAction(this, "Save into a File", null, AllIcons.Actions.Menu_saveall, (Function0)new Function0<Unit>(this){
            final /* synthetic */ GenerateScriptDialog this$0;

            public final void invoke() {
                GenerateScriptDialog.access$doSaveToFile(this.this$0);
            }
            {
                this.this$0 = generateScriptDialog;
                super(0);
            }
        }, 2, null);
        FinalAction doOpenInConsoleAction2 = new FinalAction(this, "Open in Console", null, DatabaseIcons.ConsoleRun, (Function0)new Function0<Unit>(this){
            final /* synthetic */ GenerateScriptDialog this$0;

            public final void invoke() {
                GenerateScriptDialog.access$doOpenInConsole(this.this$0);
            }
            {
                this.this$0 = generateScriptDialog;
                super(0);
            }
        }, 2, null);
        DefaultActionGroup actions2 = new DefaultActionGroup(new AnAction[]{doCopyToClipboardAction2, doSaveToFileAction2, doOpenInConsoleAction2});
        this.toolbar1 = new JPanel();
        ActionToolbar actionToolbar = actionManager.createActionToolbar("EditorToolbar", (ActionGroup)actions2, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)actionToolbar, (String)"actionManager.createActi\u2026_TOOLBAR, actions2, true)");
        this.toolbar2 = actionToolbar;
        this.viewerComponent.setMinimumSize(new Dimension(360, 360));
        this.viewerComponent.setPreferredSize(new Dimension(600, 600));
    }

    public static final /* synthetic */ void access$setDone$p(GenerateScriptDialog $this, boolean bl) {
        $this.done = bl;
    }

    @Nullable
    public static final /* synthetic */ EditorTextField access$getViewer$p(GenerateScriptDialog $this) {
        return $this.viewer;
    }

    public static final /* synthetic */ void access$setViewer$p(GenerateScriptDialog $this, @Nullable EditorTextField editorTextField) {
        $this.viewer = editorTextField;
    }

    public static final /* synthetic */ void access$doCopyToClipboard(GenerateScriptDialog $this) {
        $this.doCopyToClipboard();
    }

    public static final /* synthetic */ void access$doSaveToFile(GenerateScriptDialog $this) {
        $this.doSaveToFile();
    }

    public static final /* synthetic */ void access$doOpenInConsole(GenerateScriptDialog $this) {
        $this.doOpenInConsole();
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B5\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/actions/GenerateScriptDialog$FinalAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "text", "", "description", "icon", "Ljavax/swing/Icon;", "action", "Lkotlin/Function0;", "", "(Lcom/intellij/database/actions/GenerateScriptDialog;Ljava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;Lkotlin/jvm/functions/Function0;)V", "getAction", "()Lkotlin/jvm/functions/Function0;", "actionPerformed", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "database-impl"})
    public final class FinalAction
    extends AnAction {
        @NotNull
        private final Function0<Unit> action;
        final /* synthetic */ GenerateScriptDialog this$0;

        @NotNull
        public final Function0<Unit> getAction() {
            return this.action;
        }

        public void actionPerformed(@Nullable AnActionEvent e) {
            this.action.invoke();
            if (this.this$0.done) {
                this.this$0.close();
            }
        }

        public FinalAction(@NotNull GenerateScriptDialog $outer, @Nullable String text, @Nullable String description, @NotNull Icon icon, Function0<Unit> action) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull(action, (String)"action");
            super(text, description, icon);
            this.this$0 = $outer;
            this.action = action;
        }

        public /* synthetic */ FinalAction(GenerateScriptDialog generateScriptDialog, String string, String string2, Icon icon, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                icon = null;
            }
            this(generateScriptDialog, string, string2, icon, (Function0<Unit>)function0);
        }
    }
}

