/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.dump.mysql.MysqldumpConfiguration;
import com.intellij.database.cli.dump.pg.PgDumpConfiguration;
import com.intellij.database.cli.restore.mysql.MysqlConfiguration;
import com.intellij.database.cli.restore.pg.PgRestoreConfiguration;
import com.intellij.database.cli.restore.pg.PsqlConfiguration;
import com.intellij.database.psi.DbElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CliConfigurationPack {
    public static final CliConfigurationPack MYSQL_DUMP = new CliConfigurationPack("MYSQL_DUMP_CLI_PACK", MysqldumpConfiguration.INSTANCE);
    public static final CliConfigurationPack PG_DUMP = new CliConfigurationPack("PG_DUMP_CLI_PACK", PgDumpConfiguration.INSTANCE);
    public static final CliConfigurationPack MYSQL_RESTORE = new CliConfigurationPack("MYSQL_RESTORE_CLI_PACK", MysqlConfiguration.INSTANCE);
    public static final CliConfigurationPack PG_RESTORE = new CliConfigurationPack("PG_RESTORE_CLI_PACK", PgRestoreConfiguration.INSTANCE, PsqlConfiguration.INSTANCE);
    private final Collection<CliConfiguration> myConfigurations;
    private final String myKey;

    public CliConfigurationPack(@NotNull String key, CliConfiguration ... configurations) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/cli/CliConfigurationPack", "<init>"));
        }
        if (configurations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurations", "com/intellij/database/cli/CliConfigurationPack", "<init>"));
        }
        this.myConfigurations = ContainerUtil.list((Object[])configurations);
        this.myKey = key;
    }

    @NotNull
    public Collection<CliConfiguration> getConfigurations() {
        Collection<CliConfiguration> collection = this.myConfigurations;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationPack", "getConfigurations"));
        }
        return collection;
    }

    @NotNull
    public String getKey() {
        String string = this.myKey;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationPack", "getKey"));
        }
        return string;
    }

    @NotNull
    public CliConfiguration first() {
        CliConfiguration cliConfiguration = (CliConfiguration)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(this.myConfigurations));
        if (cliConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationPack", "first"));
        }
        return cliConfiguration;
    }

    @NotNull
    public CliConfigurationPack filtered(@NotNull Collection<DbElement> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/CliConfigurationPack", "filtered"));
        }
        List filtered = ContainerUtil.filter(this.myConfigurations, c -> {
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/CliConfigurationPack", "lambda$filtered$0"));
            }
            return c.getObjectsPreparer().prepare(elements).isValid();
        });
        CliConfigurationPack cliConfigurationPack = new CliConfigurationPack(this.myKey, (CliConfiguration[])ContainerUtil.toArray((Collection)filtered, CliConfiguration[]::new));
        if (cliConfigurationPack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationPack", "filtered"));
        }
        return cliConfigurationPack;
    }

    public boolean isEmpty() {
        return this.myConfigurations.size() == 0;
    }

    public boolean isSingleConfiguration() {
        return this.myConfigurations.size() == 1;
    }
}

