/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv.ui.preview;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.preview.CsvFormatPreview;
import com.intellij.database.csv.ui.preview.TextView;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.extractors.FormatBasedExtractor;
import com.intellij.database.util.CharOut;
import com.intellij.openapi.Disposable;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TextCsvFormatPreview
implements CsvFormatPreview {
    private final DataGrid myGrid;
    private final TextView myTextView;
    private final boolean mySelectionOnly;

    public TextCsvFormatPreview(@NotNull DataGrid grid, @NotNull Disposable parent) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/csv/ui/preview/TextCsvFormatPreview", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/csv/ui/preview/TextCsvFormatPreview", "<init>"));
        }
        this(grid, new TextView(parent), true);
    }

    public TextCsvFormatPreview(@NotNull DataGrid grid, @NotNull TextView textView, boolean selectionOnly) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/csv/ui/preview/TextCsvFormatPreview", "<init>"));
        }
        if (textView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textView", "com/intellij/database/csv/ui/preview/TextCsvFormatPreview", "<init>"));
        }
        this.myGrid = grid;
        this.myTextView = textView;
        this.mySelectionOnly = selectionOnly;
    }

    @Override
    public void setFormat(@NotNull CsvFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/csv/ui/preview/TextCsvFormatPreview", "setFormat"));
        }
        FormatBasedExtractor extractor = new FormatBasedExtractor(format, this.myGrid.getObjectFormatter());
        String text = DataGridUtil.extractValues(this.myGrid, extractor, CharOut.Util.newSink(), this.mySelectionOnly, false).toString();
        this.myTextView.setText(text);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myTextView.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/preview/TextCsvFormatPreview", "getComponent"));
        }
        return jComponent;
    }
}

