/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage.zipfs;

import com.intellij.database.dataSource.srcStorage.zipfs.ZipFileAttributeView;
import com.intellij.database.dataSource.srcStorage.zipfs.ZipFileAttributes;
import com.intellij.database.dataSource.srcStorage.zipfs.ZipFileSystem;
import com.intellij.database.dataSource.srcStorage.zipfs.ZipPath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.zip.ZipError;

public class ZipFileSystemProvider
extends FileSystemProvider {
    private final Map<Path, ZipFileSystem> filesystems = new HashMap<Path, ZipFileSystem>();

    @Override
    public String getScheme() {
        return "jar";
    }

    protected Path uriToPath(URI uri) {
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase(this.getScheme())) {
            throw new IllegalArgumentException("URI scheme is not '" + this.getScheme() + "'");
        }
        try {
            String spec = uri.getRawSchemeSpecificPart();
            int sep = spec.indexOf("!/");
            if (sep != -1) {
                spec = spec.substring(0, sep);
            }
            return Paths.get(new URI(spec)).toAbsolutePath();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private boolean ensureFile(Path path) {
        try {
            BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            if (!attrs.isRegularFile()) {
                throw new UnsupportedOperationException();
            }
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        Path path = this.uriToPath(uri);
        Map<Path, ZipFileSystem> map = this.filesystems;
        synchronized (map) {
            Path realPath = null;
            if (this.ensureFile(path) && this.filesystems.containsKey(realPath = path.toRealPath(new LinkOption[0]))) {
                throw new FileSystemAlreadyExistsException();
            }
            ZipFileSystem zipfs = null;
            try {
                zipfs = new ZipFileSystem(this, path, env);
            }
            catch (ZipError ze) {
                String pname = path.toString();
                if (pname.endsWith(".zip") || pname.endsWith(".jar")) {
                    throw ze;
                }
                throw new UnsupportedOperationException();
            }
            this.filesystems.put(realPath, zipfs);
            return zipfs;
        }
    }

    @Override
    public FileSystem newFileSystem(Path path, Map<String, ?> env) throws IOException {
        if (path.getFileSystem() != FileSystems.getDefault()) {
            throw new UnsupportedOperationException();
        }
        this.ensureFile(path);
        try {
            return new ZipFileSystem(this, path, env);
        }
        catch (ZipError ze) {
            String pname = path.toString();
            if (pname.endsWith(".zip") || pname.endsWith(".jar")) {
                throw ze;
            }
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public Path getPath(URI uri) {
        String spec = uri.getSchemeSpecificPart();
        int sep = spec.indexOf("!/");
        if (sep == -1) {
            throw new IllegalArgumentException("URI: " + uri + " does not contain path info ex. jar:file:/c:/foo.zip!/BAR");
        }
        return this.getFileSystem(uri).getPath(spec.substring(sep + 1), new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem getFileSystem(URI uri) {
        Map<Path, ZipFileSystem> map = this.filesystems;
        synchronized (map) {
            ZipFileSystem zipfs = null;
            try {
                zipfs = this.filesystems.get(this.uriToPath(uri).toRealPath(new LinkOption[0]));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (zipfs == null) {
                throw new FileSystemNotFoundException();
            }
            return zipfs;
        }
    }

    static final ZipPath toZipPath(Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof ZipPath)) {
            throw new ProviderMismatchException();
        }
        return (ZipPath)path;
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        ZipFileSystemProvider.toZipPath(path).checkAccess(modes);
    }

    @Override
    public void copy(Path src, Path target, CopyOption ... options) throws IOException {
        ZipFileSystemProvider.toZipPath(src).copy(ZipFileSystemProvider.toZipPath(target), options);
    }

    @Override
    public void createDirectory(Path path, FileAttribute<?> ... attrs) throws IOException {
        ZipFileSystemProvider.toZipPath(path).createDirectory(attrs);
    }

    @Override
    public final void delete(Path path) throws IOException {
        ZipFileSystemProvider.toZipPath(path).delete();
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        return ZipFileAttributeView.get(ZipFileSystemProvider.toZipPath(path), type);
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return ZipFileSystemProvider.toZipPath(path).getFileStore();
    }

    @Override
    public boolean isHidden(Path path) {
        return ZipFileSystemProvider.toZipPath(path).isHidden();
    }

    @Override
    public boolean isSameFile(Path path, Path other) throws IOException {
        return ZipFileSystemProvider.toZipPath(path).isSameFile(other);
    }

    @Override
    public void move(Path src, Path target, CopyOption ... options) throws IOException {
        ZipFileSystemProvider.toZipPath(src).move(ZipFileSystemProvider.toZipPath(target), options);
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService exec, FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return ZipFileSystemProvider.toZipPath(path).newByteChannel(options, attrs);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return ZipFileSystemProvider.toZipPath(path).newDirectoryStream(filter);
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return ZipFileSystemProvider.toZipPath(path).newFileChannel(options, attrs);
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        return ZipFileSystemProvider.toZipPath(path).newInputStream(options);
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        return ZipFileSystemProvider.toZipPath(path).newOutputStream(options);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (type == BasicFileAttributes.class || type == ZipFileAttributes.class) {
            return (A)ZipFileSystemProvider.toZipPath(path).getAttributes();
        }
        return null;
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attribute, LinkOption ... options) throws IOException {
        return ZipFileSystemProvider.toZipPath(path).readAttributes(attribute, options);
    }

    @Override
    public Path readSymbolicLink(Path link) throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        ZipFileSystemProvider.toZipPath(path).setAttribute(attribute, value, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFileSystem(Path zfpath, ZipFileSystem zfs) throws IOException {
        Map<Path, ZipFileSystem> map = this.filesystems;
        synchronized (map) {
            try {
                zfpath = zfpath.toRealPath(new LinkOption[0]);
                if (this.filesystems.get(zfpath) == zfs) {
                    this.filesystems.remove(zfpath);
                }
            }
            catch (IOException e) {
                this.filesystems.values().remove(zfpath);
                throw e;
            }
        }
    }
}

