/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface StatelessParametersHolder {
    @NotNull
    public Collection<String> getParameters();

    public boolean isParameterValueValid(@NotNull String var1, @NotNull String var2);

    @Nullable
    public String getParameterConfig(@NotNull String var1);

    @Nullable
    public String getParameterType(@NotNull String var1);

    @Nullable
    public String getParameterDefValue(@NotNull String var1);

    public static abstract class StatelessParametersHolderDelegate
    implements StatelessParametersHolder {
        @Nullable
        protected abstract StatelessParametersHolder getParametersHolderDelegate();

        @Override
        @NotNull
        public Collection<String> getParameters() {
            Collection<String> collection = this.getParametersHolderDelegate() != null ? this.getParametersHolderDelegate().getParameters() : Collections.emptyList();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/StatelessParametersHolder$StatelessParametersHolderDelegate", "getParameters"));
            }
            return collection;
        }

        @Override
        public boolean isParameterValueValid(@NotNull String key, @NotNull String value) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dataSource/url/template/StatelessParametersHolder$StatelessParametersHolderDelegate", "isParameterValueValid"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/dataSource/url/template/StatelessParametersHolder$StatelessParametersHolderDelegate", "isParameterValueValid"));
            }
            return this.getParametersHolderDelegate() == null || this.getParametersHolderDelegate().isParameterValueValid(key, value);
        }

        @Override
        @Nullable
        public String getParameterConfig(@NotNull String param) {
            if (param == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/intellij/database/dataSource/url/template/StatelessParametersHolder$StatelessParametersHolderDelegate", "getParameterConfig"));
            }
            return this.getParametersHolderDelegate() != null ? this.getParametersHolderDelegate().getParameterConfig(param) : null;
        }

        @Override
        @Nullable
        public String getParameterType(@NotNull String key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dataSource/url/template/StatelessParametersHolder$StatelessParametersHolderDelegate", "getParameterType"));
            }
            return this.getParametersHolderDelegate() != null ? this.getParametersHolderDelegate().getParameterType(key) : null;
        }

        @Override
        @Nullable
        public String getParameterDefValue(@NotNull String key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dataSource/url/template/StatelessParametersHolder$StatelessParametersHolderDelegate", "getParameterDefValue"));
            }
            return this.getParametersHolderDelegate() != null ? this.getParametersHolderDelegate().getParameterDefValue(key) : null;
        }
    }
}

