/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import com.intellij.database.dataSource.url.template.PatternBuilder;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.database.dataSource.url.template.StatelessTextDecompositionBuilder;
import com.intellij.database.dataSource.url.template.TextDecomposition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatelessTextDecomposition
implements StatelessParametersHolder {
    private final ListChoiceNode myNode;
    private final Map<String, ParameterNode> myParameters;

    public static StatelessTextDecomposition build(@NotNull String template, @NotNull TextDecomposition.PatternFactory patterns) throws InvalidTemplateException {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition", "build"));
        }
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition", "build"));
        }
        return new StatelessTextDecomposition(StatelessTextDecompositionBuilder.build(template, patterns));
    }

    private StatelessTextDecomposition(@NotNull Node node) throws InvalidTemplateException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition", "<init>"));
        }
        this.myNode = new ListChoiceNode(node);
        this.myParameters = ContainerUtil.newLinkedHashMap();
        this.findParameters(this.myNode);
    }

    public ListChoiceNode getNode() {
        return this.myNode;
    }

    public boolean isTextValid(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition", "isTextValid"));
        }
        return this.myNode.compilePattern().matcher(text).matches();
    }

    private void findParameters(@NotNull Node node) throws InvalidTemplateException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition", "findParameters"));
        }
        ParameterNode param = (ParameterNode)ObjectUtils.tryCast((Object)node, ParameterNode.class);
        if (param != null && param.getName() != null && null != this.myParameters.put(param.getName(), param)) {
            throw new InvalidTemplateException("Duplicate parameter: " + param.getName());
        }
        for (Node c : node.getChildren()) {
            this.findParameters(c);
        }
    }

    @Override
    public boolean isParameterValueValid(@NotNull String key, @NotNull String value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition", "isParameterValueValid"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition", "isParameterValueValid"));
        }
        ParameterNode param = this.myParameters.get(key);
        return param != null && param.compilePattern().matcher(value).matches();
    }

    @Override
    @Nullable
    public String getParameterType(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition", "getParameterType"));
        }
        ParameterNode param = this.myParameters.get(key);
        return param == null ? null : param.getType();
    }

    @Override
    @Nullable
    public String getParameterDefValue(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition", "getParameterDefValue"));
        }
        ParameterNode param = this.myParameters.get(key);
        return param == null ? null : param.getDefValue();
    }

    @Override
    @NotNull
    public Collection<String> getParameters() {
        Set<String> set = this.myParameters.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition", "getParameters"));
        }
        return set;
    }

    @NotNull
    public String getPattern() {
        String string = this.myNode.getPattern();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition", "getPattern"));
        }
        return string;
    }

    @Override
    @Nullable
    public String getParameterConfig(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition", "getParameterConfig"));
        }
        ParameterNode param = this.myParameters.get(key);
        return param == null ? null : param.getConfiguration();
    }

    public static class InvalidTemplateException
    extends Exception {
        public InvalidTemplateException(@NotNull String msg) {
            if (msg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$InvalidTemplateException", "<init>"));
            }
            super(msg);
        }
    }

    public static class FollowBuilder {
        Map<Node, Set<String>> myFirsts;
        Map<Node, Set<String>> myFollows;
        Map<Node, Boolean> myCanBeEmpty;

        public static void buildFollow(@NotNull Node node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "buildFollow"));
            }
            new FollowBuilder(node);
        }

        private FollowBuilder(@NotNull Node node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "<init>"));
            }
            this.myFirsts = ContainerUtil.newHashMap();
            this.myFollows = ContainerUtil.newHashMap();
            this.myCanBeEmpty = ContainerUtil.newHashMap();
            this.addFollow(node, Collections.singleton("$"));
            this.collectChildFollows(node);
            this.assignIncrementalPatterns(node);
        }

        public boolean assignIncrementalPatterns(@NotNull Node node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "assignIncrementalPatterns"));
            }
            boolean greedyRecover = false;
            for (Node c : node.getChildren()) {
                greedyRecover = this.assignIncrementalPatterns(c);
            }
            greedyRecover |= node instanceof ListNode;
            PatternBuilder lookahead = PatternBuilder.build("");
            boolean first = true;
            Set<String> follow = this.getFollow(node);
            for (String s : follow) {
                if (!first) {
                    lookahead.append("|");
                } else {
                    first = false;
                }
                lookahead.append(s);
            }
            lookahead.positiveLookahead();
            PatternBuilder incremental = PatternBuilder.build(node.getPattern()).group();
            if (!(node instanceof TextNode)) {
                incremental.append(lookahead);
            }
            node.setIncrementalPattern(incremental.toString());
            String recover = greedyRecover ? ".*" : ".*?";
            node.setRecoverPattern(PatternBuilder.build(recover).group().append(lookahead).toString());
            return greedyRecover;
        }

        public void collectChildFollows(@NotNull Node parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "collectChildFollows"));
            }
            if (parent.getClass() == CompositeNode.class) {
                this.collectChildFollows((CompositeNode)parent);
            } else if (parent.getClass() == OptionalNode.class) {
                this.collectChildFollows((OptionalNode)parent);
            } else if (parent.getClass() == ParameterNode.class) {
                this.collectChildFollows((ParameterNode)parent);
            } else if (parent.getClass() == TextNode.class) {
                this.collectChildFollows((TextNode)parent);
            } else if (parent.getClass() == ListChoicesNode.class) {
                this.collectChildFollows((ListChoicesNode)parent);
            } else if (parent.getClass() == ListChoiceNode.class) {
                this.collectChildFollows((ListChoiceNode)parent);
            } else if (parent.getClass() == ListNode.class) {
                this.collectChildFollows((ListNode)parent);
            } else if (parent.getClass() == AntiNode.class) {
                this.collectChildFollows((AntiNode)parent);
            } else assert (false);
        }

        public void collectChildFollows(@NotNull AntiNode parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "collectChildFollows"));
            }
            this.addFollow(parent.getChildren()[0], this.getFollow(parent));
            this.collectChildFollows(parent.getChildren()[0]);
            Set<String> filter = this.getFirst(parent.getChildren()[0]);
            this.setCanBeEmpty(parent, true);
            this.filterFirst(parent, filter);
            this.filterFollow(parent, filter);
        }

        public void collectChildFollows(@NotNull ParameterNode parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "collectChildFollows"));
            }
            this.setCanBeEmpty(parent, parent.compilePattern().matcher("").matches());
            this.addFirst(parent, Collections.singleton(parent.getPattern()));
        }

        public void collectChildFollows(@NotNull ListChoiceNode parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "collectChildFollows"));
            }
            Node node = parent.getChildren()[0];
            this.addFollow(node, this.getFollow(parent));
            this.collectChildFollows(node);
            this.setCanBeEmpty(parent, this.canBeEmpty(node));
            this.addFirst(parent, this.getFirst(node));
        }

        public void collectChildFollows(@NotNull TextNode parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "collectChildFollows"));
            }
            this.setCanBeEmpty(parent, StringUtil.isEmpty((String)parent.getText()));
            this.addFirst(parent, Collections.singleton(parent.getPattern()));
        }

        public void collectChildFollows(@NotNull OptionalNode parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "collectChildFollows"));
            }
            this.addFollow(parent.getChildren()[0], this.getFollow(parent));
            this.collectChildFollows(parent.getChildren()[0]);
            this.setCanBeEmpty(parent, true);
            this.addFirst(parent, this.getFirst(parent.getChildren()[0]));
        }

        public void collectChildFollows(@NotNull ListChoicesNode parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "collectChildFollows"));
            }
            Node[] children = parent.getChildren();
            for (int i2 = children.length - 1; i2 >= 0; --i2) {
                Node node = children[i2];
                this.addFollow(node, this.getFollow(parent));
                this.collectChildFollows(node);
            }
            boolean canBeEmpty = false;
            for (Node child : children) {
                this.addFirst(parent, this.getFirst(child));
                if (canBeEmpty || !this.canBeEmpty(child)) continue;
                canBeEmpty = true;
            }
            this.setCanBeEmpty(parent, canBeEmpty);
        }

        public void collectChildFollows(@NotNull ListNode parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "collectChildFollows"));
            }
            this.addFollow(parent.getChoice(), Collections.singleton(Pattern.quote(parent.getSeparator())));
            this.addFollow(parent.getChoice(), Collections.singleton("$"));
            this.collectChildFollows(parent.getChoice());
            this.setCanBeEmpty(parent, this.canBeEmpty(parent.getChoice()));
            this.addFirst(parent, this.getFirst(parent.getChoice()));
        }

        public void collectChildFollows(@NotNull CompositeNode parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "collectChildFollows"));
            }
            Node[] children = parent.getChildren();
            if (children.length != 0) {
                Node last = children[children.length - 1];
                this.addFollow(last, this.getFollow(parent));
                this.collectChildFollows(last);
            }
            for (int i2 = children.length - 2; i2 >= 0; --i2) {
                Node node = children[i2];
                Node next = children[i2 + 1];
                this.addFollow(node, this.getFirst(next));
                if (this.canBeEmpty(next)) {
                    this.addFollow(node, this.getFollow(next));
                }
                this.collectChildFollows(node);
            }
            boolean canBeEmpty = true;
            for (Node child : children) {
                this.addFirst(parent, this.getFirst(child));
                if (this.canBeEmpty(child)) continue;
                canBeEmpty = false;
                break;
            }
            this.setCanBeEmpty(parent, canBeEmpty);
        }

        private void addFirst(@NotNull Node node, @NotNull Collection<String> add) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "addFirst"));
            }
            if (add == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "add", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "addFirst"));
            }
            FollowBuilder.addToMap(this.myFirsts, node, add);
        }

        private void filterFirst(@NotNull Node node, @NotNull Collection<String> filter) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "filterFirst"));
            }
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "filterFirst"));
            }
            FollowBuilder.filterMap(this.myFirsts, node, filter);
        }

        private void addFollow(@NotNull Node node, @NotNull Collection<String> add) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "addFollow"));
            }
            if (add == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "add", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "addFollow"));
            }
            FollowBuilder.addToMap(this.myFollows, node, add);
        }

        private void filterFollow(@NotNull Node node, @NotNull Collection<String> filter) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "filterFollow"));
            }
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "filterFollow"));
            }
            FollowBuilder.filterMap(this.myFollows, node, filter);
        }

        @NotNull
        private Set<String> getFirst(@NotNull Node node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "getFirst"));
            }
            Set set = (Set)ObjectUtils.assertNotNull(this.myFirsts.get(node));
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "getFirst"));
            }
            return set;
        }

        @NotNull
        private Set<String> getFollow(@NotNull Node node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "getFollow"));
            }
            Set set = (Set)ObjectUtils.assertNotNull(this.myFollows.get(node));
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "getFollow"));
            }
            return set;
        }

        private void setCanBeEmpty(@NotNull Node node, boolean can) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "setCanBeEmpty"));
            }
            this.myCanBeEmpty.put(node, can);
        }

        private boolean canBeEmpty(@NotNull Node node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "canBeEmpty"));
            }
            return this.myCanBeEmpty.get(node);
        }

        private static void addToMap(@NotNull Map<Node, Set<String>> map, @NotNull Node node, @NotNull Collection<String> add) {
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "addToMap"));
            }
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "addToMap"));
            }
            if (add == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "add", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "addToMap"));
            }
            HashSet subset = map.get(node);
            if (subset == null) {
                subset = ContainerUtil.newHashSet();
                map.put(node, subset);
            }
            subset.addAll(add);
        }

        private static void filterMap(@NotNull Map<Node, Set<String>> map, @NotNull Node node, @NotNull Collection<String> filter) {
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "filterMap"));
            }
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "filterMap"));
            }
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$FollowBuilder", "filterMap"));
            }
            HashSet subset = map.get(node);
            if (subset == null) {
                subset = ContainerUtil.newHashSet();
                map.put(node, subset);
            }
            subset.removeAll(filter);
        }
    }

    public static class ListNode
    extends Node {
        private final String mySeparator;

        public ListNode(@NotNull ListChoicesNode choice, @NotNull String separator) {
            if (choice == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "choice", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ListNode", "<init>"));
            }
            if (separator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ListNode", "<init>"));
            }
            super(new Node[]{choice}, ListNode.createPattern(choice.getPattern(), separator), 2 * PatternBuilder.countGroups(choice.getPattern()) + 1, false);
            this.mySeparator = separator;
        }

        @NotNull
        public String getSeparator() {
            String string = this.mySeparator;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ListNode", "getSeparator"));
            }
            return string;
        }

        @NotNull
        public ListChoicesNode getChoice() {
            ListChoicesNode listChoicesNode = (ListChoicesNode)this.getChildren()[0];
            if (listChoicesNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ListNode", "getChoice"));
            }
            return listChoicesNode;
        }

        private static String createPattern(@NotNull String p, @NotNull String sep) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ListNode", "createPattern"));
            }
            if (sep == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sep", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ListNode", "createPattern"));
            }
            return PatternBuilder.build(p).group().push().append(sep).quote().push().append(p).group().pop().group().any().pop().matchingGroup().toString();
        }
    }

    public static class ListChoicesNode
    extends Node {
        public ListChoicesNode(@NotNull ListChoiceNode[] choices) {
            if (choices == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "choices", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ListChoicesNode", "<init>"));
            }
            super(choices, ListChoicesNode.createPattern(choices), ListChoicesNode.countGroups(choices), false);
        }

        private static String createPattern(@NotNull ListChoiceNode[] choices) {
            if (choices == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "choices", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ListChoicesNode", "createPattern"));
            }
            PatternBuilder b = PatternBuilder.build("");
            boolean first = true;
            for (ListChoiceNode choice : choices) {
                if (!first) {
                    b.append("|");
                } else {
                    first = false;
                }
                b.append(choice.getPattern());
            }
            return b.toString();
        }

        private static int countGroups(@NotNull ListChoiceNode[] choices) {
            if (choices == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "choices", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ListChoicesNode", "countGroups"));
            }
            int g = 0;
            for (ListChoiceNode choice : choices) {
                g += choice.getContainingGroups();
            }
            return g;
        }
    }

    public static class ListChoiceNode
    extends Node {
        public ListChoiceNode(@NotNull Node child) {
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ListChoiceNode", "<init>"));
            }
            super(new Node[]{child}, ListChoiceNode.createPattern(child), ListChoiceNode.countGroups(child), child.isEarlyMatchable());
        }

        private static int countGroups(@NotNull Node child) {
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ListChoiceNode", "countGroups"));
            }
            return child.getContainingGroups() + (child instanceof OptionalNode ? 1 : 0);
        }

        private static String createPattern(@NotNull Node child) {
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ListChoiceNode", "createPattern"));
            }
            PatternBuilder builder = PatternBuilder.build(child.getPattern());
            if (child instanceof OptionalNode) {
                builder.matchingGroup();
            }
            return builder.toString();
        }
    }

    public static class CompositeNode
    extends Node {
        public CompositeNode(@NotNull Node[] children) {
            if (children == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$CompositeNode", "<init>"));
            }
            super(children, CompositeNode.createPattern(children), CompositeNode.countGroups(children), CompositeNode.allEarlyMatchable(children));
        }

        private static String createPattern(@NotNull Node[] children) {
            if (children == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$CompositeNode", "createPattern"));
            }
            PatternBuilder b = PatternBuilder.build("");
            for (Node child : children) {
                b.append(child.getPattern());
            }
            return b.matchingGroup().toString();
        }

        private static boolean allEarlyMatchable(@NotNull Node[] children) {
            if (children == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$CompositeNode", "allEarlyMatchable"));
            }
            boolean earlyMatchable = true;
            for (Node child : children) {
                earlyMatchable &= child.isEarlyMatchable();
            }
            return earlyMatchable;
        }

        private static int countGroups(@NotNull Node[] children) {
            if (children == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$CompositeNode", "countGroups"));
            }
            int g = 0;
            for (Node child : children) {
                g += PatternBuilder.countGroups(child.getPattern());
            }
            return g + 1;
        }
    }

    public static class OptionalNode
    extends Node {
        public OptionalNode(@NotNull Node child) {
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$OptionalNode", "<init>"));
            }
            super(new Node[]{child}, OptionalNode.createPattern(child), OptionalNode.countGroups(child), child.isEarlyMatchable());
        }

        private static int countGroups(@NotNull Node child) {
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$OptionalNode", "countGroups"));
            }
            return child.getContainingGroups();
        }

        private static String createPattern(@NotNull Node child) {
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$OptionalNode", "createPattern"));
            }
            return PatternBuilder.build(child.getPattern()).opt().toString();
        }
    }

    public static class ParameterNode
    extends Node {
        private final String myName;
        private final String myType;
        private final String myDefValue;
        private final String myConfiguration;

        public ParameterNode(@Nullable String name, @NotNull String type, @Nullable String defValue, @Nullable String configuration, @NotNull Pattern pattern) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ParameterNode", "<init>"));
            }
            if (pattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ParameterNode", "<init>"));
            }
            super(NO_CHILDREN, PatternBuilder.build(pattern).matchingGroup().toString(), PatternBuilder.countGroups(pattern) + 1, true);
            this.myName = name;
            this.myType = type;
            this.myDefValue = defValue;
            this.myConfiguration = configuration;
        }

        @NotNull
        public String getType() {
            String string = this.myType;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$ParameterNode", "getType"));
            }
            return string;
        }

        @Nullable
        public String getName() {
            return this.myName;
        }

        @Nullable
        public String getDefValue() {
            return this.myDefValue;
        }

        @Nullable
        public String getConfiguration() {
            return this.myConfiguration;
        }
    }

    public static class AntiNode
    extends Node {
        public AntiNode(@NotNull Node child) {
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$AntiNode", "<init>"));
            }
            super(new Node[]{child}, AntiNode.createPattern(child), AntiNode.countGroups(child), child.isEarlyMatchable());
        }

        private static int countGroups(@NotNull Node child) {
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$AntiNode", "countGroups"));
            }
            return child.getContainingGroups();
        }

        private static String createPattern(@NotNull Node child) {
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$AntiNode", "createPattern"));
            }
            return PatternBuilder.build(child.getPattern()).negativeLookahead().toString();
        }
    }

    public static class TextNode
    extends Node {
        private final String myText;

        public TextNode(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$TextNode", "<init>"));
            }
            super(NO_CHILDREN, PatternBuilder.build(text).quote().matchingGroup().toString(), 1, true);
            this.myText = text;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$TextNode", "getText"));
            }
            return string;
        }
    }

    public static abstract class Node {
        protected static final Node[] NO_CHILDREN = new Node[0];
        private final Node[] children;
        private final String myPattern;
        private String myIncrementalPattern;
        private String myRecoverPattern;
        private final int myContainingGroups;
        private final boolean myEarlyMatchable;

        public Node(@NotNull Node[] children, @NotNull String pattern, int groups, boolean earlyMatchable) {
            if (children == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$Node", "<init>"));
            }
            if (pattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$Node", "<init>"));
            }
            this.children = children;
            this.myPattern = pattern;
            this.myContainingGroups = groups;
            this.myEarlyMatchable = earlyMatchable;
        }

        public boolean isEarlyMatchable() {
            return this.myEarlyMatchable;
        }

        @NotNull
        public Node[] getChildren() {
            if (this.children == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$Node", "getChildren"));
            }
            return this.children;
        }

        @NotNull
        public String getPattern() {
            String string = this.myPattern;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$Node", "getPattern"));
            }
            return string;
        }

        @NotNull
        public Pattern compilePattern() {
            Pattern pattern = PatternBuilder.compile(this.getPattern());
            if (pattern == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$Node", "compilePattern"));
            }
            return pattern;
        }

        @NotNull
        public String getIncrementalPattern() {
            String string = this.myIncrementalPattern;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$Node", "getIncrementalPattern"));
            }
            return string;
        }

        public int getContainingGroups() {
            return this.myContainingGroups;
        }

        private void setIncrementalPattern(String incrementalPattern) {
            this.myIncrementalPattern = incrementalPattern;
        }

        @NotNull
        public String getRecoverPattern() {
            String string = this.myRecoverPattern;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$Node", "getRecoverPattern"));
            }
            return string;
        }

        @NotNull
        public Pattern compileIncrementalPattern() {
            Pattern pattern = PatternBuilder.compile(this.getIncrementalPattern());
            if (pattern == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$Node", "compileIncrementalPattern"));
            }
            return pattern;
        }

        @NotNull
        public Pattern compileRecoverPattern() {
            Pattern pattern = PatternBuilder.compile(this.getRecoverPattern());
            if (pattern == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/StatelessTextDecomposition$Node", "compileRecoverPattern"));
            }
            return pattern;
        }

        private void setRecoverPattern(String recoverPattern) {
            this.myRecoverPattern = recoverPattern;
        }

        public static enum NodeType {
            TEXT,
            OPTIONAL,
            COMPOSITE,
            PARAMETER,
            PROPERTIES;

        }
    }
}

