/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.IntIntFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class IndexSet<S extends Index> {
    final int[] values;

    IndexSet(int[] indices) {
        this.values = indices;
    }

    public int size() {
        return this.values.length;
    }

    @NotNull
    public int[] asArray() {
        int[] nArray = (int[])this.values.clone();
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/IndexSet", "asArray"));
        }
        return nArray;
    }

    @NotNull
    public List<S> asList() {
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)this.values.length);
        for (int value : this.values) {
            result2.add(this.forValue(value));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/IndexSet", "asList"));
        }
        return arrayList;
    }

    @NotNull
    public JBIterable<S> asIterable() {
        JBIterable jBIterable = new JBIterable<S>(){

            public Iterator<S> iterator() {
                return new JBIterator<S>(){
                    private int myNextValueIdx;

                    protected S nextImpl() {
                        return this.myNextValueIdx < IndexSet.this.values.length ? IndexSet.this.forValue(IndexSet.this.values[this.myNextValueIdx++]) : (Index)this.stop();
                    }
                };
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/IndexSet", "asIterable"));
        }
        return jBIterable;
    }

    @NotNull
    public S first() {
        S s = this.values.length == 0 ? this.forValue(-1) : this.forValue(this.values[0]);
        if (s == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/IndexSet", "first"));
        }
        return s;
    }

    @NotNull
    public S last() {
        S s = this.values.length == 0 ? this.forValue(-1) : this.forValue(this.values[this.values.length - 1]);
        if (s == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/IndexSet", "last"));
        }
        return s;
    }

    protected abstract S forValue(int var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexSet set = (IndexSet)o;
        return Arrays.equals(this.values, set.values);
    }

    public int hashCode() {
        return this.values != null ? Arrays.hashCode(this.values) : 0;
    }

    @NotNull
    protected static int[] convert(IntIntFunction converter, int ... ints) {
        for (int i2 = 0; i2 < ints.length; ++i2) {
            ints[i2] = converter.fun(ints[i2]);
        }
        if (ints == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/IndexSet", "convert"));
        }
        return ints;
    }
}

