/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ImportErrorHandler;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.util.containers.ContainerUtil;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.LinkedTransferQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImporterGenerator {
    private final Thread myReaderThread;
    private final ReaderTask myReaderTask;
    private final LinkedTransferQueue<ReaderTask.Result> myTransferQueue;
    private final ImportInfo myInfo;
    private final ImportErrorHandler myHandler;
    private final ImportManager myManager;
    private boolean myStopped;

    ImporterGenerator(@NotNull ImportInfo info, @NotNull ImportErrorHandler handler, @NotNull ImportManager manager, @NotNull ReaderTask.Input input) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImporterGenerator", "<init>"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/dbimport/ImporterGenerator", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/dbimport/ImporterGenerator", "<init>"));
        }
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/database/dbimport/ImporterGenerator", "<init>"));
        }
        this.myInfo = info;
        this.myHandler = handler;
        this.myManager = manager;
        this.myTransferQueue = new LinkedTransferQueue();
        this.myReaderTask = new ReaderTask(input, this.myTransferQueue);
        this.myReaderThread = new Thread((Runnable)this.myReaderTask, "Import data reader");
    }

    protected void retrieveColumns(@NotNull DatabaseConnection connection) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/ImporterGenerator", "retrieveColumns"));
        }
        DdlBuilder builder = this.myManager.getDialect().sqlSelectAll(ImportManager.createConfiguredBuilder(this.myInfo.getContext()), this.myInfo.getTable(), (DatabaseSystem)this.myInfo.getContext().getDataSource(), null, null, false, 1);
        List<ColumnDescriptor> columns2 = this.getColumns(connection, builder);
        if (columns2 == null) {
            return;
        }
        if (columns2.size() != this.myInfo.getConsumers().size()) {
            throw new IllegalStateException("Column count is different from expected");
        }
        this.myInfo.setConsumers(columns2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private List<ColumnDescriptor> getColumns(@NotNull DatabaseConnection connection, @NotNull DdlBuilder builder) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/ImporterGenerator", "getColumns"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dbimport/ImporterGenerator", "getColumns"));
        }
        Statement statement = connection.createStatement();
        try {
            ResultSet resultSet = statement.executeQuery(builder.getStatement());
            if (resultSet == null) {
                List<ColumnDescriptor> list = null;
                return list;
            }
            List list = ContainerUtil.list((Object[])JdbcEngine.getColumnDescriptors(resultSet, this.myManager.getDialect()));
            return list;
        }
        finally {
            JdbcUtil.closeStatementSafe((Statement)statement);
        }
    }

    @Nullable
    ReaderTask.Importer generate() throws Exception {
        if (this.myStopped) {
            return null;
        }
        ReaderTask.Result result2 = this.receiveParameters();
        if (result2 == ReaderTask.Result.POISON) {
            this.myStopped = true;
            return null;
        }
        return result2.prepare(this.myInfo);
    }

    void stop() {
        this.myReaderTask.stop();
        this.myReaderThread.interrupt();
        this.myHandler.stop();
    }

    void start(@NotNull DatabaseConnection connection) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/ImporterGenerator", "start"));
        }
        this.retrieveColumns(connection);
        this.myReaderThread.start();
        this.myHandler.start();
    }

    @Nullable
    String getError() {
        return this.myReaderTask.getError();
    }

    @NotNull
    private ReaderTask.Result receiveParameters() {
        ReaderTask.Result result2;
        try {
            result2 = this.myTransferQueue.take();
        }
        catch (InterruptedException e) {
            ReaderTask.Result result3 = ReaderTask.Result.POISON;
            if (result3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImporterGenerator", "receiveParameters"));
            }
            return result3;
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImporterGenerator", "receiveParameters"));
        }
        return result2;
    }
}

