/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.data.types.ConversionGraph;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DataConverter;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectToTextConverter {
    private final DatabaseDialect myDialect;
    private final Map<ColumnDescriptor, Function<Object, Object>> myMap;

    public ObjectToTextConverter(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dbimport/ObjectToTextConverter", "<init>"));
        }
        this.myDialect = dialect;
        this.myMap = ContainerUtil.newHashMap();
    }

    @Nullable
    public Object convert(@Nullable Object o, @NotNull ColumnDescriptor columnDescriptor) {
        if (columnDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnDescriptor", "com/intellij/database/dbimport/ObjectToTextConverter", "convert"));
        }
        return o == null ? null : this.getConverter(columnDescriptor).fun(o);
    }

    @NotNull
    private Function<Object, Object> getConverter(@NotNull ColumnDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dbimport/ObjectToTextConverter", "getConverter"));
        }
        Function function = this.myMap.computeIfAbsent(descriptor, columnDescriptor -> this.getNoCached((ColumnDescriptor)columnDescriptor));
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ObjectToTextConverter", "getConverter"));
        }
        return function;
    }

    @NotNull
    private Function<Object, Object> getNoCached(@NotNull ColumnDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dbimport/ObjectToTextConverter", "getNoCached"));
        }
        Function<Object, Object> converter = ObjectToTextConverter.getObjectToTextConverter(descriptor, this.myDialect);
        Function<Object, Object> function = converter == null ? o -> o : converter;
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ObjectToTextConverter", "getNoCached"));
        }
        return function;
    }

    @Nullable
    private static Function<Object, Object> getObjectToTextConverter(@NotNull ColumnDescriptor descriptor, @NotNull DatabaseDialect dialect) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dbimport/ObjectToTextConverter", "getObjectToTextConverter"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dbimport/ObjectToTextConverter", "getObjectToTextConverter"));
        }
        Function<Object, Object> converter = ConversionGraph.getConverter(ConversionPoint.UNKNOWN, ConversionPoint.TEXT);
        return converter == null ? null : DataConverter.ObjectToText.tweak(converter, descriptor, dialect);
    }
}

