/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;

public abstract class TypeMerger {
    @NotNull
    private final String myName;
    @NotNull
    private final Consumer<String> myConsumer;
    private final int myPriority;

    TypeMerger(@NotNull String name, @NotNull Consumer<String> consumer, int priority) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dbimport/TypeMerger", "<init>"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dbimport/TypeMerger", "<init>"));
        }
        this.myName = name;
        this.myConsumer = consumer;
        this.myPriority = priority;
    }

    public int getPriority() {
        return this.myPriority;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/TypeMerger", "getName"));
        }
        return string;
    }

    public boolean isSuitable(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/dbimport/TypeMerger", "isSuitable"));
        }
        try {
            this.myConsumer.consume((Object)s);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public TypeMerger merge(@NotNull TypeMerger toMerge) {
        if (toMerge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toMerge", "com/intellij/database/dbimport/TypeMerger", "merge"));
        }
        int priority = toMerge.getPriority();
        if (this.getPriority() > priority) {
            return this;
        }
        return toMerge;
    }

    public static class IntegerMerger
    extends TypeMerger {
        public IntegerMerger(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dbimport/TypeMerger$IntegerMerger", "<init>"));
            }
            super(name, (Consumer<String>)((Consumer)Integer::valueOf), 0);
        }
    }

    public static class DoubleMerger
    extends TypeMerger {
        public DoubleMerger(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dbimport/TypeMerger$DoubleMerger", "<init>"));
            }
            super(name, (Consumer<String>)((Consumer)Double::valueOf), 1);
        }
    }

    public static class StringMerger
    extends TypeMerger {
        public StringMerger(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dbimport/TypeMerger$StringMerger", "<init>"));
            }
            super(name, (Consumer<String>)((Consumer)s -> {}), 2);
        }
    }
}

